/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.report.ObjectFactory;
import com.sas.metadata.logical.report.RBUtil;
import com.sas.metadata.logical.report.ReportComponentType;
import com.sas.metadata.logical.report.ReportImageType;
import com.sas.metadata.logical.report.ReportLogicalObject;
import com.sas.metadata.logical.report.ReportType;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class ActionTestContent
extends AbstractAction {
    private static final Logger log = Logger.getLogger(ActionTestContent.class.getName());
    private Frame _frame;
    private Root _root;

    public ActionTestContent(Frame frame, LogicalObjectInterface logicalObj, Root root, ObjectFactory objectFactory, Config config) {
        log.fine("entering");
        this._frame = frame;
        this._root = root;
        this.putValue("Name", "Create Test Report with Content (development only)");
        String strMneumonic = null;
        if (strMneumonic != null) {
            this.putValue("MnemonicKey", new Integer(strMneumonic.charAt(0)));
        }
        this.putValue("ShortDescription", "Creates a report with caches and content");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        log.fine("event = " + event);
        this._frame.setCursor(Cursor.getPredefinedCursor(3));
        OutputStream oStream = null;
        String rootName = "";
        try {
            rootName = this._root.getName();
            String uniqueStr = Long.toHexString(System.currentTimeMillis());
            int uniqueStrLen = uniqueStr.length();
            String rptName = "TestReport" + uniqueStr.substring(uniqueStrLen - 4) + ".srx";
            log.info("Creating test report, name = " + rptName);
            UtilReportServices rs = UtilReportServices.getInstance();
            DirectoryInterface dir = rs.getDirectory(this._root);
            log.info("Parent dir = " + dir);
            EntryInterface report = dir.createEntry(rptName);
            oStream = report.getOutputStream();
            String name = report.getName();
            log.fine("Adding content to '" + name + "'...");
            this.addContent(name, oStream);
            oStream.close();
            CacheSetInterface cacheSet = report.getCacheSetInterface();
            for (int i = 1; i <= 2; ++i) {
                CacheInterface cache = cacheSet.create("Cache-" + i);
                log.fine(cache.getName());
                for (int j = 1; j <= 3; ++j) {
                    CacheItemInterface cacheItem = cache.create("CacheItem-" + i + "." + j);
                    log.fine(cacheItem.getName());
                    oStream = cacheItem.getOutputStream();
                    this.addContent(cacheItem.getName(), oStream);
                    oStream.close();
                }
            }
            this.updateViewWithNewReport(report);
        }
        catch (Exception e) {
            String msg = "Test Content Action failed for root = '" + rootName + "'";
            log.warning(msg);
            UtilGui.displayError((String)msg);
        }
        finally {
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (Exception exception) {}
            }
            this._frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private String addContent(String name, OutputStream oStream) throws Exception {
        StringBuffer contentBuf = new StringBuffer();
        contentBuf.append("<Name>").append(name).append("</Name>\n");
        contentBuf.append("<Created>").append(new Date().toString()).append("</Created>\n");
        contentBuf.append("<Data>");
        String timeStamp = Long.toHexString((long)oStream.hashCode() + System.currentTimeMillis());
        for (int i = 0; i < 1000; ++i) {
            contentBuf.append(timeStamp);
        }
        contentBuf.append("</Data>/n");
        String content = contentBuf.toString();
        oStream.write(content.getBytes(), 0, content.length());
        return content;
    }

    private void updateViewWithNewReport(EntryInterface newReport) {
        try {
            MetadataInterface smartObj = (MetadataInterface)newReport.getMetadataObject();
            Transformation remoteTransformation = (Transformation)smartObj.getRepositoryEntity();
            Factory factory = Factory.getInstance();
            String _publicType = remoteTransformation.getPublicType();
            TypeInterface type = null;
            if (_publicType.equals("Report")) {
                type = ReportType.getInstance(factory, factory.getTypeDescriptorFromTypeDictionary("Report"));
            }
            if (_publicType.equals("Report.Image")) {
                type = ReportImageType.getInstance(factory, factory.getTypeDescriptorFromTypeDictionary("Report.Image"));
            }
            if (_publicType.equals("Report.Component")) {
                type = ReportComponentType.getInstance(factory, factory.getTypeDescriptorFromTypeDictionary("Report.Component"));
            }
            ReportLogicalObject rptLogicalObj = new ReportLogicalObject(remoteTransformation, type, factory);
            this.firePropertyChange(Factory.EVENT_MEMBER_ADDED, null, (Object)rptLogicalObj);
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (LogicalTypeException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
    }
}

