/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.report.DependentTypesHelper;
import com.sas.metadata.logical.report.ImagesReport;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.RBUtil;
import com.sas.metadata.logical.report.ReportFileNameFilter;
import com.sas.metadata.logical.report.ReportLogicalObject;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.report.repository.AddContentPostProcessorInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryCreatorInterface;
import com.sas.report.repository.EntryInstantiatorInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.ReportFileFilter;
import com.sas.report.repository.ReportTypeDescriptor;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.UtilReportReposService;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.DocumentInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ActionImportReportContent
extends AbstractAction {
    private static final Logger log = Logger.getLogger(ActionImportReportContent.class.getName());
    private static final String OVERWRITE_OPTION_YES = RB.getStringResource("ActionImportReportContent.Overwrite_Option_Yes.txt");
    private static final String OVERWRITE_OPTION_YES_TO_ALL = RB.getStringResource("ActionImportReportContent.Overwrite_Option_Yes_To_All.txt");
    private static final String OVERWRITE_OPTION_NO = RB.getStringResource("ActionImportReportContent.Overwrite_Option_No.txt");
    private static final String OVERWRITE_OPTION_NO_TO_ALL = RB.getStringResource("ActionImportReportContent.Overwrite_Option_No_To_All.txt");
    private static final int COPYBUFFERSIZE = 4096;
    private static final String REPORT_TYPE_EXT = ".SRX";
    private Frame _frame;
    private Root _root;
    MdObjectStore _objectStore;
    private boolean _overWriteAll = false;
    private boolean _overWriteEntry = false;
    private boolean _showConfirmOverwriteDialog = true;
    private String _description;
    private String publicType;
    private String publicType_description;

    public ActionImportReportContent(Frame frame, LogicalObjectInterface logicalObj, Root root, ObjectFactoryInterface objectFactory, Config config) {
        this._frame = frame;
        this._root = root;
        this.putValue("Name", RB.getStringResource("ActionImportReportContent.Name.txt"));
        ImageIcon icon = ImagesReport.getReportContentImportIcon16();
        this.putValue("SmallIcon", icon);
        String strMneumonic = RB.getStringResource("ActionImportReportContent.Mnemonic.txt");
        if (strMneumonic != null) {
            this.putValue("MnemonicKey", new Integer(strMneumonic.charAt(0)));
        }
        String strDesc = RB.getStringResource("ActionImportReportContent.Desc.txt");
        this.putValue("ShortDescription", strDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        this._frame.setCursor(Cursor.getPredefinedCursor(3));
        String name = null;
        try {
            name = this._root.getName();
            UtilReportServices rs = UtilReportServices.getInstance();
            DirectoryInterface dir = rs.getDirectory(this._root);
            this._description = null;
            File[] files = this.getFilesToImport();
            if (files.length > 0) {
                this.importFiles(files, dir, true, null);
            }
        }
        catch (Exception e) {
            String msg = RBUtil.getStringResource("ActionImportReportContent.ErrorDialog.msg.fmt.txt", name);
            log.log(Level.WARNING, msg, e);
            UtilGui.displayError((String)msg);
        }
        finally {
            this.disposeOfTempObjectStore();
            this._frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void importFiles(File[] files, DirectoryInterface dir, boolean topLevel, String description) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                if (!file.exists()) {
                    String msg = RBUtil.getStringResource("RIL.CannotGetContent.fmt.txt", file.getAbsolutePath());
                    log.log(Level.WARNING, msg);
                    UtilGui.displayWarning((String)msg);
                    continue;
                }
                if (file.isDirectory()) {
                    DirectoryInterface subDir;
                    if (dir.entryExists(file.getName())) {
                        subDir = (DirectoryInterface)dir.getEntry(file.getName());
                    } else {
                        subDir = dir.createDirectory(file.getName());
                        if (topLevel) {
                            this.updateViewWithNewFolder(subDir);
                        }
                    }
                    File[] subFiles = file.listFiles(new ReportFileNameFilter());
                    this.importFiles(subFiles, subDir, false, description);
                } else {
                    boolean isFileExist;
                    String importFileName = this.getImportFileName(file.getName());
                    String importFilePathAndName = this.getImportFileName(file.getPath());
                    int dot = this.publicType.lastIndexOf(".");
                    String reportType = this.publicType;
                    if (dot > 0) {
                        reportType = reportType.substring(0, dot);
                    }
                    String importFileNameWithType = importFileName + "(" + reportType + ")";
                    if (description == null && files.length == 1) {
                        description = this.getDescription();
                        System.err.println("description: " + description);
                    }
                    if (!(isFileExist = dir.entryExists(importFileNameWithType))) {
                        EntryInterface newEntry = this.importFile(dir, file, importFileName);
                        if (!UtilMisc.isStringNullOrEmpty((String)description)) {
                            newEntry.setAttribute("description", (Object)description);
                        }
                        if (topLevel) {
                            this.updateViewWithNewReport(newEntry);
                        }
                    } else {
                        EntryInterface existingEntry = dir.getEntry(importFileNameWithType);
                        MetadataInterface omEntryObject = (MetadataInterface)existingEntry.getMetadataObject();
                        Transformation remoteTransformation = (Transformation)omEntryObject.getRepositoryEntity();
                        String _publicType = remoteTransformation.getPublicType();
                        if (_publicType.equals(this.publicType)) {
                            if (this._showConfirmOverwriteDialog) {
                                this.setOverWriteFlags(importFileName);
                            }
                            if (this._overWriteAll || this._overWriteEntry) {
                                List documents = omEntryObject.getDocuments();
                                Iterator iterator = documents.iterator();
                                while (iterator.hasNext()) {
                                    omEntryObject.removeDocument((DocumentInterface)iterator.next());
                                }
                                String tempString = "overwrite";
                                omEntryObject.addKeyword(tempString);
                                List keywords = omEntryObject.getKeywords();
                                iterator = keywords.iterator();
                                while (iterator.hasNext()) {
                                    omEntryObject.removeKeyword((String)iterator.next());
                                }
                                this.importFile(existingEntry, file);
                                if (description != null) {
                                    existingEntry.setAttribute("description", (Object)description);
                                }
                                omEntryObject.update();
                                if (topLevel) {
                                    this.updateViewWithChangedReport(existingEntry);
                                }
                                if (topLevel) {
                                    this.updateViewWithNewReport(existingEntry);
                                }
                            }
                        } else {
                            String msg = RBUtil.getStringResource("ActionImportReportContent.CannotOverwrite.fmt.txt", importFileName, this.publicType_description);
                            UtilGui.displayWarning((String)msg);
                            log.log(Level.WARNING, msg);
                        }
                    }
                }
                log.log(Level.FINE, file.toString());
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString());
                String msg = RBUtil.getStringResource("RIL.AddFailure.fmt.txt", file.getAbsolutePath());
                UtilGui.displayWarning((String)(msg + " Error: See error log. "));
            }
        }
    }

    private String prune(String path) {
        if (path == null) {
            return null;
        }
        int pos = path.lastIndexOf(File.separator);
        if (pos > 0) {
            path = path.substring(pos + 1);
        }
        return path;
    }

    private void updateViewWithNewFolder(DirectoryInterface newDir) throws MdException, LogicalTypeException {
        try {
            MetadataInterface smartObj = (MetadataInterface)newDir.getMetadataObject();
            Tree remoteTree = (Tree)smartObj.getRepositoryEntity();
            String fqid = remoteTree.getFQID();
            String jomaType = remoteTree.getCMetadataType();
            MdObjectStore objectStore = this.getTempObjectStore();
            Tree localTree = (Tree)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)objectStore, jomaType, fqid, null, null, null, 264);
            Factory logicalObjectfactory = Factory.getInstance();
            FolderInterface folderLogicalObj = (FolderInterface)logicalObjectfactory.getObject((Root)localTree);
            objectStore.dispose();
            this.firePropertyChange(Factory.EVENT_FOLDER_ADDED, null, folderLogicalObj);
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newDir.getName()), e);
        }
    }

    private void updateViewWithNewReport(EntryInterface newReport) {
        try {
            Class logicalTypeClass;
            MetadataInterface smartObj = (MetadataInterface)newReport.getMetadataObject();
            Transformation remoteTransformation = (Transformation)smartObj.getRepositoryEntity();
            Factory factory = Factory.getInstance();
            String _publicType = remoteTransformation.getPublicType();
            ServerInterface server = smartObj.getRepository().getServer();
            TypeDescriptorInterface tdi = server.getTypeDescriptor(_publicType);
            String logicalTypeClassName = tdi.getLogicalTypeClassName();
            try {
                logicalTypeClass = Class.forName(logicalTypeClassName);
            }
            catch (Exception e) {
                logicalTypeClass = com.sas.services.information.Factory.getInstance().loadClass(logicalTypeClassName);
            }
            Method method = logicalTypeClass.getMethod("getInstance", Factory.class, TypeDescriptorInterface.class);
            TypeInterface type = (TypeInterface)method.invoke(null, factory, tdi);
            if (type == null) {
                throw new LogicalTypeException("LN");
            }
            ReportLogicalObject rptLogicalObj = new ReportLogicalObject(remoteTransformation, type, factory);
            this.firePropertyChange(Factory.EVENT_MEMBER_ADDED, null, (Object)rptLogicalObj);
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (LogicalTypeException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (ServiceException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (SecurityException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", newReport.getName()), e);
        }
    }

    private void updateViewWithChangedReport(EntryInterface updatedReport) {
        try {
            MetadataInterface smartObj = (MetadataInterface)updatedReport.getMetadataObject();
            Transformation remoteTransformation = (Transformation)smartObj.getRepositoryEntity();
            this.firePropertyChange(Factory.EVENT_MEMBER_UPDATED, null, remoteTransformation.getFQID());
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, RBUtil.getStringResource("ActionImportReportContent.UpdateViewFailed.fmt.txt", updatedReport.getName()), e);
        }
    }

    private MdObjectStore getTempObjectStore() {
        try {
            if (this._objectStore == null || this._objectStore.isDisposed()) {
                this._objectStore = Workspace.getMdFactory().createObjectStore();
            }
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        return this._objectStore;
    }

    private void disposeOfTempObjectStore() {
        try {
            if (this._objectStore == null || this._objectStore.isDisposed()) {
                return;
            }
            this._objectStore.dispose();
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
    }

    private void setOverWriteFlags(String importFileName) {
        this._overWriteEntry = false;
        Object answerObj = this.showOverwriteDialog(importFileName);
        if (answerObj.equals(OVERWRITE_OPTION_YES) || answerObj.equals(OVERWRITE_OPTION_YES_TO_ALL)) {
            this._overWriteEntry = true;
            if (answerObj.equals(OVERWRITE_OPTION_YES_TO_ALL)) {
                this._showConfirmOverwriteDialog = false;
                this._overWriteAll = true;
            }
        } else if (!answerObj.equals(OVERWRITE_OPTION_NO) && answerObj.equals(OVERWRITE_OPTION_NO_TO_ALL)) {
            this._showConfirmOverwriteDialog = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryInterface importFile(EntryInterface entry, File file) throws RepositoryException, SecurityException, RepositoryIOException, IOException {
        FileInputStream iStream = null;
        OutputStream oStream = null;
        try {
            iStream = new FileInputStream(file);
            oStream = entry.getOutputStream(true);
            this.copyContents(iStream, oStream);
        }
        finally {
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (IOException e1) {
                throw new RepositoryIOException((Throwable)e1, e1.getMessage());
            }
        }
        MetadataInterface mi = (MetadataInterface)entry.getMetadataObject();
        ServerInterface server = null;
        try {
            server = mi.getRepository().getServer();
            ReportTypeDescriptor rtd = ReportTypeDescriptor.getInstance((ServerInterface)server, (String)this.publicType);
            AddContentPostProcessorInterface postProcessor = rtd.getAddContentPostProcessor(server, entry);
            if (postProcessor != null) {
                postProcessor.process(server, entry);
            }
        }
        catch (Exception e) {
            String msg = "Unable to post process:  " + file.getName();
            log.log(Level.WARNING, msg, e);
        }
        return entry;
    }

    private EntryInterface importFile(DirectoryInterface dir, File file, String importFilename) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException, RepositoryIOException, IOException {
        EntryInterface entry = null;
        try {
            String nameType = importFilename + "/" + this.publicType;
            entry = dir.createEntry(nameType);
            this.importFile(entry, file);
            return entry;
        }
        catch (Exception e) {
            log.log(Level.WARNING, RBUtil.getStringResource("RIL.AddFailure.fmt.txt", importFilename));
            throw new RepositoryException((Throwable)e, e.getMessage());
        }
    }

    private boolean isFileAReport(File file) {
        return file.getName().toUpperCase().contains(REPORT_TYPE_EXT);
    }

    protected Object showOverwriteDialog(String name) {
        Object[] selectionValues = new String[]{OVERWRITE_OPTION_YES, OVERWRITE_OPTION_YES_TO_ALL, OVERWRITE_OPTION_NO, OVERWRITE_OPTION_NO_TO_ALL};
        String message = RBUtil.getStringResource("ActionImportReportContent.Overwrite.Confirm.fmt.txt", name);
        JOptionPane optionPane = new JOptionPane(message, 3, 0, null, selectionValues);
        JDialog dialog = optionPane.createDialog(this._frame, RB.getStringResource("ActionImportReportContent.Overwrite.Confirm.Title.txt"));
        dialog.setDefaultCloseOperation(0);
        dialog.pack();
        dialog.setVisible(true);
        return optionPane.getValue();
    }

    private String getImportFileName(String name) {
        String returnName = name;
        if (name.endsWith("(Report)")) {
            returnName = name.substring(0, name.lastIndexOf("(Report)"));
        }
        return returnName;
    }

    protected File[] getFilesToImport() {
        File[] returnFiles = new File[]{};
        File currentWorkingDir = UtilReportServices.getCurrentWorkingDir();
        UserContextInterface user = UtilPlatformServices.getUserContext();
        JFileChooser fileChooser = new JFileChooser(currentWorkingDir);
        fileChooser.resetChoosableFileFilters();
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileFilter[] fileFilters = null;
        try {
            fileFilters = ReportTypeDescriptor.getAllAddContentFileFilters((ServerInterface)user.getAuthServer(), (Locale)Locale.getDefault());
        }
        catch (ServiceException e1) {
            e1.printStackTrace();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        FileFilter selectedFilter = null;
        String selectedPublicType = UtilReportServices.getCurrentPublicType();
        for (FileFilter filter : fileFilters) {
            if (selectedPublicType != null && ((ReportFileFilter)filter).getPublicType().equals(selectedPublicType)) {
                selectedFilter = filter;
            }
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle(RB.getStringResource("ActionImportReportContent.FileChooser.title.txt"));
        if (selectedFilter == null) {
            selectedFilter = fileFilters[0];
        }
        fileChooser.setFileFilter(selectedFilter);
        int returnVal = fileChooser.showOpenDialog((Component)Workspace.getWorkspace());
        if (returnVal == 0) {
            FileFilter ff = fileChooser.getFileFilter();
            ReportFileFilter rf = (ReportFileFilter)ff;
            this.publicType_description = rf.getDescription();
            String[] tokens = this.publicType_description.split("\\,");
            this.publicType_description = tokens[0];
            this.publicType = selectedPublicType = rf.getPublicType();
            returnFiles = fileChooser.getSelectedFiles();
            File f = returnFiles[0];
            UtilReportServices.saveCurrentWorkingDir(f.getParentFile());
            UtilReportServices.saveCurrentPublicType(selectedPublicType);
        }
        return returnFiles;
    }

    private void copyContents(InputStream src, OutputStream dest) throws IOException {
        byte[] b = new byte[4096];
        int len = src.read(b);
        while (len > 0) {
            dest.write(b, 0, len);
            len = src.read(b);
        }
    }

    private String getDescription() {
        if (this._description == null) {
            String message = RB.getStringResource("ActionImportReportContent.Description.txt");
            String title = RB.getStringResource("ActionImportReportContent.Description.title.txt");
            this._description = (String)JOptionPane.showInputDialog(this._frame, message, title, -1, null, null, null);
        }
        return this._description;
    }

    private EntryInterface tryUnknownCreate(DirectoryInterface dir, File file, String importFilename) {
        Map map = DependentTypesHelper.getEntryCreatorMap();
        if (map != null) {
            for (String group : map.keySet()) {
                EntryCreatorInterface clazz = (EntryCreatorInterface)map.get(group);
                EntryInterface ei = clazz.createEntry(UtilReportReposService.getOMRID((DirectoryInterface)dir), dir, file, importFilename);
                if (ei == null) continue;
                return ei;
            }
        }
        return null;
    }

    private EntryInstantiatorInterface tryUnknownCreateInstantiator(DirectoryInterface dir, File file, String importFilename) {
        Map map = DependentTypesHelper.getEntryCreatorMap();
        if (map != null) {
            for (String group : map.keySet()) {
                EntryCreatorInterface clazz = (EntryCreatorInterface)map.get(group);
                EntryInstantiatorInterface ei = clazz.createEntryInstantiator(UtilReportReposService.getOMRID((DirectoryInterface)dir), file.getPath() + "|" + this.publicType);
                if (ei == null) continue;
                return ei;
            }
        }
        return null;
    }

    private EntryInterface tryUnknownCreateSimpleInstantiator(DirectoryInterface dir, File file, String importFilename) {
        Map map = DependentTypesHelper.getEntryCreatorMap();
        if (map != null) {
            for (String group : map.keySet()) {
                EntryCreatorInterface clazz = (EntryCreatorInterface)map.get(group);
                EntryInterface ei = clazz.createBogusEntry(null, dir, file, importFilename);
                if (ei == null) continue;
                return ei;
            }
        }
        return null;
    }
}

