/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.report.ImagesReport;
import com.sas.metadata.logical.report.ObjectFactory;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.RBUtil;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Root;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RepositoryIOException;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class ActionExportReportContent
extends AbstractAction {
    private static final Logger log = Logger.getLogger(ActionExportReportContent.class.getName());
    private static final int COPYBUFFERSIZE = 4096;
    private Frame _frame;
    private Root _root;

    public ActionExportReportContent(Frame frame, LogicalObjectInterface logicalObj, Root root, ObjectFactory objectFactory, Config config) {
        log.fine("entering");
        this._frame = frame;
        this._root = root;
        this.putValue("Name", RB.getStringResource("ActionExportReportContent.Name.txt"));
        ImageIcon icon = ImagesReport.getReportContentExportIcon16();
        this.putValue("SmallIcon", icon);
        String strMneumonic = RB.getStringResource("ActionExportReportContent.Mnemonic.txt");
        if (strMneumonic != null) {
            this.putValue("MnemonicKey", new Integer(strMneumonic.charAt(0)));
        }
        String strDesc = RB.getStringResource("ActionExportReportContent.Desc.txt");
        this.putValue("ShortDescription", strDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        log.fine("_DEBUG_:event = " + event);
        this._frame.setCursor(Cursor.getPredefinedCursor(3));
        String name = null;
        try {
            name = this._root.getName();
            UtilReportServices rs = UtilReportServices.getInstance();
            EntryInterface report = rs.getReport(this._root);
            File destFile = this.getDestinationFile(name);
            if (destFile != null) {
                this.exportReport(report, destFile);
            }
        }
        catch (Exception e) {
            String msg = RBUtil.getStringResource("ActionExportReportContent.ErrorDialog.msg.fmt.txt", name);
            String messageText = UtilMisc.getMessage((String)RB.getStringResource("ActionExportReportContent.ErrorDialog.msg.fmt.txt"), (Object)name, (Object)UtilMisc.getExceptionMessageText((Exception)e));
            log.log(Level.WARNING, messageText, e);
            UtilGui.displayError((String)messageText);
        }
        finally {
            this._frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private File getDestinationFile(String name) {
        File destFile;
        int returnVal;
        File currentWorkingDir = UtilReportServices.getCurrentWorkingDir();
        JFileChooser fileChooser = new JFileChooser(currentWorkingDir);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle(RB.getStringResource("ActionExportReportContent.FileChooser.title.txt"));
        if (name != null) {
            fileChooser.setSelectedFile(new File(name));
        }
        if ((returnVal = fileChooser.showSaveDialog((Component)Workspace.getWorkspace())) == 0) {
            destFile = fileChooser.getSelectedFile();
            UtilReportServices.saveCurrentWorkingDir(destFile.getParentFile());
        } else {
            destFile = null;
        }
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportReport(EntryInterface report, File destFile) throws IOException, RepositoryIOException {
        InputStream iStream = null;
        FileOutputStream oStream = null;
        try {
            oStream = new FileOutputStream(destFile);
            iStream = report.getInputStream();
            this.copyContents(iStream, oStream);
        }
        finally {
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void copyContents(InputStream src, OutputStream dest) throws IOException {
        byte[] b = new byte[4096];
        int len = src.read(b);
        while (len > 0) {
            dest.write(b, 0, len);
            len = src.read(b);
        }
    }
}

