/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.report.ImagesReport;
import com.sas.metadata.logical.report.ObjectFactory;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.RBUtil;
import com.sas.metadata.logical.report.RootManager;
import com.sas.metadata.logical.report.scheduling.BatchServers;
import com.sas.metadata.logical.report.scheduling.CreateJob;
import com.sas.metadata.logical.report.scheduling.CreateJobDialog;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;

public class ActionCreateJobEntry
extends AbstractAction {
    private static final Logger log = Logger.getLogger(ActionCreateJobEntry.class.getName());
    private Frame _frame;
    private LogicalObjectInterface[] _logicalObjects;
    private DefaultListModel _reportListModel;
    private Root[] _roots;

    public ActionCreateJobEntry(Frame frame, LogicalObjectInterface logicalObj, Root root, ObjectFactory objectFactory, Config config) {
        log.fine("entering");
        LogicalObjectInterface[] logicalObjects = new LogicalObjectInterface[]{logicalObj};
        Root[] roots = new Root[]{root};
        this.initialize(frame, logicalObjects, roots, objectFactory, config);
    }

    public ActionCreateJobEntry(Frame frame, LogicalObjectInterface[] logicalObjs, Root[] roots, ObjectFactory objectFactory, Config config) {
        log.fine("entering");
        this.initialize(frame, logicalObjs, roots, objectFactory, config);
    }

    private void initialize(Frame frame, LogicalObjectInterface[] logicalObjs, Root[] roots, ObjectFactory objectFactory, Config config) {
        this._frame = frame;
        this._logicalObjects = logicalObjs;
        this._roots = roots;
        this.putValue("Name", RB.getStringResource("ActionCreateJobEntry.Name.txt"));
        String strMneumonic = RB.getStringResource("ActionCreateJobEntry.Mnemonic.txt");
        if (strMneumonic != null) {
            this.putValue("MnemonicKey", new Integer(strMneumonic.charAt(0)));
        }
        String strDesc = RB.getStringResource("ActionCreateJobEntry.Desc.txt");
        this.putValue("ShortDescription", strDesc);
        ImageIcon icon = ImagesReport.getReportScheduleJobIcon16();
        this.putValue("SmallIcon", icon);
        this._reportListModel = new DefaultListModel();
        for (int i = 0; i < this._logicalObjects.length; ++i) {
            this._reportListModel.addElement(this._logicalObjects[i].getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        log.fine("_DEBUG_:actionPerformed, event = " + event);
        RootManager rootMgr = new RootManager();
        try {
            String reposID;
            if (this._logicalObjects.length == 0) {
                log.fine("No report items selected, returning");
                return;
            }
            MdFactory factory = Workspace.getMdFactory();
            MdObjectStore store = factory.createObjectStore(null, "ActionCreateJobEntry");
            if (!this.scheduleServerExists((MdStore)store, reposID = Workspace.getWorkspace().getDefaultRepository().getFQID())) {
                return;
            }
            BatchServers batchServers = new BatchServers((MdStore)store, reposID);
            if (batchServers.size() == 0) {
                String msg = RBUtil.getStringResource("ActionCreateJobEntry.JavaBatchServerError.txt");
                log.warning(msg);
                UtilGui.displayError((String)msg);
                return;
            }
            CreateJobDialog dlg = new CreateJobDialog(this._reportListModel, RB.getStringResource("ActionCreateJobEntry.ListLabelDescription.txt"), batchServers);
            dlg.show();
            if (dlg.isOK()) {
                int serverNdx = dlg.getSelectedJavaBatchServer();
                log.fine("selected batch server index = " + serverNdx);
                ServerComponent batchServerComp = batchServers.get(serverNdx);
                log.fine("selected batch server = " + batchServerComp.getName());
                if (this._roots == null || this._roots.length != this._logicalObjects.length) {
                    this._roots = new Root[this._logicalObjects.length];
                }
                for (int i = 0; i < this._logicalObjects.length; ++i) {
                    this._roots[i] = rootMgr.getNonNullRoot(this._roots[i], this._logicalObjects[i]);
                }
                batchServers.setSelectedIndex(serverNdx);
            }
        }
        catch (Exception e) {
            String msg = RBUtil.getStringResource("ActionCreateJobEntry.ErrorDialog.msg.fmt.txt", Integer.toString(this._logicalObjects.length));
            log.warning(msg);
            UtilGui.displayError((String)msg);
        }
        finally {
            rootMgr.dispose();
        }
    }

    private boolean scheduleServerExists(MdStore store, String reposID) {
        ServerComponent schedulerComponent = CreateJob.getFirstScheduleServer(this._frame, store, reposID, RB.getStringResource("ActionCreateJobEntry.SchedulerError.txt"), RB.getStringResource("ActionCreateJobEntry.NoSchedulerFoundDialog.title.txt"));
        return schedulerComponent != null;
    }
}

