/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.prompts;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.prompts.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PromptImportListener
extends AbstractImportListener {
    private Log logger = Log.getInstance((String)((Object)((Object)this)).getClass().getName());
    protected static final Class[] CONNECTION_TYPES = new Class[0];

    public PromptImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("General.ProjectRepos.txt"));
        }
        int rc = 0;
        this.logger.debug((Object)("analyzeObjectsToImport() N of objects = " + Integer.toString(objects.size())));
        if (!this.containsPrompt(objects)) {
            rc = 8;
        }
        this.logger.debug((Object)("analyzeObjectsToImport() returns " + Integer.toString(rc)));
        return rc;
    }

    private boolean containsPrompt(List depObjList) {
        boolean containsPrompt = false;
        Iterator objItor = depObjList.iterator();
        while (objItor.hasNext() && !containsPrompt) {
            ImportItemInterface item = (ImportItemInterface)objItor.next();
            String type = item.getTypeInterface().getPublicType();
            if (!"Prompt".equals(type) && !"PromptGroup".equals(type)) continue;
            containsPrompt = true;
        }
        return containsPrompt;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int retVal = 0;
        try {
            ArrayList<MetadataInterface> smartObjectsList = new ArrayList<MetadataInterface>();
            for (ImportItemInterface item : objects) {
                this.logger.debug((Object)("import item's name: " + item.getName()));
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("General.StatusIndicator.fmt.txt"), (Object)item.getName()));
                MetadataInterface mi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)item.getTargetID(), (String)item.getTypeInterface().getMetadataType());
                smartObjectsList.add(mi);
                if (operation.getPromotionType() != 2 && operation.getPromotionType() != 3) continue;
                this.resetID(mi);
            }
            PrivateObjectImportUtility.updatePromptPaths((ImportOperationInterface)operation, smartObjectsList);
        }
        catch (ServiceException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MetadataPromotionException((Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MetadataPromotionException((Throwable)e);
        }
        return retVal;
    }

    private void resetID(MetadataInterface mi) throws RemoteException, ServiceException {
        if (mi instanceof OMRPromptDefinitionInterface) {
            this.logger.debug((Object)("resetID() called for prompt logical obj named:" + mi.getName()));
            PromptDefinitionInterface prompt = ((OMRPromptDefinitionInterface)mi).getPromptDefinition();
            if (null != prompt) {
                ((MutablePromptDefinitionInterface)prompt).setPromptID("_SAS_PROMPT_ID_RESET");
                PromptsPersistUtil.updateDefinitionSmartObject((PromptDefinitionInterface)prompt, (UserContextInterface)mi.getRepository().getUserContext(), (OMRPromptDefinitionInterface)((OMRPromptDefinitionInterface)mi), null);
            } else {
                this.logger.info((Object)"resetID() could not reset ID because OMRPromptDefinitionInterface)mi).getPromptDefinition() returned null. ");
            }
        } else if (mi instanceof OMRPromptGroupInterface) {
            this.logger.debug((Object)("resetID() called for prompt group logical obj named:" + mi.getName()));
            PromptGroupInterface prompt = ((OMRPromptGroupInterface)mi).getPromptGroup();
            if (null != prompt && prompt instanceof PromptGroupV2Interface) {
                PromptUtil.resetPromptGroupID((PromptGroupV2Interface)((PromptGroupV2Interface)prompt));
                PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)prompt, (UserContextInterface)mi.getRepository().getUserContext(), (OMRPromptGroupInterface)((OMRPromptGroupInterface)mi), null);
            } else {
                this.logger.info((Object)"resetID() could not reset ID because OMRPromptGroupInterface)mi).getPromptGroup() returned null. ");
            }
        }
    }

    public Class[] getConnectionTypes() {
        return PrivateObjectImportUtility.getPromptConnectionTypes();
    }
}

