/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.prompts;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.prompts.PromptTypesUtil;
import com.sas.metadata.logical.prompts.RB;
import com.sas.metadata.logical.visuals.BIPTreeElementGeneralPropertyTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prompt;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptEditorTabbedPanel;
import com.sas.prompts.visuals.swing.designtime.ConvertToTreeModelUtil;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.OkEnabledOptionsDialog;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.viewdata2.CommonActionsFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSeparator;

class GeneralPromptDefinitionTabPanel
extends BIPTreeElementGeneralPropertyTab
implements PanelInterface {
    protected PromptDefinitionInterface promptDefinitionInterface;
    protected LogicalObjectInterface logicalObject;
    private Root root;
    protected JButton _btnEdit;
    protected Locale locale;
    private String helpID;
    private SASJavaHelp javaHelp;

    public GeneralPromptDefinitionTabPanel(Root root, LogicalObjectInterface logicalObject, PromptDefinitionInterface promptDefinitionInterface, Tree containingTree, TypeInterface ti, Config config) throws RemoteException {
        super(root, containingTree, 1, ti, config);
        this.logicalObject = logicalObject;
        this.root = root;
        this.setHelpProduct("prompts");
        this.helpID = "prompt_generaltab";
        this.setHelpTopic(this.helpID);
        this.promptDefinitionInterface = promptDefinitionInterface;
        this._btnEdit.setEnabled(promptDefinitionInterface instanceof PromptDefinition);
    }

    protected void initialize() {
        super.initialize();
        this.locale = Locale.getDefault();
        this._btnEdit = UtilGui.createButton((String)RB.getStringResource("GeneralPromptDefinitionTabPanel.Edit.txt"));
        this._btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GeneralPromptDefinitionTabPanel.this.processEditButton((PromptDefinition)GeneralPromptDefinitionTabPanel.this.promptDefinitionInterface);
                }
                catch (Exception e) {
                    String messageText = UtilMisc.getMessage((String)RB.getStringResource("GeneralPromptDefinitionTabPanel.editException.fmt.txt"), (Object)GeneralPromptDefinitionTabPanel.this.promptDefinitionInterface.getPromptName(), (Object)UtilMisc.getExceptionMessageText((Exception)e));
                    CommonActionsFactory.ShowMessageExceptionHandler handler = new CommonActionsFactory.ShowMessageExceptionHandler(messageText);
                    handler.errorExecutingAction((Throwable)e);
                }
            }
        });
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        JSeparator separator = new JSeparator();
        separator.setOrientation(0);
        this.add(separator, new GridBagConstraints(0, ++this._layoutRowCount, 0, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this._btnEdit, new GridBagConstraints(0, ++this._layoutRowCount, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (!editable) {
            this._btnEdit.setText(RB.getStringResource("GeneralPromptDefinitionTabPanel.View.txt"));
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        try {
            if (this.root instanceof Prompt) {
                PromptTypesUtil.updatePromptWithPromptDefinition((Prompt)this.root, this.promptDefinitionInterface, this.logicalObject.getTypeInterface().getObjectFactory().getFactory().getMdFactory());
            }
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
    }

    protected void processEditButton(PromptDefinition promptDefinition) {
        JFrame frame = Util.getParentFrame((Component)((Object)this));
        PropertiesCommunicator communicator = new PropertiesCommunicator();
        communicator.setComponentsEnabled(this.isEditable());
        communicator.setUserContext(UtilPlatformServices.getUserContext());
        communicator.setDefaultParentFrame((Frame)frame);
        BasePromptEditorTabbedPanel promptPanel = new BasePromptEditorTabbedPanel((MutablePromptDefinitionInterface)promptDefinition, communicator);
        promptPanel.setHelpProduct("dtprompt");
        if (this.javaHelp == null) {
            this.javaHelp = new SASJavaHelp(this.getHelpProduct(), this.getLocale());
        }
        OkEnabledOptionsDialog dialog = new OkEnabledOptionsDialog((Frame)frame, RB.getStringResource("GeneralPromptDefinitionTabPanel.editPrompt.txt"), true, 11, 4, this.javaHelp);
        ConvertToTreeModelUtil.tileDialog((Window)dialog, (Component)((Object)this));
        dialog.setPanel((PanelInterface)promptPanel);
        dialog.pack();
        dialog.setVisible(true);
        if (!dialog.wasCancelled()) {
            PromptDefinition editedPromptDefinition;
            PromptDefinitionInterface editedPromptDefinitionInterface = ((GetPromptDefinitionInterface)dialog.getPanel()).getPromptDefinition();
            if (editedPromptDefinitionInterface instanceof PromptDefinition && (editedPromptDefinition = (PromptDefinition)editedPromptDefinitionInterface).getClass() == promptDefinition.getClass()) {
                editedPromptDefinition.setPromptID(promptDefinition.getPromptID());
            }
            this.promptDefinitionInterface = editedPromptDefinitionInterface;
        }
    }

    public String getDialogTitle() {
        return null;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public JComponent getPanel() {
        return null;
    }

    public String getTabTitle() {
        return null;
    }

    public boolean isContentsValid() {
        return true;
    }

    public boolean isYesNo() {
        return false;
    }

    public void onApply() {
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public void setContentsValid(boolean newValue) {
    }
}

