/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.project;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.project.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Timestamp;
import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.Project;
import com.sas.services.util.DateUtil;
import java.rmi.RemoteException;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class ProjectLogicalObject
extends LogicalObject {
    protected static final Logger log = Logger.getLogger(ProjectLogicalObject.class.getName());

    ProjectLogicalObject(ClassifierMap classifierMap, TypeInterface ti, Factory factory) throws RemoteException {
        super((Root)classifierMap, ti, factory);
    }

    public Icon getIcon() {
        return this.getTypeInterface().getIcon(1);
    }

    public boolean delete(OperationUserInteractionInterface userInteraction) {
        String progressText = this.getProgressMessageForDelete();
        userInteraction.updateProgress(progressText);
        try {
            Project proj = (Project)UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)this);
            proj.delete();
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            if (userInteraction.continueOperationWithPrompting()) {
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("LogicalObject.DeleteFailedMsg.fmt.txt"), (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)e));
                int choice = userInteraction.displayMessage(RB.getStringResource("LogicalObject.DeleteFailedTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)userInteraction, (int)choice);
            }
            return false;
        }
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return true;
    }

    public void rename(String name, OperationUserInteractionInterface userInteraction) throws LogicalTypeException, RemoteException {
        block2: {
            String progressText = this.getProgressMessageForDelete();
            userInteraction.updateProgress(progressText);
            try {
                Project proj = (Project)UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)this);
                proj.rename(name);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                if (!userInteraction.continueOperationWithPrompting()) break block2;
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("LogicalObject.RenameFailedMsg.fmt.txt"), (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)e));
                int choice = userInteraction.displayMessage(RB.getStringResource("LogicalObject.RenameFailedTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)userInteraction, (int)choice);
            }
        }
    }

    static String convertToSasDate(double javaDateAsDouble) {
        if (javaDateAsDouble == 0.0) {
            return null;
        }
        long javaDateAsLong = (long)javaDateAsDouble;
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        double sasDate = DateUtil.javaDateToSASDateTime((long)javaDateAsLong, (TimeZone)timezone);
        return Double.toString(sasDate);
    }

    static double getAssociatedTimestampValue(Transformation remoteTransformation, String attributeNameToMatch) {
        try {
            AssociationList timeStamps = remoteTransformation.getTimestamps(true);
            if (timeStamps != null) {
                for (Timestamp timestamp : timeStamps) {
                    String timestampName = timestamp.getTimestampRole();
                    if (!attributeNameToMatch.equals(timestampName)) continue;
                    return timestamp.getDateandTime();
                }
            }
            log.warning(RB.getStringResource("RLO.timestampNotFoundRemote.fmt.txt", attributeNameToMatch));
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        catch (MdException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return 0.0;
    }
}

