/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.project;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.report.repository.Project;
import com.sas.services.information.metadata.MetadataInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ProjectExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    static final String SBIP_PREFIX = "SBIP://";
    private static final Logger log = Logger.getLogger(ProjectExportItem.class.getName());
    private List _dependentObjects;
    private Map urlMap;
    private List originalPathList = new ArrayList();
    private List removeFailures = new ArrayList();

    public ProjectExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
        log.fine("entering");
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        if (relationshipType != 0) {
            return null;
        }
        if (this._dependentObjects == null) {
            try {
                this._dependentObjects = new ArrayList();
                Project proj = (Project)PromotionUtil.getSmartObject((PromotionInterface)this._exportOperation, (SimpleLogicalObjectInterface)this);
                List assoc = proj.getDependencies();
                for (MetadataInterface mi : assoc) {
                    SimpleLogicalObjectInterface dependentObject = UtilPromotion.createSimpleLogicalObject(mi.getName(), mi.getReposId(), mi.getType());
                    this._dependentObjects.add(dependentObject);
                }
            }
            catch (Exception ex) {
                log.fine(ex.getMessage());
                throw new LogicalTypeException(ex);
            }
        }
        return this._dependentObjects;
    }
}

