/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.project;

import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionUtil;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectContentHelper
extends ContentHelper {
    private static final Logger log = Logger.getLogger(ProjectContentHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveAndUpdateContentFromPackage(InputStream inStream, OutputStream outStream, ImportOperationInterface importHandler) throws FileNotFoundException, IOException {
        BufferedInputStream iStream = new BufferedInputStream(inStream);
        try {
            boolean sbipUpdateNeeded = false;
            int prefixLength = "<?xml version=\"".length();
            int bytesRead = iStream.read(this._dataBuffer, 0, prefixLength);
            String startOfFile = null;
            if (bytesRead == prefixLength) {
                startOfFile = new String(this._dataBuffer, 0, bytesRead, "UTF-8");
                sbipUpdateNeeded = "<?xml version=\"".equals(startOfFile);
            }
            if (sbipUpdateNeeded) {
                String targetReposName = importHandler.getRepositoryName();
                List infoMaps = importHandler.getImportItems("InformationMap");
                List infoMapsOlap = importHandler.getImportItems("InformationMap.OLAP");
                List infoMapsRelational = importHandler.getImportItems("InformationMap.Relational");
                List storedProcs = importHandler.getImportItems("StoredProcess");
                List reports = importHandler.getImportItems("Report");
                ArrayList allImportedObjects = new ArrayList();
                allImportedObjects.addAll(infoMaps);
                allImportedObjects.addAll(infoMapsOlap);
                allImportedObjects.addAll(infoMapsRelational);
                allImportedObjects.addAll(storedProcs);
                allImportedObjects.addAll(reports);
                StringBuffer buf = new StringBuffer();
                buf.append(startOfFile);
                InputStreamReader isr = new InputStreamReader((InputStream)iStream, "UTF-8");
                char[] charBuf = new char[4096];
                int charsRead = isr.read(charBuf);
                while (charsRead > 0) {
                    buf.append(charBuf, 0, charsRead);
                    charsRead = isr.read(charBuf);
                }
                String endString = "\"";
                boolean notFinished = true;
                int currPtr = 0;
                while (notFinished) {
                    int p = Math.max(buf.indexOf("SBIP://", currPtr), buf.indexOf("sbip://", currPtr));
                    if (p != -1) {
                        int startOfUrl = p;
                        if (buf.charAt(startOfUrl - 1) == '>') {
                            endString = "<";
                        } else if (buf.charAt(startOfUrl - 1) == '\"') {
                            endString = "\"";
                        }
                        int closingQuote = buf.indexOf(endString, startOfUrl);
                        if (closingQuote > startOfUrl) {
                            String oldUrl = buf.substring(startOfUrl, closingQuote);
                            log.fine("old url = " + oldUrl);
                            String newUrl = PromotionUtil.getNewSBIPUrl((String)oldUrl, (String)targetReposName, allImportedObjects);
                            buf.replace(startOfUrl, closingQuote, newUrl);
                            currPtr = p + newUrl.length();
                            continue;
                        }
                        log.warning("No closing quote found!");
                        currPtr += 7;
                        continue;
                    }
                    notFinished = false;
                }
                OutputStreamWriter osw = new OutputStreamWriter(outStream, "UTF-8");
                String updatedContent = buf.toString();
                osw.write(updatedContent);
                osw.flush();
            } else {
                while (bytesRead > 0) {
                    outStream.write(this._dataBuffer, 0, bytesRead);
                    bytesRead = iStream.read(this._dataBuffer);
                }
            }
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException sbipUpdateNeeded) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Failed on repository write/close", e);
                    throw e;
                }
            }
        }
    }
}

