/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.impl.OMRBriefInformationMap;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.informationmap.InformationMapUtil;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.information.metadata.FolderInterface;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;

public class InformationMapLogicalObject
extends LogicalObject
implements MemberInterface {
    InformationMapLogicalObject(Transformation transformation, TypeInterface ti, Factory factory) throws RemoteException {
        super((Root)transformation, ti, factory);
        this.setCompatibility(OMRBriefInformationMap.OLDEST_VERSION, OMRBriefInformationMap.CURRENT_VERSION);
    }

    public Icon getIcon() {
        return this.getTypeInterface().getIcon(1);
    }

    public boolean delete(OperationUserInteractionInterface oui) {
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        BriefInformationMap bmap = null;
        try {
            bmap = InformationMapUtil.getBriefInformationMap((SimpleLogicalObjectInterface)this);
            if (bmap != null) {
                bmap.delete();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (oui.continueOperationWithPrompting()) {
                String folderName = "";
                if (bmap != null) {
                    try {
                        List parents = bmap.getParents();
                        if (parents != null && parents.size() > 0) {
                            folderName = ((FolderInterface)parents.get(0)).getName();
                        }
                    }
                    catch (Exception parents) {
                        // empty catch block
                    }
                }
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("IMLO.DelExcpOccrd.fmt.txt"), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
                int choice = oui.displayMessage(RB.getStringResource("IMLO.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
            }
            return false;
        }
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return false;
    }
}

