/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.InformationMapResourceReplacementManager2;
import com.sas.iquery.metadata.resourceutil.MediatedResourceManager2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTree2;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.cube.CubeConnectionType;
import com.sas.metadata.logical.informationmap.InformationMapConnectionPointManager;
import com.sas.metadata.logical.informationmap.InformationMapUtil;
import com.sas.metadata.logical.informationmap.MapToImport;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.logical.informationmap.StoredProcessValidator;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.olapschema.OLAPSchemaConnectionType;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.storedprocess.StoredProcessConnectionType;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.AbstractPromotionListener;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InformationMapImportListener
extends AbstractImportListener
implements NotificationListener {
    static final String INFORMATION_MAP_IMPORT_LISTENER_PHYSICAL_RESOURCE_TREE = ".ImportListener.PhysicalResourceTree2";
    static final String INFORMATION_MAP_IMPORT_LISTENER_ANALYZE_RESULTS = ".ImportListener.AnalyzeResults";
    private int rc = 0;
    private static final String MAP_TEMPLATE = "<Template><Transformation> <SourceCode> <TextStore StoredText=\"\"/> </SourceCode> <Prompts/><TransformationSources/></Transformation> </Template>";
    protected static final Class[] CONNECTION_TYPES = PrivateObjectImportUtility.appendPromptConnectionTypes((Class[])new Class[]{AppServerConnectionType.class, LibraryConnectionType.class, TableConnectionType.class, OLAPSchemaConnectionType.class, CubeConnectionType.class, StoredProcessConnectionType.class});

    public InformationMapImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public ConnectionValidatorInterface[] getConnectionValidatorInterfaces() {
        ConnectionValidatorInterface[] validators = new ConnectionValidatorInterface[]{new StoredProcessValidator()};
        return validators;
    }

    private List getInformationMapDeploymentObjects(List objs) {
        String publicType = this.getTypeInterface().getPublicType();
        ArrayList<ImportItemInterface> topLevelMaps = null;
        if (objs != null) {
            topLevelMaps = new ArrayList(objs.size());
            int len = objs.size();
            for (int i = 0; i < len; ++i) {
                ImportItemInterface importItem;
                Object obj = objs.get(i);
                if (!(obj instanceof ImportItemInterface) || !publicType.equals((importItem = (ImportItemInterface)obj).getTypeInterface().getPublicType())) continue;
                topLevelMaps.add(importItem);
            }
        } else {
            topLevelMaps = new ArrayList<ImportItemInterface>();
        }
        return topLevelMaps;
    }

    private List getValidatedMapToImportObjects(ImportOperationInterface operation, List topLevelObjects) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        boolean logError = importLogger.isErrorEnabled();
        List topLevelMaps = this.getInformationMapDeploymentObjects(topLevelObjects);
        Map metadataMap = operation.getAssociationsForObjects(topLevelMaps, MAP_TEMPLATE);
        ArrayList<MapToImport> mapsToImport = new ArrayList<MapToImport>();
        int size = topLevelObjects.size();
        for (int i = 0; i < size; ++i) {
            ImportItemInterface importItem = (ImportItemInterface)topLevelObjects.get(i);
            String mapOMRID = importItem.getID();
            Map mapMap = (Map)metadataMap.get(mapOMRID);
            if (mapMap == null) {
                this.rc |= 8;
                if (!logError) continue;
                String errMsg = RB.getStringResource("InformationMapImportListener.NoMetadataForInfoMap.txt");
                errMsg = MessageFormat.format(errMsg, mapOMRID);
                importLogger.error((Object)errMsg);
                continue;
            }
            String mapName = (String)mapMap.get("Name");
            String mapIDFromMap = (String)mapMap.get("Id");
            if (!mapOMRID.equals(mapIDFromMap)) {
                this.rc |= 8;
                if (!logError) continue;
                String errMsg = RB.getStringResource("InformationMapImportListener.InvalidOMRID.txt");
                errMsg = MessageFormat.format(errMsg, mapName, mapIDFromMap, mapOMRID);
                importLogger.error((Object)errMsg);
                continue;
            }
            boolean hasPrompts = false;
            List mapPromptsList = (List)mapMap.get("Prompts");
            if (mapPromptsList.size() > 0) {
                hasPrompts = true;
            }
            List transformationSources = (List)mapMap.get("TransformationSources");
            List mapSourceCodeList = (List)mapMap.get("SourceCode");
            if (mapSourceCodeList == null || mapSourceCodeList.size() != 1) {
                this.rc |= 8;
                if (!logError) continue;
                String errMsg = RB.getStringResource("InformationMapImportListener.InvalidSourceCode.txt");
                errMsg = MessageFormat.format(errMsg, mapName, mapIDFromMap);
                importLogger.error((Object)errMsg);
                continue;
            }
            Map firstSourceCodeAssociationObject = (Map)mapSourceCodeList.get(0);
            if (firstSourceCodeAssociationObject == null) {
                this.rc |= 8;
                if (!logError) continue;
                String errMsg = RB.getStringResource("InformationMapImportListener.InvalidSourceCode.txt");
                errMsg = MessageFormat.format(errMsg, mapName, mapIDFromMap);
                importLogger.error((Object)errMsg);
                continue;
            }
            String sourceCodeObjectType = (String)firstSourceCodeAssociationObject.get("MetadataObjectType");
            if (!"TextStore".equals(sourceCodeObjectType)) {
                this.rc |= 8;
                if (!logError) continue;
                String errMsg = RB.getStringResource("InformationMapImportListener.InvalidSourceCode.txt");
                errMsg = MessageFormat.format(errMsg, mapName, mapIDFromMap);
                importLogger.error((Object)errMsg);
                continue;
            }
            String ourMapsXML = (String)firstSourceCodeAssociationObject.get("StoredText");
            if (!(importItem instanceof MapToImport)) continue;
            MapToImport mti = (MapToImport)importItem;
            mti.setXML(ourMapsXML);
            mti.setTranformationSources(transformationSources);
            mti.setContainsPrompts(hasPrompts);
            mapsToImport.add(mti);
        }
        return mapsToImport;
    }

    public int updateObjects(ImportOperationInterface operation, List topLevelObjects) throws MetadataPromotionException {
        block27: {
            Log importLogger = operation.getLogger();
            if (importLogger == null) {
                throw new MetadataPromotionException(RB.getStringResource("InformationMapImportListener.errorLogging.txt"));
            }
            this.rc = 0;
            for (DefaultImportItem dii : topLevelObjects) {
                try {
                    this.rc |= this.updateMapAssociation(operation, dii);
                }
                catch (RemoteException e) {
                    this.rc |= 8;
                    if (!importLogger.isErrorEnabled()) continue;
                    importLogger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            Map importedObjectsMappings = (Map)operation.getObjectFromCache((Object)(this.getTypeInterface().getPublicType() + INFORMATION_MAP_IMPORT_LISTENER_ANALYZE_RESULTS));
            PhysicalResourceTree2 baseTree = (PhysicalResourceTree2)operation.getObjectFromCache((Object)(this.getTypeInterface().getPublicType() + INFORMATION_MAP_IMPORT_LISTENER_PHYSICAL_RESOURCE_TREE));
            if (importedObjectsMappings != null && baseTree != null) {
                try {
                    for (PhysicalResource importPhysicalResource : importedObjectsMappings.keySet()) {
                        String message;
                        Object importedItem = importedObjectsMappings.get(importPhysicalResource);
                        if (importedItem == null) continue;
                        String targetOMAId = null;
                        String metadataType = null;
                        String targetPath = null;
                        ExternalResourceType pType = ExternalResourceType.getType((PhysicalResource)importPhysicalResource);
                        if (importedItem instanceof ConnectionPoint) {
                            ConnectionPoint importedCp = (ConnectionPoint)importedItem;
                            targetOMAId = importedCp.getTargetID();
                            metadataType = importedCp.getMetadataType();
                            if (pType == ExternalResourceType.StoredProcess) {
                                targetPath = importedCp.getTargetPath();
                            }
                        } else if (importedItem instanceof ImportItemInterface) {
                            ImportItemInterface importItem = (ImportItemInterface)importedItem;
                            targetOMAId = importItem.getTargetID();
                            metadataType = importItem.getTypeInterface().getMetadataType();
                            if (pType == ExternalResourceType.StoredProcess) {
                                targetPath = BIPTreeUtil.pathToString((String[])importItem.getTargetPath(), (String)importItem.getName(), (String)importItem.getTypeInterface().getPublicType());
                            }
                        } else {
                            message = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.InvalidImportItemType.fmt.txt"), (Object[])new Object[]{importedItem.getClass()});
                            importLogger.warn((Object)message);
                            this.rc |= 4;
                        }
                        if (this.isValidOMAId(targetOMAId)) {
                            MdObjectStore store = operation.getStore();
                            CMetadata jOMAObject = store.getObject(targetOMAId);
                            if (targetPath != null) {
                                baseTree.setReplacementPath(importPhysicalResource, targetPath);
                            }
                            if (jOMAObject == null) {
                                if (metadataType == null) {
                                    metadataType = ExternalResourceType.getType((PhysicalResource)importPhysicalResource).getOMRType();
                                }
                                jOMAObject = InformationMapUtil.getjOMAObjectFromId((PromotionInterface)operation, metadataType, targetOMAId);
                            }
                            if (jOMAObject != null) {
                                baseTree.setReplacementOMAObject(importPhysicalResource, (Object)jOMAObject);
                                baseTree.setReplacementName(importPhysicalResource, jOMAObject.getName());
                                continue;
                            }
                            String message2 = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.ImportItemNotFoundForID.fmt.txt"), (Object[])new Object[]{importedItem});
                            importLogger.warn((Object)message2);
                            this.rc |= 4;
                            continue;
                        }
                        message = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.ImportItemIDNotFound.fmt.txt"), (Object[])new Object[]{importedItem});
                        importLogger.debug((Object)message);
                    }
                    IntelligentQueryMetadataServiceInterface iq_svc = IntelligentQueryMetadataServiceFactory.newService();
                    SessionContextInterface session = operation.getSessionContext();
                    List wrappedMaps = baseTree.getAllOwningObjects();
                    int count = wrappedMaps.size();
                    int index = 0;
                    String messageFormatForInfo = RB.getStringResource("InformationMapImportListener.Info.Processing.fmt.txt");
                    Iterator iter = wrappedMaps.iterator();
                    while (iter.hasNext()) {
                        ++index;
                        MapToImport mti = (MapToImport)((Object)iter.next());
                        BriefInformationMap briefMap = this.getTargetBriefMap(operation, mti);
                        if (briefMap == null) {
                            importLogger.error((Object)RB.getStringResource("InformationMapImportListener.unableToGetMapObject.txt"));
                            this.rc |= 8;
                            continue;
                        }
                        if (importLogger.isInfoEnabled()) {
                            String infoMapProcessing = UtilMisc.getMessage((String)messageFormatForInfo, (Object[])new Object[]{briefMap});
                            importLogger.info((Object)infoMapProcessing);
                        }
                        this.fireDisplayMessage(StatusMessageUtil.createUpdatingMessage((TypeInterface)this.getTypeInterface(), (String)briefMap.getName(), (int)index, (int)count));
                        InformationMapResourceReplacementManager2 iRRM = new InformationMapResourceReplacementManager2(briefMap, session, iq_svc, importLogger.getLog4JLogger(), true, true);
                        MediatedResourceManager2 mrm = iRRM.getResourceManager();
                        mrm.setResourceReplacements(baseTree);
                        List successReasons = iRRM.replaceMapExternalDependencies();
                        if (importLogger.isWarnEnabled() && !successReasons.isEmpty()) {
                            for (Reason reason : successReasons) {
                                importLogger.warn((Object)reason.getReasonString());
                            }
                            this.rc |= 4;
                        }
                        if (importLogger.isDebugEnabled()) {
                            String saveDebugMsg = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.Debug.Saved.fmt.txt"), (Object[])new Object[]{briefMap});
                            importLogger.debug((Object)saveDebugMsg);
                        }
                        BriefInformationMap savedMap = iRRM.save(RB.getStringResource("InformationMapImportListener.saveMsg.txt"));
                        if (importLogger.isWarnEnabled()) {
                            List urItems = iRRM.getMapUnresolvedPhysicalResources(true);
                            this.rc = InformationMapUtil.logUnresolvedResources(importLogger, briefMap, baseTree, urItems, (AbstractPromotionListener)this, this.rc);
                        }
                        iRRM.dispose();
                        if (savedMap != briefMap) {
                            briefMap.destroy();
                            briefMap = savedMap;
                        }
                        if (!mti.getContainsPrompts()) continue;
                        List promptSmartObjects = briefMap.getPrompts();
                        PrivateObjectImportUtility.updatePromptPaths((ImportOperationInterface)operation, (List)promptSmartObjects);
                    }
                }
                catch (Exception allexceptions) {
                    this.rc |= 8;
                    if (!importLogger.isErrorEnabled()) break block27;
                    importLogger.error((Object)allexceptions.getMessage(), (Throwable)allexceptions);
                }
            }
        }
        return this.rc;
    }

    private boolean isValidOMAId(String id) {
        boolean valid = true;
        if (id == null) {
            valid = false;
        } else if (id.indexOf(".") != 8) {
            valid = false;
        }
        return valid;
    }

    private BriefInformationMap getTargetBriefMap(ImportOperationInterface operation, MapToImport mti) throws RemoteException, ServiceException, MetadataPromotionException {
        BriefInformationMap briefMap = null;
        MdObjectStore store = operation.getStore();
        String targetID = mti.getTargetID();
        if (targetID != null) {
            Transformation jOMATxfm = (Transformation)store.getFactory().createComplexMetadataObject(store, mti.getMapName(), "Transformation", targetID);
            String publicType = mti.getPublicType();
            if (publicType != null && publicType.length() > 0) {
                jOMATxfm.setPublicType(mti.getPublicType(), 1);
            } else {
                jOMATxfm.setPublicType("InformationMap.Relational", 1);
            }
            ServerInterface server = operation.getServer();
            MetadataInterface mi = server.factoryProcess((Object)jOMATxfm);
            if (mi instanceof BriefInformationMap) {
                briefMap = (BriefInformationMap)mi;
            }
        }
        return briefMap;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List topLevelObjects) throws MetadataPromotionException {
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("InformationMapImportListener.ProjectRepos.txt"));
        }
        this.rc = 0;
        operation.addNotificationListener((NotificationListener)this);
        Log importLogger = operation.getLogger();
        if (importLogger == null) {
            throw new MetadataPromotionException(RB.getStringResource("InformationMapImportListener.errorLogging.txt"));
        }
        List wrappedMaps = this.getValidatedMapToImportObjects(operation, topLevelObjects);
        PhysicalResourceTree2 baseTree = this.createPhysicalResourceTreeForMaps(operation, importLogger, wrappedMaps);
        operation.addObjectToCache((Object)(this.getTypeInterface().getPublicType() + INFORMATION_MAP_IMPORT_LISTENER_PHYSICAL_RESOURCE_TREE), (Object)baseTree);
        ArrayList resources = null;
        resources = baseTree != null ? baseTree.getResources() : new ArrayList();
        if (importLogger.isDebugEnabled()) {
            int nRes = resources.size();
            for (int index = 0; index < nRes; ++index) {
                PhysicalResource rr = (PhysicalResource)resources.get(index);
                importLogger.debug((Object)rr.getLabel());
            }
        }
        InformationMapConnectionPointManager cxMgr = new InformationMapConnectionPointManager((PromotionInterface)operation);
        Map importedObjectsMappings = cxMgr.getResourceToConnectionPointMapping(resources, baseTree);
        operation.addObjectToCache((Object)(this.getTypeInterface().getPublicType() + INFORMATION_MAP_IMPORT_LISTENER_ANALYZE_RESULTS), (Object)importedObjectsMappings);
        if (operation.getPromotionType() != 2) {
            try {
                cxMgr.findMissingPathURLResources(operation.getSessionContext(), importedObjectsMappings, baseTree);
            }
            catch (Exception e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return this.rc;
    }

    private PhysicalResourceTree2 createPhysicalResourceTreeForMaps(ImportOperationInterface operation, Log importLogger, List wrappedMaps) throws MetadataPromotionException {
        PhysicalResourceTree2 baseTree = null;
        IntelligentQueryMetadataServiceInterface iq_svc = null;
        SessionContextInterface session = null;
        try {
            iq_svc = IntelligentQueryMetadataServiceFactory.newService();
            session = operation.getSessionContext();
        }
        catch (MetadataException me) {
            MetadataPromotionException de = new MetadataPromotionException((Throwable)me);
            throw de;
        }
        catch (Exception e) {
            MetadataPromotionException de = new MetadataPromotionException((Throwable)e);
            throw de;
        }
        int count = wrappedMaps.size();
        int index_count = 0;
        for (MapToImport mti : wrappedMaps) {
            String message;
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)this.getTypeInterface(), (String)mti.getMapName(), (int)(++index_count), (int)count));
            try {
                PhysicalResourceTree2 tree = this.getPhysicalResourceTreeForMap(operation, iq_svc, session, mti);
                tree.setOwningObject((Object)mti);
                if (baseTree == null) {
                    baseTree = new PhysicalResourceTree2(session, iq_svc, importLogger.getLog4JLogger());
                }
                baseTree.addPhysicalResources(tree);
                mti.setBaseResourceTree(baseTree);
            }
            catch (MetadataException me) {
                message = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.ErrorLoadingRes.fmt.txt"), (Object[])new Object[]{mti.getMapName()});
                importLogger.error((Object)message, (Throwable)me);
            }
            catch (ServiceException me) {
                message = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.ErrorLoadingRes.fmt.txt"), (Object[])new Object[]{mti.getMapName()});
                importLogger.error((Object)message, (Throwable)me);
            }
            catch (RemoteException me) {
                message = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.ErrorLoadingRes.fmt.txt"), (Object[])new Object[]{mti.getMapName()});
                importLogger.error((Object)message, (Throwable)me);
            }
        }
        return baseTree;
    }

    private PhysicalResourceTree2 getPhysicalResourceTreeForMap(ImportOperationInterface operation, IntelligentQueryMetadataServiceInterface iq_svc, SessionContextInterface session, MapToImport mti) throws MetadataPromotionException, MetadataException, ServiceException, RemoteException {
        String modelXML = null;
        if (operation.getPackageFileVersion() >= 9300) {
            modelXML = mti.getModelXML().substring(8);
        } else {
            String modelXMLUgly = mti.getModelXML();
            modelXML = mti.processModelXML(modelXMLUgly.substring(8));
        }
        MetadataServerInterface metadataServer = (MetadataServerInterface)operation.getServer();
        if (operation.getPackageFileVersion() < 9200) {
            InformationMapImpl2.FactoryResultsImpl results = InformationMapImpl2.readInNewMap((String)modelXML, (IntelligentQueryMetadataServiceInterface)iq_svc, (SessionContextInterface)session, (boolean)true, (boolean)false, (List)Collections.EMPTY_LIST, (boolean)false, (MetadataServerInterface)metadataServer);
            InformationMap infoMap = results.getMap();
            modelXML = infoMap.toXML(0);
            String saveInfoMsg = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.Debug.UpgradedInMem.fmt.txt"), (Object[])new Object[]{mti.getMapName()});
            operation.getLogger().info((Object)saveInfoMsg);
        }
        InformationMapResourceReplacementManager2 iRRM = null;
        InformationMapImpl2.FactoryResultsImpl results = InformationMapImpl2.readInNewMap((String)modelXML, (IntelligentQueryMetadataServiceInterface)iq_svc, (SessionContextInterface)session, (boolean)true, (boolean)false, (List)Collections.EMPTY_LIST, (boolean)false, (MetadataServerInterface)metadataServer);
        InformationMap infoMap = results.getMap();
        iRRM = new InformationMapResourceReplacementManager2(infoMap, iq_svc, operation.getLogger().getLog4JLogger(), true, true, true);
        PhysicalResourceTree2 tree = iRRM.getResourceManager().getDependentPhysicalObjectsAsTree();
        iRRM.dispose();
        iRRM = null;
        return tree;
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        MapToImport mti = new MapToImport(name, id, type);
        return mti;
    }

    public void notify(NotificationEvent event) {
        switch (event.getEventType()) {
            case 200: {
                PromotionInterface operation = event.getPromotionOperation();
                try {
                    SessionContextInterface session = operation.getSessionContext();
                    MdObjectStore store = operation.getStore();
                    OMAResourceFactory.freeOMAWrappers((SessionContextInterface)session, (MdObjectStore)store);
                }
                catch (MetadataException e) {
                    Log logger = operation.getLogger();
                    logger.debug((Object)"Exception encountered when trying to free OMA wrappers", (Throwable)e);
                }
                catch (ServiceException e) {
                    Log logger = operation.getLogger();
                    logger.debug((Object)"Exception encountered when trying to free OMA wrappers", (Throwable)e);
                }
                catch (RemoteException e) {
                    Log logger = operation.getLogger();
                    logger.debug((Object)"Exception encountered when trying to free OMA wrappers", (Throwable)e);
                }
                break;
            }
        }
    }

    private int updateMapAssociation(ImportOperationInterface operation, DefaultImportItem importItem) throws RemoteException {
        int returnValue = 0;
        try {
            String[] targetPath = importItem.getTargetPath();
            StringBuffer mapPath = new StringBuffer();
            for (String t : targetPath) {
                mapPath.append("/");
                mapPath.append(t);
            }
            mapPath.insert(0, "\"");
            mapPath.append("\"");
            StringBuffer xmlSelect = new StringBuffer();
            xmlSelect.append("<XMLSelect Search=\"PhysicalTable");
            xmlSelect.append("[@Name='" + XMLUtil.normalize((String)(importItem.getName() + "']")));
            xmlSelect.append("[TablePackage/DatabaseSchema/UsedByPackages/SASLibrary[@Engine='SASIOIME']/Properties/Property[@Name='Library.Common.Property.Path.Name.xmlkey.txt' and @DefaultValue='" + XMLUtil.normalize((String)mapPath.toString()) + "']");
            xmlSelect.append(" ]\"/>\n");
            int flags = 392;
            MdOMIUtil mdUtil = operation.getStore().getFactory().getOMIUtil();
            List physicalTables = mdUtil.getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "PhysicalTable", flags, xmlSelect.toString());
            if (physicalTables.size() > 0) {
                PhysicalTable pt = (PhysicalTable)physicalTables.get(0);
                AssociationList targetTransformations = pt.getTargetTransformations();
                Transformation mdTransform = (Transformation)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "Transformation", importItem.getTargetID(), null, null, "<Templates><Transformation/></Templates>", 268);
                boolean found = false;
                for (Transformation t : targetTransformations) {
                    if (!t.getId().equals(mdTransform.getId())) continue;
                    found = true;
                }
                if (!found) {
                    Log importLogger = operation.getLogger();
                    if (importLogger != null) {
                        String message = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.addedAssociation.fmt.txt"), (Object[])new Object[]{mdTransform.getName(), mdTransform.getId(), pt.getName(), pt.getId()});
                        importLogger.debug((Object)message);
                    }
                    targetTransformations.add((Object)mdTransform);
                    pt.setTargetTransformations(targetTransformations);
                    pt.updateMetadataAll();
                }
            }
        }
        catch (MdException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            returnValue |= 8;
        }
        return returnValue;
    }
}

