/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.resourceutil.InformationMapResourceReplacementManager2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTree2;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.informationmap.InformationMapConnectionPointManager;
import com.sas.metadata.logical.informationmap.InformationMapExportItem;
import com.sas.metadata.logical.informationmap.InformationMapImportListener;
import com.sas.metadata.logical.informationmap.InformationMapUtil;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.AbstractPromotionListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class InformationMapExportListener
extends AbstractExportListener
implements NotificationListener {
    public InformationMapExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return InformationMapImportListener.CONNECTION_TYPES;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        InformationMapExportItem returnValue = new InformationMapExportItem(name, id, type);
        return returnValue;
    }

    public int analyzeConnections(ExportOperationInterface exportOperation, List exportObjects) throws MdException, RemoteException {
        int returnValue = super.analyzeConnections(exportOperation, exportObjects);
        ReturnCode rc = new ReturnCode(returnValue);
        ArrayList<InformationMapExportItem> maps = new ArrayList<InformationMapExportItem>(exportObjects.size());
        for (ExportItemInterface exportItem : exportObjects) {
            if (exportItem.getTypeInterface().getPublicType().indexOf("InformationMap") < 0) continue;
            maps.add((InformationMapExportItem)exportItem);
        }
        maps.trimToSize();
        try {
            PhysicalResourceTree2 resourceTree = this.createPhysicalResourceTreeForMaps((PromotionInterface)exportOperation, exportOperation.getLogger(), maps, rc);
            InformationMapConnectionPointManager cxMgr = new InformationMapConnectionPointManager((PromotionInterface)exportOperation);
            cxMgr.populateConnectionPoints(resourceTree);
        }
        catch (MetadataPromotionException e) {
            throw new MdException((Throwable)e);
        }
        return rc.code;
    }

    public int analyzeObjectsToExport(ExportOperationInterface operation, List objects) throws MdException {
        operation.addNotificationListener((NotificationListener)this);
        int returnValue = super.analyzeObjectsToExport(operation, objects);
        return returnValue;
    }

    private PhysicalResourceTree2 createPhysicalResourceTreeForMaps(PromotionInterface operation, Log log, List<InformationMapExportItem> wrappedMaps, ReturnCode rc) throws MetadataPromotionException {
        PhysicalResourceTree2 baseTree = null;
        IntelligentQueryMetadataServiceInterface iq_svc = null;
        SessionContextInterface session = null;
        try {
            iq_svc = IntelligentQueryMetadataServiceFactory.newService();
            session = operation.getSessionContext();
        }
        catch (MetadataException me) {
            MetadataPromotionException de = new MetadataPromotionException((Throwable)me);
            throw de;
        }
        catch (Exception e) {
            MetadataPromotionException de = new MetadataPromotionException((Throwable)e);
            throw de;
        }
        int count = wrappedMaps.size();
        int index_count = 0;
        for (InformationMapExportItem mti : wrappedMaps) {
            this.fireDisplayMessage(StatusMessageUtil.createStatusMessageForObject((TypeInterface)mti.getTypeInterface(), (String)mti.getName(), (int)(++index_count), (int)count));
            try {
                PhysicalResourceTree2 tree = this.getPhysicalResourceTreeForMap(operation, iq_svc, session, mti, log, rc);
                tree.setOwningObject((Object)mti);
                if (baseTree == null) {
                    baseTree = new PhysicalResourceTree2(session, iq_svc, log.getLog4JLogger());
                }
                baseTree.addPhysicalResources(tree);
            }
            catch (MetadataException me) {
                String message = UtilMisc.getMessage((String)RB.getStringResource("InformationMapImportListener.ErrorLoadingRes.fmt.txt"), (Object[])new Object[]{mti.getName()});
                log.error((Object)message, (Throwable)me);
                rc.code |= 8;
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return baseTree;
    }

    private PhysicalResourceTree2 getPhysicalResourceTreeForMap(PromotionInterface operation, IntelligentQueryMetadataServiceInterface iq_svc, SessionContextInterface session, InformationMapExportItem mti, Log log, ReturnCode rc) throws MetadataPromotionException, MetadataException, RemoteException, ServiceException {
        BriefInformationMap bmap = InformationMapUtil.getBriefInformationMap(operation.getServer(), (SimpleLogicalObjectInterface)mti);
        InformationMapResourceReplacementManager2 iRRM = null;
        iRRM = new InformationMapResourceReplacementManager2(bmap, session, iq_svc, operation.getLogger().getLog4JLogger(), true, true);
        PhysicalResourceTree2 tree = iRRM.getResourceManager().getDependentPhysicalObjectsAsTree();
        if (log.isWarnEnabled()) {
            rc.code = InformationMapUtil.logUnresolvedResources(log, bmap, tree, iRRM.getMapUnresolvedPhysicalResources(), (AbstractPromotionListener)this, rc.code);
        }
        iRRM.dispose();
        return tree;
    }

    public void notify(NotificationEvent event) {
        switch (event.getEventType()) {
            case 100: {
                PromotionInterface operation = event.getPromotionOperation();
                try {
                    SessionContextInterface session = operation.getSessionContext();
                    MdObjectStore store = operation.getStore();
                    OMAResourceFactory.freeOMAWrappers((SessionContextInterface)session, (MdObjectStore)store);
                }
                catch (MetadataException e) {
                    Log logger = operation.getLogger();
                    logger.debug((Object)"Exception encountered when trying to free OMA wrappers", (Throwable)e);
                }
                catch (ServiceException e) {
                    Log logger = operation.getLogger();
                    logger.debug((Object)"Exception encountered when trying to free OMA wrappers", (Throwable)e);
                }
                catch (RemoteException e) {
                    Log logger = operation.getLogger();
                    logger.debug((Object)"Exception encountered when trying to free OMA wrappers", (Throwable)e);
                }
                break;
            }
        }
    }

    private final class ReturnCode {
        public int code;

        public ReturnCode(int code) {
            this.code = code;
        }
    }
}

