/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.dataexploration;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.dataexploration.DataExplorationUtil;
import com.sas.metadata.logical.dataexploration.RB;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.dataexplorer.DataExplorationEntryInterface;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;

public class DataExplorationLogicalObject
extends LogicalObject
implements MemberInterface {
    DataExplorationLogicalObject(Transformation transformation, TypeInterface ti, Factory factory) throws RemoteException {
        super((Root)transformation, ti, factory);
    }

    public Icon getIcon() {
        return this.getTypeInterface().getIcon(1);
    }

    public boolean delete(OperationUserInteractionInterface oui) {
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        DataExplorationEntryInterface de = null;
        try {
            de = DataExplorationUtil.getDataExplorationEntry((SimpleLogicalObjectInterface)this);
            if (de != null) {
                de.delete();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (oui.continueOperationWithPrompting()) {
                String folderName = "";
                if (de != null) {
                    try {
                        List parents = de.getParents();
                        if (parents != null && parents.size() > 0) {
                            folderName = ((FolderInterface)parents.get(0)).getName();
                        }
                    }
                    catch (Exception parents) {
                        // empty catch block
                    }
                }
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("DELO.DelExcpOccrd.fmt.txt"), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
                int choice = oui.displayMessage(RB.getStringResource("DELO.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
            }
            return false;
        }
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return false;
    }
}

