/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.dataexploration;

import com.sas.iquery.metadata.MetadataException;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.dataexploration.RB;
import com.sas.metadata.logical.informationmap.InformationMapConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionPointUtil;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.MissingResourceHandler;
import com.sas.metadata.promotion.MissingResourceInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Transformation;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.dataexplorer.BookmarkEntryInterface;
import com.sas.services.information.metadata.dataexplorer.DataExplorationEntryInterface;
import com.sas.services.information.metadata.dataexplorer.OMRUtils;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataExplorationImportListener
extends AbstractImportListener {
    private static final String SBIP_URL_SUFFIX = "\"";
    private static final String SBIP_URL_PREFIX = "\"SBIP://";
    private static final String DATA_EXPLORATION_TEMPLATE = "<Template><Transformation><Notes><TextStore StoredText=\"\"/></Notes><Properties><Property DefaultValue=\"\"/></Properties></Transformation></Template>";
    static final Logger log = Logger.getLogger(DataExplorationImportListener.class.getName());
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    protected static final Class[] CONNECTION_TYPES = new Class[]{InformationMapConnectionType.class};

    public DataExplorationImportListener(TransportableTypeInterface type) {
        super(type);
        log.fine("new DataExplorationImportListener being constructed");
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("DEIL.ProjectRepos.txt"));
        }
        Log importLogger = operation.getLogger();
        MissingResourceHandler resourceHandler = operation.getResourceHandler();
        int rc = 0;
        boolean logError = importLogger.isErrorEnabled();
        ConnectionManagerInterface connMgr = operation.getConnectionManager();
        log.fine("event = " + operation);
        log.fine("objects = " + objects);
        if (this.containsDataExploration(objects)) {
            try {
                ArrayList infoMaps = new ArrayList();
                infoMaps.addAll(operation.getImportItems("InformationMap"));
                infoMaps.addAll(operation.getImportItems("InformationMap.OLAP"));
                infoMaps.addAll(operation.getImportItems("InformationMap.Relational"));
                String targetReposName = operation.getRepositoryName();
                int count = objects.size();
                int i = 0;
                for (ImportItemInterface item : objects) {
                    String errMsg;
                    String targetURL;
                    String type = item.getTypeInterface().getPublicType();
                    if (!"DataExploration".equals(type)) continue;
                    this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)item.getTypeInterface(), (String)item.getName(), (int)(++i), (int)count));
                    Map assocs = operation.getAssociationsForObject((PromotionItemInterface)item, DATA_EXPLORATION_TEMPLATE);
                    String deOMRID = item.getID();
                    Map deMap = (Map)assocs.get(deOMRID);
                    if (deMap == null) {
                        rc |= 8;
                        if (!logError) continue;
                        String errMsg2 = RB.getStringResource("DEIL.NoMetadataForDataExploration.txt");
                        errMsg2 = MessageFormat.format(errMsg2, deOMRID);
                        importLogger.error((Object)errMsg2);
                        continue;
                    }
                    String deName = (String)deMap.get("Name");
                    String deIDFromMap = (String)deMap.get("Id");
                    if (!deOMRID.equals(deIDFromMap)) {
                        rc |= 8;
                        if (!logError) continue;
                        String errMsg3 = RB.getStringResource("DEIL.InvalidOMRID.txt");
                        errMsg3 = MessageFormat.format(errMsg3, deName, deIDFromMap, deOMRID);
                        importLogger.error((Object)errMsg3);
                        continue;
                    }
                    List deProperties = (List)deMap.get("Properties");
                    String mapId = null;
                    String mapUrl = null;
                    for (Map propMap : deProperties) {
                        String propName = (String)propMap.get("Name");
                        if ("informationMapURL".equalsIgnoreCase(propName)) {
                            mapUrl = (String)propMap.get("DefaultValue");
                            continue;
                        }
                        if (!"informationMapId".equalsIgnoreCase(propName)) continue;
                        mapId = (String)propMap.get("DefaultValue");
                    }
                    String newUrl = null;
                    if (null != mapUrl) {
                        ServerInterface server = operation.getServer();
                        if (server != null) {
                            PathUrl pathUrl = null;
                            pathUrl = mapUrl.startsWith("SBIP://") ? new PathUrl(mapUrl) : PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)mapUrl);
                            MetadataInterface mi = server.getObjectByPath(pathUrl);
                            if (null != mi) {
                                newUrl = mapUrl;
                            }
                        }
                    } else if (null != mapId && (targetURL = PromotionUtil.getTargetPathForSourceId(mapId, infoMaps)) != null) {
                        newUrl = "SBIP://" + targetReposName + "/" + targetURL + "(BriefInformationMap)";
                    }
                    if (newUrl != null) continue;
                    List deNotesList = (List)deMap.get("Notes");
                    if (deNotesList == null || deNotesList.size() < 1) {
                        rc |= 8;
                        if (logError) {
                            errMsg = RB.getStringResource("DEIL.InvalidNotes.txt");
                            errMsg = MessageFormat.format(errMsg, deName, deIDFromMap);
                            importLogger.error((Object)errMsg);
                        }
                    } else {
                        Map firstBookmarkObject = (Map)deNotesList.get(0);
                        if (firstBookmarkObject == null) {
                            rc |= 8;
                            if (logError) {
                                String errMsg4 = RB.getStringResource("DEIL.InvalidNotes.txt");
                                errMsg4 = MessageFormat.format(errMsg4, deName, deIDFromMap);
                                importLogger.error((Object)errMsg4);
                            }
                        } else {
                            String noteObjectType = (String)firstBookmarkObject.get("MetadataObjectType");
                            if (!"TextStore".equals(noteObjectType)) {
                                rc |= 8;
                                if (logError) {
                                    String errMsg5 = RB.getStringResource("DEIL.InvalidNotes.txt");
                                    errMsg5 = MessageFormat.format(errMsg5, deName, deIDFromMap);
                                    importLogger.error((Object)errMsg5);
                                }
                            } else {
                                String ourBookmarkXML = (String)firstBookmarkObject.get("StoredText");
                                ourBookmarkXML = this.processModelXML(ourBookmarkXML);
                                int openingQuote = ourBookmarkXML.indexOf(SBIP_URL_PREFIX);
                                Document doc = OMRUtils.XMLString2Doc((String)ourBookmarkXML);
                                NodeList nList913 = doc.getElementsByTagName("BusinessModelReferenceInformation");
                                NodeList nList920 = doc.getElementsByTagName("InformationMap");
                                String imapPath = null;
                                if (null != nList913 && nList913.getLength() > 0) {
                                    imapPath = DataExplorationImportListener.getAttr((Element)nList913.item(0), "location");
                                }
                                if (null == imapPath && null != nList920 && nList920.getLength() > 0) {
                                    imapPath = DataExplorationImportListener.getAttr((Element)nList920.item(0), "absolutePathLocation");
                                }
                                if (null == imapPath) {
                                    while (openingQuote > -1) {
                                        int startOfUrl = openingQuote + 1;
                                        int closingQuote = ourBookmarkXML.indexOf(SBIP_URL_SUFFIX, startOfUrl);
                                        if (closingQuote <= openingQuote) continue;
                                        String oldUrl = ourBookmarkXML.substring(startOfUrl, closingQuote);
                                        if (newUrl != null) continue;
                                        newUrl = PromotionUtil.getNewSBIPUrl((String)oldUrl, (String)targetReposName, infoMaps);
                                        break;
                                    }
                                } else {
                                    newUrl = imapPath;
                                }
                            }
                        }
                    }
                    if (newUrl == null) {
                        rc |= 8;
                        errMsg = RB.getStringResource("DEIL.unableToCreateURLForInfoMap.fmt.txt");
                        errMsg = MessageFormat.format(errMsg, deName, deIDFromMap);
                        importLogger.error((Object)errMsg);
                        continue;
                    }
                    ServerInterface server = operation.getServer();
                    if (server == null) continue;
                    PathUrl pathUrl = null;
                    pathUrl = newUrl.startsWith("SBIP://") ? new PathUrl(newUrl) : PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)newUrl);
                    MetadataInterface mi = null;
                    try {
                        mi = server.getObjectByPath(pathUrl);
                    }
                    catch (Exception e) {
                        String warnMsg = RB.getStringResource("DEIL.infoMapDoesNotExists.fmt.txt");
                        warnMsg = MessageFormat.format(warnMsg, deName, deIDFromMap, pathUrl.toString());
                        importLogger.warn((Object)warnMsg);
                    }
                    if (operation.getPackageFileVersion() < 9200) {
                        if (pathUrl.getType().equals("BriefInformationMap")) {
                            pathUrl.setType("InformationMap");
                        }
                        ConnectionPointUtil.createImportConnectionPoint((ImportOperationInterface)operation, (ImportItemInterface)item, (PathUrl)pathUrl);
                        continue;
                    }
                    if (null != mi) continue;
                    if (operation.getPromotionType() == 2) {
                        rc |= 4;
                        String msg = MessageFormat.format(RB.getStringResource("DEIL.infoMapDoesNotExists.fmt.txt"), item.toString(), deIDFromMap, newUrl);
                        importLogger.warn((Object)msg);
                        continue;
                    }
                    ConnectionPointInterface cpoint = connMgr.getConnectionByPath(ConnectionObjectType.PublicType, "InformationMap", pathUrl.getAbsolutePath());
                    if (null != cpoint) continue;
                    String path = PromotionUtil.getAbsolutePathForSBIPUrl((PathUrl)pathUrl);
                    String objectType = (String)UtilPromotion._smartObjectMap.get(pathUrl.getType());
                    if (objectType == null) {
                        objectType = pathUrl.getType();
                    }
                    MissingResourceInterface resource = resourceHandler.createMissingResource(objectType, path);
                    resource.addDependentObject(item);
                }
            }
            catch (Exception e) {
                String msg = RB.getStringResource("DEIL.exception.txt");
                log.log(Level.WARNING, msg, e);
                importLogger.warn((Object)msg, (Throwable)e);
                rc |= 4;
            }
        }
        return rc;
    }

    private String processModelXML(String modelXML) throws MetadataException {
        String result = null;
        Document doc = null;
        try {
            doc = DataExplorationImportListener.newDocument("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><a x=\"" + modelXML + "\"/>");
        }
        catch (MetadataException mde) {
            log.log(Level.WARNING, "Problems parsing the XML.  Retrying with encoded XML\n{0}", modelXML);
            doc = DataExplorationImportListener.newDocument("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><e x=\"" + StringEscapeUtils.escapeXml((String)modelXML) + "\"/>");
        }
        Element topElement = doc.getDocumentElement();
        if (topElement != null) {
            result = "e".equalsIgnoreCase(topElement.getTagName()) ? StringEscapeUtils.unescapeXml((String)DataExplorationImportListener.getAttr(topElement, "x")) : DataExplorationImportListener.getAttr(topElement, "x");
        }
        return result;
    }

    protected static Document newDocument(String strXML) throws MetadataException {
        Document doc = null;
        try {
            StringReader strReader = new StringReader(strXML);
            InputSource inputSource = new InputSource(strReader);
            doc = DataExplorationImportListener.getDocumentBuilder().parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException((Throwable)e, null);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e, null);
        }
        catch (SAXException e) {
            throw new MetadataException((Throwable)e, null);
        }
        return doc;
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }

    private static String getAttr(Element element, String attrName) {
        String outValue = null;
        Attr attrNode = element.getAttributeNode(attrName);
        if (attrNode != null) {
            outValue = attrNode.getValue();
        }
        return outValue;
    }

    private boolean containsDataExploration(List depObjList) {
        boolean containsDataExploration = false;
        Iterator objItor = depObjList.iterator();
        while (objItor.hasNext() && !containsDataExploration) {
            ImportItemInterface item = (ImportItemInterface)objItor.next();
            String type = item.getTypeInterface().getPublicType();
            if (!"DataExploration".equals(type)) continue;
            containsDataExploration = true;
        }
        return containsDataExploration;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rcLocal = this.updateDataExplorations(operation, objects);
        return rcLocal;
    }

    private int updateDataExplorations(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        int retValue = 0;
        log.fine("Data Exploration Import Listener Invoked, object count = " + objects.size());
        String deName = null;
        block6: for (ImportItemInterface item : objects) {
            String targetMdObjFQID = item.getTargetID();
            deName = item.getName();
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("DEIL.StatusIndicator.fmt.txt"), (Object)item.getName()));
            try {
                ServerInterface server;
                List bks;
                MetadataInterface mi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetMdObjFQID, (String)item.getTypeInterface().getMetadataType());
                if (!(mi instanceof DataExplorationEntryInterface)) continue;
                String newUrl = null;
                String mapId = null;
                DataExplorationEntryInterface deEntry = (DataExplorationEntryInterface)mi;
                String targetReposName = operation.getRepositoryName();
                ArrayList infoMaps = new ArrayList();
                infoMaps.addAll(operation.getImportItems("InformationMap"));
                infoMaps.addAll(operation.getImportItems("InformationMap.OLAP"));
                infoMaps.addAll(operation.getImportItems("InformationMap.Relational"));
                List connections = item.getConnectionPoints();
                for (ConnectionPointInterface cpi : connections) {
                    if (!"InformationMap".equals(cpi.getPublicType())) continue;
                    String mapid = cpi.getSourceID();
                    String targetid = cpi.getTargetID();
                    if (null == targetid || targetid.equals(mapid)) continue;
                    deEntry.setInformationMapId(targetid);
                    deEntry.update();
                    continue block6;
                }
                try {
                    Property propWithId = OMRUtils.getPropertyByName((Transformation)((Transformation)deEntry.getRepositoryEntity()), (String)"informationMapId");
                    if (null != propWithId) {
                        mapId = propWithId.getDefaultValue();
                    }
                    if (null != mapId) {
                        mapId = mapId.trim();
                    }
                }
                catch (Exception e) {
                    mapId = null;
                }
                try {
                    if (null == mapId) {
                        mapId = deEntry.getInformationMapId();
                    }
                }
                catch (Exception e) {
                    mapId = null;
                }
                String targetURL = null;
                if (mapId != null && mapId.trim().length() > 0) {
                    targetURL = PromotionUtil.getTargetPathForSourceId((String)mapId, infoMaps);
                }
                if (targetURL != null) {
                    newUrl = "SBIP://" + targetReposName + "/" + targetURL + "(BriefInformationMap)";
                }
                if ((bks = deEntry.getBookmarks()) != null && !bks.isEmpty()) {
                    for (BookmarkEntryInterface bk : bks) {
                        String dataModelState = bk.getDataModelState();
                        StringBuffer buf = new StringBuffer(dataModelState);
                        int openingQuote = buf.indexOf(SBIP_URL_PREFIX);
                        while (openingQuote > -1) {
                            int startOfUrl = openingQuote + 1;
                            int closingQuote = buf.indexOf(SBIP_URL_SUFFIX, startOfUrl);
                            if (closingQuote > openingQuote) {
                                String oldUrl = buf.substring(startOfUrl, closingQuote);
                                log.fine("old url = " + oldUrl);
                                if (newUrl == null) {
                                    newUrl = PromotionUtil.getNewSBIPUrl((String)oldUrl, (String)targetReposName, infoMaps);
                                }
                                if (newUrl != null) {
                                    buf.replace(startOfUrl, closingQuote, newUrl);
                                }
                            } else {
                                log.warning("No closing quote found!");
                            }
                            openingQuote = buf.indexOf(SBIP_URL_PREFIX, startOfUrl);
                        }
                        bk.setDataModelState(buf.toString());
                        bk.update();
                    }
                }
                if (newUrl == null || (server = operation.getServer()) == null) continue;
                MetadataInterface metaI = server.getObjectByPath(new PathUrl(newUrl));
                if (metaI != null) {
                    String id = metaI.getReposId();
                    deEntry.setInformationMapId(id);
                    deEntry.update();
                    continue;
                }
                String errMsg = RB.getStringResource("DEIL.infoMapDoesNotExists.fmt.txt");
                errMsg = MessageFormat.format(errMsg, deName, deEntry.getReposId(), newUrl);
                log.warning(errMsg);
                importLogger.warn((Object)errMsg);
            }
            catch (Exception e) {
                String msg = deName == null ? RB.getStringResource("DEIL.ImportFailedGeneral.txt") : UtilMisc.getMessage((String)RB.getStringResource("DEIL.ImportFailedSpecific.fmt.txt"), (Object)deName);
                log.log(Level.SEVERE, msg, e);
                importLogger.error((Object)msg, (Throwable)e);
                retValue |= 8;
            }
        }
        return retValue;
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }
}

