/*
 * Decompiled with CFR 0.152.
 */
package MITI.secretvault;

import MITI.bridges.maven.ArtifactId;
import MITI.literals.SecretVaultLiterals;
import MITI.secretvault.SecretProviderOption;
import MITI.util.text.TextLiteralCollection;

public enum SecretProviderType {
    AZURE(SecretVaultLiterals.PROVIDER_TYPE_AZURE, new ArtifactId[]{new ArtifactId("com.azure", "azure-identity", "1.2.0"), new ArtifactId("com.azure", "azure-security-keyvault-secrets", "4.2.3")}, "https://", SecretProviderOption.TENANT_ID, SecretProviderOption.APP_ID, SecretProviderOption.APP_SECRET),
    AMAZON(SecretVaultLiterals.PROVIDER_TYPE_AMAZON, new ArtifactId[]{new ArtifactId("software.amazon.awssdk", "secretsmanager", "2.16.41"), new ArtifactId("org.slf4j", "slf4j-nop", "1.7.28")}, "arn:aws:secretsmanager:", SecretProviderOption.ACCESS_KEY_ID, SecretProviderOption.SECRET_ACCESS_KEY),
    GOOGLE(SecretVaultLiterals.PROVIDER_TYPE_GOOGLE, new ArtifactId[]{new ArtifactId("com.google.cloud", "google-cloud-secretmanager", "1.5.2")}, "projects/", SecretProviderOption.SERVICE_ACCOUNT_ID, SecretProviderOption.PRIVATE_KEY_FILE);

    private TextLiteralCollection.TextLiteral name;
    private String prefix;
    private ArtifactId[] artifactIds;
    private SecretProviderOption[] options;

    private SecretProviderType(TextLiteralCollection.TextLiteral textLiteral, ArtifactId[] artifactIdArray, String string2, SecretProviderOption ... secretProviderOptionArray) {
        this.name = textLiteral;
        this.prefix = string2;
        this.artifactIds = artifactIdArray;
        this.options = secretProviderOptionArray;
    }

    public TextLiteralCollection.TextLiteral getName() {
        return this.name;
    }

    public ArtifactId[] getArtifactIds() {
        return this.artifactIds;
    }

    public SecretProviderOption[] getOptions() {
        return this.options;
    }

    public static SecretProviderType get(String string) {
        for (SecretProviderType secretProviderType : SecretProviderType.values()) {
            if (secretProviderType.prefix.isEmpty() || !string.toLowerCase().startsWith(secretProviderType.prefix)) continue;
            return secretProviderType;
        }
        return null;
    }
}

