/*
 * Decompiled with CFR 0.152.
 */
package MITI.secretvault;

import MITI.literals.SecretVaultLiterals;
import MITI.util.text.TextLiteralCollection;

public enum SecretProviderOption {
    TENANT_ID("Tenant Id", false),
    APP_ID("App Id", false),
    APP_SECRET("App Secret", true),
    ACCESS_KEY_ID("Access Key Id", false),
    SECRET_ACCESS_KEY("Secret Access Key", true),
    SERVICE_ACCOUNT_ID("Service Account Id", false),
    PRIVATE_KEY_FILE("Private Key File", true);

    private TextLiteralCollection.TextLiteral name;
    private TextLiteralCollection.TextLiteral description;
    private boolean isHidden;
    private String code;

    private SecretProviderOption(String string2, boolean bl) {
        this.name = SecretVaultLiterals.get("provider_option_" + string2.toLowerCase().replace(" ", "_") + "_name");
        this.description = SecretVaultLiterals.get("provider_option_" + string2.toLowerCase().replace(" ", "_") + "_desc");
        this.isHidden = bl;
        this.code = string2.replace(" ", "");
    }

    public TextLiteralCollection.TextLiteral getName() {
        return this.name;
    }

    public TextLiteralCollection.TextLiteral getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getCode() {
        return this.code;
    }

    public static SecretProviderOption get(String string) {
        for (SecretProviderOption secretProviderOption : SecretProviderOption.values()) {
            if (!secretProviderOption.getCode().equals(string)) continue;
            return secretProviderOption;
        }
        return null;
    }
}

