/*
 * Decompiled with CFR 0.152.
 */
package MITI.secretvault;

import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.secretvault.SecretVault;
import MITI.secretvault.SecretProvider;
import MITI.secretvault.SecretProviderOption;
import MITI.secretvault.SecretProviderType;
import MITI.util.ProcessBuilder;
import MITI.util.XmlUtil;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class MIRSecretVault {
    private static final String SECRET_ID_OPTION = "SecretId";
    private static final String[] MITI_JARS = new String[]{"Yaml/snakeyaml-2.0.jar", "MIRUtil.jar", "MIR.jar", "MIRModelBridge.jar", "SecretVault.jar"};

    public static String buildClassPath(MIRSetup mIRSetup, SecretProviderType secretProviderType) {
        ClassPath classPath = new ClassPath(mIRSetup, MIRLogger.getLogger());
        classPath.addRelativePaths(mIRSetup.getJavaDirectory(), MITI_JARS);
        if (secretProviderType.getArtifactIds() != null) {
            classPath.addArtifacts(secretProviderType.getArtifactIds());
        }
        return classPath.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSecret(MIRSetup mIRSetup, String string, Map<String, String> map) {
        SecretProviderType secretProviderType = SecretProviderType.get(string);
        if (secretProviderType != null) {
            File file = null;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder();
                processBuilder.addArgument(mIRSetup.getJavaExecutable());
                processBuilder.addArgument("-cp");
                processBuilder.addArgument(MIRSecretVault.buildClassPath(mIRSetup, secretProviderType));
                processBuilder.addArgument("MITI.secretvault.MIRSecretVault");
                Element element = XmlUtil.parseString("<GetSecret></GetSecret>");
                element.setAttribute(SECRET_ID_OPTION, string);
                for (SecretProviderOption secretProviderOption : secretProviderType.getOptions()) {
                    element.setAttribute(secretProviderOption.getCode(), map.getOrDefault(secretProviderOption.getCode(), ""));
                }
                processBuilder.setInputStream(XmlUtil.getString(element));
                int n = processBuilder.exec();
                if (n == 0) {
                    string = processBuilder.getStdOut();
                } else {
                    SecretVault.ERR_CAN_NOT_RETRIEVE.log(secretProviderType.getName().getText(), string, processBuilder.getStdErr(), processBuilder.getStdOut());
                }
            }
            catch (Exception exception) {
                SecretVault.ERR_CAN_NOT_RETRIEVE.log(exception, secretProviderType.getName().getText(), string, exception.getMessage());
            }
            finally {
                FileUtil.delete(file);
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Element element = XmlUtil.parseStream(System.in);
        String string = element.getAttribute(SECRET_ID_OPTION);
        SecretProviderType secretProviderType = SecretProviderType.get(string);
        try {
            SecretProvider secretProvider = SecretProvider.getInstance(secretProviderType);
            if (secretProvider != null) {
                HashMap<SecretProviderOption, String> hashMap = new HashMap<SecretProviderOption, String>();
                for (SecretProviderOption secretProviderOption : secretProviderType.getOptions()) {
                    hashMap.put(secretProviderOption, element.getAttribute(secretProviderOption.getCode()));
                }
                String string2 = secretProvider.getSecret(string, hashMap);
                if (string2 != null) {
                    System.out.print(string2);
                } else {
                    SecretVault.ERR_CAN_NOT_RETRIEVE.log(secretProviderType.getName().getText(), string, "", "");
                    System.exit(1);
                }
            } else {
                SecretVault.ERR_UNKNOWN_PROVIDER.log(new Object[0]);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            SecretVault.ERR_CAN_NOT_RETRIEVE.log(secretProviderType.getName().getText(), string, exception.getMessage(), stringWriter.toString());
            System.exit(1);
        }
    }
}

