/*
 * Decompiled with CFR 0.152.
 */
package MITI.secretvault;

import MITI.secretvault.SecretProvider;
import MITI.secretvault.SecretProviderOption;
import MITI.util.file.FileUtil;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class GoogleSecretManager
extends SecretProvider {
    @Override
    public String getSecret(String string, Map<SecretProviderOption, String> map) throws IOException {
        String string2 = map.getOrDefault((Object)SecretProviderOption.PRIVATE_KEY_FILE, "");
        GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(string2.getBytes(FileUtil.UTF8))).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
        googleCredentials.refreshIfExpired();
        SecretManagerServiceSettings secretManagerServiceSettings = ((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)googleCredentials))).build();
        try (SecretManagerServiceClient secretManagerServiceClient = SecretManagerServiceClient.create((SecretManagerServiceSettings)secretManagerServiceSettings);){
            SecretVersionName secretVersionName = SecretVersionName.parse((String)string);
            AccessSecretVersionResponse accessSecretVersionResponse = secretManagerServiceClient.accessSecretVersion(secretVersionName);
            String string3 = accessSecretVersionResponse.getPayload().getData().toStringUtf8();
            return string3;
        }
    }
}

