/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment.servicewrapper;

import com.sas.net.ssl.SSLRMIConfiguration;
import com.sas.net.ssl.SSLRMIException;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.servicewrapper.AbstractServiceWrapper;
import com.sas.services.deployment.servicewrapper.RB;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tanukisoftware.wrapper.WrapperManager;

public final class ServiceWrapperImpl
extends AbstractServiceWrapper {
    private static final int NUM_CHARS_PER_SERVICE = 100;

    private ServiceWrapperImpl(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        new ServiceWrapperImpl(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(String[] args) throws InitializationException, ServiceException {
        Properties props;
        block14: {
            if (args.length < 1) {
                String msg = RB.getStringResource("ServiceWrapperImpl.metadatasource.required.parameter.txt");
                this.log(6, msg);
                throw new ServiceException(msg);
            }
            String propsFile = args[0];
            this.log(2, MessageFormat.format(RB.getStringResource("ServiceWrapperImpl.metadatasource.file.fmt.txt"), propsFile));
            FileInputStream fis = null;
            props = new Properties();
            try {
                fis = new FileInputStream(propsFile);
                props.load(fis);
                if (fis == null) break block14;
            }
            catch (IOException e) {
                try {
                    throw new ServiceException((Throwable)e, MessageFormat.format(RB.getStringResource("ServiceWrapperImpl.loadProperties.ex.fmt.txt"), propsFile));
                }
                catch (Throwable throwable) {
                    if (fis == null) throw throwable;
                    try {
                        ((InputStream)fis).close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        this.log(4, MessageFormat.format(RB.getStringResource("ServiceWrapperImpl.closeIO.ex.fmt.txt"), propsFile));
                    }
                    throw throwable;
                }
            }
            try {
                ((InputStream)fis).close();
            }
            catch (IOException ioe) {
                this.log(4, MessageFormat.format(RB.getStringResource("ServiceWrapperImpl.closeIO.ex.fmt.txt"), propsFile));
            }
        }
        ServiceWrapperImpl.setSSLRMIConfiguration();
        MetadataSourceInterface metadataSource = null;
        List<RemoteServiceInterface> deployedServices = new ArrayList(0);
        try {
            metadataSource = MetadataSourceFactory.newMetadataSource((Properties)props);
            deployedServices = ServiceLoader.deployServices((MetadataSourceInterface)metadataSource, (DiscoveryServiceInterface)DiscoveryService.defaultInstance());
            this.log(2, RB.getStringResource("ServiceWrapperImpl.deploy.success.txt"));
        }
        finally {
            if (metadataSource != null) {
                metadataSource.destroy();
            }
        }
        if (deployedServices.isEmpty()) {
            this.log(4, RB.getStringResource("ServiceWrapperImpl.noServicesDeployed.ex.txt"));
            return;
        }
        this.logDeployedServices(deployedServices);
    }

    @Override
    public void destroy() throws ServiceException, RemoteException {
        DiscoveryService.defaultInstance().destroy();
    }

    private static void setSSLRMIConfiguration() throws ServiceException {
        SSLRMIConfiguration sslRMIConfiguration = null;
        try {
            sslRMIConfiguration = new SSLRMIConfiguration((Properties)null);
        }
        catch (IllegalArgumentException e) {
            WrapperManager.log((int)1, (String)RB.getStringResource("ServiceWrapperImpl.noSSLRMI.log"));
        }
        catch (SSLRMIException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("ServiceWrapperImpl.configureSSLRMI.ex.txt"));
        }
        finally {
            if (sslRMIConfiguration != null) {
                SSLRMISocketFactories.getInstance().setConfiguration(sslRMIConfiguration);
            }
        }
    }

    private void logDeployedServices(List<RemoteServiceInterface> deployedServices) throws ServiceException {
        Logger logger = LogManager.getLogger(ServiceWrapperImpl.class);
        int numServices = deployedServices.size();
        try {
            String lineSeparator = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            StringBuilder buffer = new StringBuilder(numServices * 100);
            buffer.append(lineSeparator);
            RemoteServiceInterface service = null;
            int i = 0;
            while (i < numServices) {
                service = deployedServices.get(i++);
                buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceWrapperImpl.service.fmt.txt", (Object)i, (Object)service.getClass().getName(), (Object)service.getEntityKey()));
                buffer.append(lineSeparator);
            }
            logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceWrapperImpl.servicesListing.fmt.txt", (Object)lineSeparator, (Object)buffer.toString()));
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

