/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment.servicewrapper;

import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.servicewrapper.RB;
import com.sas.services.deployment.servicewrapper.ServiceWrapperInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public abstract class AbstractServiceWrapper
implements ServiceWrapperInterface,
WrapperListener {
    private static final int POLL_TIME_STARTING_MSEC = 20000;
    private static final int POLL_TIME_STOPPING_MSEC = 20000;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_INFO = 2;
    public static final int LOG_LEVEL_STATUS = 3;
    public static final int LOG_LEVEL_WARN = 4;
    private final Object SYNC_OBJECT = new Object();
    private final Object SYNC_OBJECT_STOP = new Object();
    private DeployRunnable _deployer;

    protected AbstractServiceWrapper(String[] args) {
        SecurityManager securityManager = null;
        try {
            securityManager = AccessController.doPrivileged(new PrivilegedAction<SecurityManager>(){

                @Override
                public SecurityManager run() {
                    return System.getSecurityManager();
                }
            });
        }
        catch (SecurityException e) {
            LogManager.getLogger(this.getClass()).error(RB.getStringResource("ASW.getSecurityManager.ex.log"), (Throwable)e);
        }
        if (securityManager == null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<SecurityManager>(){

                    @Override
                    public SecurityManager run() {
                        SecurityManager securityManager = new SecurityManager();
                        System.setSecurityManager(securityManager);
                        return securityManager;
                    }
                });
            }
            catch (SecurityException e) {
                LogManager.getLogger(this.getClass()).error(Message.format((ResourceBundle)RB.getResources(), (String)"ASW.setSecurityManager.ex.fmt.log", (Object)SecurityManager.class.getName()), (Throwable)e);
            }
        }
        WrapperManager.start((WrapperListener)this, (String[])args);
    }

    @Override
    public abstract void init(String[] var1) throws InitializationException, ServiceException;

    @Override
    public abstract void destroy() throws ServiceException, RemoteException;

    protected void log(int level, String message) {
        WrapperManager.log((int)level, (String)message);
    }

    public Integer start(String[] args) {
        block3: {
            this._deployer = new DeployRunnable(args);
            Thread thread = new Thread((Runnable)this._deployer, this._deployer.getClass().getName());
            thread.start();
            do {
                if (this._deployer.isStarted()) break block3;
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ie) {
                    WrapperManager.log((int)5, (String)ie.getLocalizedMessage());
                }
            } while (thread.isAlive());
            return -1;
        }
        WrapperManager.log((int)1, (String)RB.getStringResource("ASW.started.txt"));
        return null;
    }

    public int stop(int exitCode) {
        if (this._deployer != null) {
            this._deployer.stop();
            while (true) {
                if (this._deployer.isStopped()) {
                    WrapperManager.log((int)1, (String)RB.getStringResource("ASW.stopped.txt"));
                    break;
                }
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        return exitCode;
    }

    public void controlEvent(int event) {
    }

    class DeployRunnable
    implements Runnable {
        private final String[] _args;
        private boolean _isStarted;
        private boolean _isStopping;
        private boolean _isStopped;

        DeployRunnable(String[] args) {
            if (null == args) {
                this._args = new String[0];
            } else {
                int numArgs = args.length;
                this._args = new String[numArgs];
                System.arraycopy(args, 0, this._args, 0, numArgs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable exception = null;
            try {
                AbstractServiceWrapper.this.init(this._args);
                Object object = AbstractServiceWrapper.this.SYNC_OBJECT;
                synchronized (object) {
                    this._isStarted = true;
                }
                this.waitForStop();
            }
            catch (InitializationException e) {
                exception = e;
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                try {
                    if (exception != null) {
                        LogManager.getLogger(this.getClass()).error(RB.getStringResource("ASW.deployServices.ex.txt"), exception);
                    }
                }
                finally {
                    this.terminateServices();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminateServices() {
            Throwable exception = null;
            try {
                AbstractServiceWrapper.this.destroy();
            }
            catch (ServiceException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception != null) {
                    LogManager.getLogger(this.getClass()).error(RB.getStringResource("ASW.terminateServices.ex.log"), exception);
                    WrapperManager.log((int)5, (String)exception.getLocalizedMessage());
                }
            }
            Object object = AbstractServiceWrapper.this.SYNC_OBJECT;
            synchronized (object) {
                this._isStopped = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitForStop() {
            try {
                while (true) {
                    Object object = AbstractServiceWrapper.this.SYNC_OBJECT_STOP;
                    synchronized (object) {
                        if (this._isStopping) {
                            return;
                        }
                        AbstractServiceWrapper.this.SYNC_OBJECT_STOP.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = AbstractServiceWrapper.this.SYNC_OBJECT_STOP;
            synchronized (object) {
                this._isStopping = true;
                AbstractServiceWrapper.this.SYNC_OBJECT_STOP.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isStopped() {
            boolean isStopped = false;
            Object object = AbstractServiceWrapper.this.SYNC_OBJECT;
            synchronized (object) {
                isStopped = this._isStopped;
            }
            return isStopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isStarted() {
            boolean isStarted = false;
            Object object = AbstractServiceWrapper.this.SYNC_OBJECT;
            synchronized (object) {
                isStarted = this._isStarted;
            }
            return isStarted;
        }
    }
}

