/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.iqt;

import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ProgressMonitor
extends JFrame {
    private JProgressBar bar;
    private JPanel statusPanel;
    private JLabel statusText = new JLabel("Reading validation data...");
    private JPanel bottomPanel;
    private JLabel bottomLabel = new JLabel("Validation Errors: ");
    private BufferedImage image;
    private JEditorPane textPane;

    public ProgressMonitor() {
        super("Install Qualification Tool");
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
            }
            this.setSize(800, 140);
            this.setVisible(true);
            this.setLocation(142, 112);
            this.setLayout(new GridLayout(3, 1));
            this.setDefaultCloseOperation(3);
            this.image = ImageIO.read(this.getClass().getResource("res/saslogo.gif"));
            this.setIconImage(this.image);
            this.statusPanel = new JPanel();
            this.statusPanel.add(this.statusText);
            this.textPane = new JEditorPane();
            this.textPane.setContentType("text/html;charset=utf-8");
            this.textPane.setEditable(false);
            this.textPane.setBackground(SystemColor.control);
            this.textPane.setSize(this.getWidth(), 20);
            this.textPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        try {
                            String url = e.getURL().toString();
                            String osName = System.getProperty("os.name");
                            if (osName.startsWith("Mac OS")) {
                                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                                openURL.invoke(null, url);
                            } else if (osName.startsWith("Windows")) {
                                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                            } else {
                                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                                String browser = null;
                                for (int count = 0; count < browsers.length && browser == null; ++count) {
                                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                                        browser = browsers[count];
                                    }
                                    if (browser == null) {
                                        System.out.println("Could not determine appropriate viewer for report file.\nNo html viewer found.");
                                        continue;
                                    }
                                    Runtime.getRuntime().exec(new String[]{browser, url});
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.add(this.statusPanel);
            this.bar = new JProgressBar();
            this.bar.setValue(0);
            this.bar.setStringPainted(true);
            this.add(this.bar);
            this.bottomPanel = new JPanel();
            this.bottomPanel.add(this.bottomLabel);
            this.add(this.bottomPanel);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void progress(int currentFileNum) {
        this.bar.setValue(currentFileNum);
    }

    public JLabel getStatusText() {
        return this.statusText;
    }

    public JPanel getStatusPanel() {
        return this.statusPanel;
    }

    public JLabel getBottomLabel() {
        return this.bottomLabel;
    }

    public JProgressBar getBar() {
        return this.bar;
    }

    public JEditorPane getTextPane() {
        return this.textPane;
    }
}

