/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.lasr;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class DataProviderLibraryPanel
extends WsDescriptionWizardTab {
    private SASLibrary m_library;
    private String m_strReposID;
    private JLabel m_lblDataProvider;
    private WAComboBox m_choDataProvider;
    private JButton m_btnDataProvider;
    protected static final String DATAPROVIDERLIBRARY = "DataProviderLibrary";
    protected static final String NONE = "None";
    protected static final WAdminResource m_bundle = new WAdminResource(DataProviderLibraryPanel.class);
    private static final long serialVersionUID = 1L;

    public DataProviderLibraryPanel(SASLibrary library, String reposID) {
        this.m_library = library;
        this.m_strReposID = reposID;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() {
        try {
            block10: {
                block9: {
                    if (this.m_choDataProvider.getSelectedItem() == NONE) break block9;
                    SortableSASLibrary libSortable = (SortableSASLibrary)this.m_choDataProvider.getSelectedItem();
                    SASLibrary library = libSortable.getLibrary();
                    AssociationList lstTargetTransformations = this.m_library.getTargetTransformations();
                    block3: for (AbstractTransformation transform : lstTargetTransformations) {
                        if (!(transform instanceof Transformation) || !transform.getTransformRole().equalsIgnoreCase(DATAPROVIDERLIBRARY)) continue;
                        AssociationList lstTransformationSources = transform.getTransformationSources();
                        for (Root source : lstTransformationSources) {
                            if (!(source instanceof SASLibrary)) continue;
                            SASLibrary libSource = (SASLibrary)source;
                            if (libSource == library) {
                                return;
                            }
                            lstTransformationSources.clear();
                            lstTransformationSources.add(library);
                            break block3;
                        }
                    }
                    if (lstTargetTransformations.size() != 0) break block10;
                    Transformation transform = (Transformation)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_library.getObjectStore(), null, "DataProviderLibraryTransformation", "Transformation", this.m_strReposID.substring(9));
                    transform.setTransformRole(DATAPROVIDERLIBRARY, 1);
                    transform.getTransformationSources().add((Object)library);
                    this.m_library.getTargetTransformations().add((Object)transform);
                    break block10;
                }
                AssociationList lstTargetTransformations = this.m_library.getTargetTransformations();
                for (AbstractTransformation transform : lstTargetTransformations) {
                    if (!(transform instanceof Transformation) || !transform.getTransformRole().equalsIgnoreCase(DATAPROVIDERLIBRARY)) continue;
                    Workspace.getMdFactory().deleteMetadataObject((CMetadata)transform);
                    break;
                }
            }
            if (this.m_library.getFQID().indexOf(36) != -1 && this.m_library.getExtensions().size() == 0) {
                List<String[]> lstExtensions = this.getExtendedAttributes();
                for (int extIndex = 0; extIndex < lstExtensions.size(); ++extIndex) {
                    Extension extension = (Extension)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_library.getObjectStore(), null, "Extension", "Extension", this.m_strReposID.substring(9));
                    extension.setName(lstExtensions.get(extIndex)[0], 1);
                    extension.setDesc(lstExtensions.get(extIndex)[1], 1);
                    extension.setValue(lstExtensions.get(extIndex)[2], 1);
                    this.m_library.getExtensions().add((Object)extension);
                }
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void moveDataToView() {
        block8: {
            try {
                String strSelect;
                this.m_choDataProvider.removeAllItems();
                this.m_choDataProvider.addItem((Object)NONE);
                String strOptions = strSelect = "<XMLSELECT search=\"SASLibrary[@Engine='BASE' OR @Engine='V7' OR @Engine='V701' OR @Engine='V8' OR @Engine='V9']\" />";
                int flags = 8600;
                List lstLibraries = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getObjectStore(), this.m_strReposID, "SASLibrary", flags, strOptions);
                ArrayList<SortableSASLibrary> lstSortableLibraries = new ArrayList<SortableSASLibrary>();
                for (SASLibrary library : lstLibraries) {
                    SortableSASLibrary libSortable = new SortableSASLibrary(library);
                    lstSortableLibraries.add(libSortable);
                }
                Collections.sort(lstSortableLibraries);
                for (SortableSASLibrary libSortable : lstSortableLibraries) {
                    this.m_choDataProvider.addItem((Object)libSortable);
                }
                AssociationList lstTargetTransformations = this.m_library.getTargetTransformations();
                for (AbstractTransformation transform : lstTargetTransformations) {
                    if (!(transform instanceof Transformation) || !transform.getTransformRole().equalsIgnoreCase(DATAPROVIDERLIBRARY)) continue;
                    AssociationList lstTransformationSources = transform.getTransformationSources();
                    for (Root source : lstTransformationSources) {
                        SASLibrary libSource;
                        if (!(source instanceof SASLibrary) || !(libSource = (SASLibrary)source).getEngine().equalsIgnoreCase("BASE") && !libSource.getEngine().equalsIgnoreCase("V7") && !libSource.getEngine().equalsIgnoreCase("V701") && !libSource.getEngine().equalsIgnoreCase("V8") && !libSource.getEngine().equalsIgnoreCase("V9")) continue;
                        for (int index = 1; index < this.m_choDataProvider.getItemCount(); ++index) {
                            SortableSASLibrary libSortable = (SortableSASLibrary)this.m_choDataProvider.getItemAt(index);
                            if (libSortable.getLibrary() != libSource) continue;
                            this.m_choDataProvider.setSelectedItem((Object)libSortable);
                            break block8;
                        }
                        break block8;
                    }
                    break;
                }
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    protected void onNewLibrary() {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            ViewListener viewListener = new ViewListener(store);
            Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)viewListener);
            Container parent = this.getTopLevelAncestor();
            LibraryWizard wizard = null;
            if (parent instanceof JFrame) {
                wizard = new LibraryWizard((JFrame)parent, this.m_strReposID, m_bundle.getString("DataProviderLibraryPanel.Title.txt"), "BASE", store);
            } else if (parent instanceof Dialog) {
                wizard = new LibraryWizard((Dialog)parent, this.m_strReposID, m_bundle.getString("DataProviderLibraryPanel.Title.txt"), "BASE", store);
            }
            wizard.show();
            if (wizard.getReturnValue() == 2) {
                Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)viewListener);
            }
            if (store != null) {
                store.dispose();
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public String createFinishString() {
        String strFinish = new String();
        if (this.m_choDataProvider.getSelectedItem() != NONE) {
            strFinish = strFinish + m_bundle.getString("DataProviderLibraryPanel.DataProvider.Name.txt") + "\n\t" + this.m_choDataProvider.getSelectedItem() + "\n";
        }
        return strFinish;
    }

    private List<String[]> getExtendedAttributes() throws RemoteException, MdException {
        ArrayList<String[]> lstExtensions = new ArrayList<String[]>();
        String strTemplate = "<TEMPLATES><SoftwareComponent><PropertySets/></SoftwareComponent><PropertySet><SetProperties/></PropertySet></TEMPLATES>";
        String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='bihpgrdc']\"/>";
        String strOptions = strTemplate + strSelect;
        int flags = 8604;
        List lstSoftwareComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getObjectStore(), this.m_strReposID, "SoftwareComponent", flags, strOptions);
        if (lstSoftwareComponents.size() > 0) {
            SoftwareComponent sc = (SoftwareComponent)lstSoftwareComponents.get(0);
            AssociationList lstSet = sc.getPropertySets();
            for (PropertySet set : lstSet) {
                if (!set.getPropertySetName().equalsIgnoreCase("Application Configuration")) continue;
                AssociationList lstProperties = set.getSetProperties();
                for (Property property : lstProperties) {
                    if (!property.getPropertyName().startsWith("VA.")) continue;
                    String strName = property.getPropertyName();
                    String strDesc = property.getDesc();
                    String strValue = property.getDefaultValue();
                    lstExtensions.add(new String[]{strName, strDesc, strValue});
                }
            }
        }
        return lstExtensions;
    }

    protected void initialize() {
        this.m_lblDataProvider = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblDataProvider, m_bundle.getString("DataProviderLibraryPanel.DataProvider.Name.txt"));
        this.m_choDataProvider = new WAComboBox();
        this.m_choDataProvider.setRenderer((ListCellRenderer)new MetadataObjectCellRenderer());
        this.m_lblDataProvider.setLabelFor((Component)this.m_choDataProvider);
        this.m_btnDataProvider = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_btnDataProvider, m_bundle.getString("DataProviderLibraryPanel.New.txt"));
        this.m_btnDataProvider.setMargin(new Insets(0, 4, 0, 4));
        this.m_btnDataProvider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataProviderLibraryPanel.this.onNewLibrary();
            }
        });
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblDataProvider, gbc);
        this.add(this.m_lblDataProvider);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_choDataProvider, gbc);
        this.add((Component)this.m_choDataProvider);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_btnDataProvider, gbc);
        this.add(this.m_btnDataProvider);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private class SortableSASLibrary
    implements Comparable<Object> {
        private SASLibrary m_library;

        public SortableSASLibrary(SASLibrary library) {
            this.m_library = library;
        }

        public SASLibrary getLibrary() {
            return this.m_library;
        }

        public String toString() {
            try {
                return this.getLibrary().getName();
            }
            catch (RemoteException exc) {
                return super.toString();
            }
        }

        @Override
        public int compareTo(Object o) {
            try {
                return this.getLibrary().getName().compareToIgnoreCase(((SortableSASLibrary)o).getLibrary().getName());
            }
            catch (RemoteException exc) {
                return 0;
            }
        }
    }

    protected class ViewListener
    implements MdFactoryListener {
        private MdObjectStore m_store;

        public ViewListener(MdObjectStore store) {
            this.m_store = store;
        }

        public void MdObjectsCreated(MdFactoryEvent e) {
            try {
                boolean bProcessed = false;
                Object[] aryID = e.getObjectMap().keySet().toArray();
                for (int idIndex = 0; idIndex < aryID.length; ++idIndex) {
                    String strSelect;
                    String strID = (String)aryID[idIndex];
                    CMetadata meta = this.m_store.getObject(strID);
                    if (meta == null || !meta.getCMetadataType().equals("SASLibrary")) continue;
                    Root root = (Root)meta;
                    DataProviderLibraryPanel.this.m_choDataProvider.removeAllItems();
                    String strOptions = strSelect = "<XMLSELECT search=\"SASLibrary[@Engine='BASE' OR @Engine='V7' OR @Engine='V701' OR @Engine='V8' OR @Engine='V9']\" />";
                    int flags = 8584;
                    try {
                        List lstLibraries = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((MdObjectStore)DataProviderLibraryPanel.this.m_library.getObjectStore()), DataProviderLibraryPanel.this.m_strReposID, "SASLibrary", flags, strOptions);
                        for (int libIndex = 0; lstLibraries != null && libIndex < lstLibraries.size(); ++libIndex) {
                            SASLibrary library = (SASLibrary)lstLibraries.get(libIndex);
                            SortableSASLibrary libSortable = new SortableSASLibrary(library);
                            DataProviderLibraryPanel.this.m_choDataProvider.addItem((Object)libSortable);
                            if (!library.getFQID().equals(root.getFQID())) continue;
                            DataProviderLibraryPanel.this.m_choDataProvider.setSelectedItem((Object)libSortable);
                            bProcessed = true;
                        }
                        continue;
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                        return;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)this);
                }
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }

        public void MdObjectsModified(MdFactoryEvent e) {
        }

        public void MdObjectsDeleted(MdFactoryEvent e) {
        }
    }
}

