/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.LoginProperty;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LoadBalancingClusterCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    private IOMProperty m_balAlg;
    private static final int ALGORITHM_COST = 1;
    private static final int ALGORITHM_RESPONSETIME = 2;
    private static final int ALGORITHM_LSF = 3;
    private static final int ALGORITHM_RU = 4;
    private int m_lbVerMajor;
    private int m_lbVerMinor;
    private boolean m_peerIsServer = false;
    private IOMProperty m_respRate;
    private IOMProperty m_pcCost;
    private LoginProperty m_lsfUser;
    private IOMProperty m_lsfTimeout;
    private IOMProperty m_lsfInfo;
    private IOMProperty m_gridLaunch;

    public LoadBalancingClusterCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    @Override
    protected void initialize() {
        super.initialize();
        boolean divNextProp = false;
        for (int i = 0; i < this.m_iomProps.size(); ++i) {
            IOMProperty iomProp = this.m_iomProps.get(i);
            if (divNextProp) {
                divNextProp = false;
                iomProp.addDivider(IOMProperty.getDisplayString(1, "LB.LogicalServerDivider.Name.xmlKey.txt"));
            }
            try {
                if (iomProp.getPropertyName().equalsIgnoreCase("BalancingAlgorithm")) {
                    this.m_balAlg = iomProp;
                    this.m_balAlg.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 1) {
                                if (LoadBalancingClusterCustomizer.this.m_balAlg.getDataValue().equals("tklbcost")) {
                                    LoadBalancingClusterCustomizer.this.setAlgorithmEnabled(1);
                                } else if (LoadBalancingClusterCustomizer.this.m_balAlg.getDataValue().equals("tklbresp")) {
                                    LoadBalancingClusterCustomizer.this.setAlgorithmEnabled(2);
                                } else if (LoadBalancingClusterCustomizer.this.m_balAlg.getDataValue().equals("tklblsf")) {
                                    LoadBalancingClusterCustomizer.this.setAlgorithmEnabled(3);
                                } else if (LoadBalancingClusterCustomizer.this.m_balAlg.getDataValue().equals("tklbmru") || LoadBalancingClusterCustomizer.this.m_balAlg.getDataValue().equals("tklblru")) {
                                    LoadBalancingClusterCustomizer.this.setAlgorithmEnabled(4);
                                }
                            }
                        }
                    });
                } else if (iomProp.getPropertyName().equalsIgnoreCase("PerClientCost")) {
                    this.m_pcCost = iomProp;
                } else if (iomProp.getPropertyName().equalsIgnoreCase("ResponseRefreshRate")) {
                    this.m_respRate = iomProp;
                } else if (iomProp.getPropertyName().equalsIgnoreCase("LSFTimeout")) {
                    this.m_lsfTimeout = iomProp;
                } else if (iomProp.getMetadataProperty().getName().equalsIgnoreCase("LB.Property.LSF.Credentials.Name.xmlKey.txt")) {
                    this.m_lsfUser = (LoginProperty)iomProp;
                } else if (iomProp.getMetadataProperty().getName().equalsIgnoreCase("LB.Property.LSF.GridServer.Name.xmlKey.txt")) {
                    this.m_lsfInfo = iomProp;
                } else if (iomProp.getMetadataProperty().getName().equalsIgnoreCase("LogicalServer.Property.Credentials.Name.xmlKey.txt")) {
                    divNextProp = true;
                } else if (iomProp.getPropertyName().equalsIgnoreCase("PeerObject")) {
                    if (iomProp.getDataValue().toString().equals("Server")) {
                        this.m_peerIsServer = true;
                    }
                } else if (iomProp.getPropertyName().equals("GridLaunch")) {
                    this.m_gridLaunch = iomProp;
                    this.m_gridLaunch.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            boolean enabled = false;
                            if (LoadBalancingClusterCustomizer.this.m_gridLaunch.isEnabled()) {
                                enabled = e.getStateChange() == 2;
                            }
                            LoadBalancingClusterCustomizer.this.m_lsfInfo.setEnabled(enabled);
                            LoadBalancingClusterCustomizer.this.m_lsfTimeout.setEnabled(enabled);
                            LoadBalancingClusterCustomizer.this.m_lsfUser.setEnabled(enabled);
                            if (e.getStateChange() == 1) {
                                try {
                                    LogicalServer ourLogical = (LogicalServer)((Transformation)LoadBalancingClusterCustomizer.this.m_root).getDeployedComponents().get(0);
                                    AssociationList appSrvrs = ourLogical.getUsedByComponents();
                                    ServerContext appSrvr = (ServerContext)appSrvrs.get(0);
                                    AssociationList logSrvrs = appSrvr.getUsingComponents();
                                    ServerComponent gridSrvr = null;
                                    for (int i = 0; i < logSrvrs.size(); ++i) {
                                        LogicalServer logSrvr = (LogicalServer)logSrvrs.get(i);
                                        if (!logSrvr.getPublicType().equalsIgnoreCase("LogicalServer.Grid")) continue;
                                        gridSrvr = (ServerComponent)logSrvr.getUsingComponents().get(0);
                                        break;
                                    }
                                    if (gridSrvr != null) {
                                        LoadBalancingClusterCustomizer.this.m_lsfInfo.setPropertyValue(gridSrvr);
                                    }
                                }
                                catch (RemoteException e1) {
                                    Workspace.handleRemoteException((RemoteException)e1);
                                }
                                catch (MdException e1) {
                                    MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                                }
                            } else {
                                LoadBalancingClusterCustomizer.this.m_lsfInfo.resetProperty();
                            }
                        }
                    });
                }
                if (this.m_viewType != 0) continue;
                iomProp.setPreferredDataWidth(250);
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        try {
            this.m_lbVerMajor = 9;
            this.m_lbVerMinor = 3;
            AssociationList comps = ((Transformation)this.m_root).getDeployedComponents();
            if (comps.size() > 0) {
                int minMajor = this.m_lbVerMajor;
                int minMinor = this.m_lbVerMinor;
                LogicalServer logSrvr = (LogicalServer)comps.get(0);
                AssociationList srvComps = logSrvr.getUsingComponents();
                for (int srv = 0; srv < srvComps.size(); ++srv) {
                    ServerComponent verComp;
                    if (this.m_peerIsServer) {
                        verComp = (ServerComponent)srvComps.get(srv);
                        if (verComp.getMajor() < minMajor) {
                            minMajor = verComp.getMajor();
                        }
                        if (verComp.getMinor() >= minMinor) continue;
                        minMinor = verComp.getMinor();
                        continue;
                    }
                    ServerComponent server = (ServerComponent)srvComps.get(srv);
                    AssociationList spwComps = server.getUsingComponents();
                    for (int spw = 0; spw < spwComps.size(); ++spw) {
                        verComp = (ServerComponent)spwComps.get(spw);
                        if (verComp.getMajor() < minMajor) {
                            minMajor = verComp.getMajor();
                        }
                        if (verComp.getMinor() >= minMinor) continue;
                        minMinor = verComp.getMinor();
                    }
                }
                this.m_lbVerMajor = minMajor;
                this.m_lbVerMinor = minMinor;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        for (int j = 0; j < this.m_iomProps.size(); ++j) {
            this.m_iomProps.get(j).setMinimumVersionInformation(this.m_lbVerMajor, this.m_lbVerMinor);
        }
    }

    @Override
    protected void layoutWidgets() {
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.removeAll();
        this.setLayout(gbLayout);
        JPanel propPanel = this.m_iomProps.getPropertiesPanel();
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = IOMProperty.getNextComponentHorizontalGridValue(propPanel);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        ((GridBagLayout)propPanel.getLayout()).setConstraints(eaterPanel, gbc);
        propPanel.add(eaterPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbLayout.setConstraints(propPanel, gbc);
        this.add(propPanel);
    }

    private void setAlgorithmEnabled(int type) {
        if (this.m_pcCost != null) {
            this.m_pcCost.setEnabled(false);
        }
        if (this.m_respRate != null) {
            this.m_respRate.setEnabled(false);
        }
        if (this.m_lsfInfo != null && this.m_lsfTimeout != null && this.m_lsfUser != null) {
            this.m_lsfInfo.setEnabled(false);
            this.m_lsfTimeout.setEnabled(false);
            this.m_lsfUser.setEnabled(false);
        }
        if (this.m_gridLaunch != null) {
            this.m_gridLaunch.setEnabled(false);
            if (type != 3) {
                this.m_gridLaunch.setPropertyValue("False");
            }
        }
        switch (type) {
            case 1: {
                if (this.m_pcCost == null) break;
                this.m_pcCost.setEnabled(true);
                break;
            }
            case 2: {
                if (this.m_respRate == null) break;
                this.m_respRate.setEnabled(true);
                break;
            }
            case 3: {
                boolean gLaunch = false;
                if (this.m_gridLaunch != null) {
                    this.m_gridLaunch.setEnabled(true);
                    gLaunch = this.m_gridLaunch.getDataValue().equals("True");
                }
                if (gLaunch) break;
                if (this.m_lsfInfo != null) {
                    this.m_lsfInfo.setEnabled(true);
                }
                if (this.m_lsfTimeout != null) {
                    this.m_lsfTimeout.setEnabled(true);
                }
                if (this.m_lsfUser == null) break;
                this.m_lsfUser.setEnabled(true);
                break;
            }
        }
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        super.moveDataToView();
        Object currValue = this.m_balAlg.getDataValue();
        if (currValue.equals("tklbcost")) {
            this.setAlgorithmEnabled(1);
        } else if (currValue.equals("tklbresp")) {
            this.setAlgorithmEnabled(2);
        } else if (currValue.equals("tklblsf")) {
            this.setAlgorithmEnabled(3);
        } else if (currValue.equals("tklbmru") || currValue.equals("tklblru")) {
            this.setAlgorithmEnabled(4);
        }
    }

    @Override
    public boolean validateData() {
        if (this.m_balAlg.getDataValue().equals("tklblsf") && this.m_lsfInfo.getDataValue().toString().equalsIgnoreCase("None")) {
            String message;
            String title;
            if (this.m_gridLaunch != null && this.m_gridLaunch.getDataValue().toString().equalsIgnoreCase("True")) {
                title = IOMProperty.getDisplayString(0, "LoadBalancing.Grid.Error.NoServerLaunch.Title.xmlKey.txt");
                message = IOMProperty.getDisplayString(0, "LoadBalancing.Grid.Error.NoServerLaunch.Message.xmlKey.txt");
            } else {
                title = IOMProperty.getDisplayString(0, "LoadBalancing.Grid.Error.NoServerStd.Title.xmlKey.txt");
                message = IOMProperty.getDisplayString(0, "LoadBalancing.Grid.Error.NoServerStd.Message.xmlKey.txt");
            }
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), message, title, 0);
            return false;
        }
        return super.validateData();
    }
}

