/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListPropertyDialogImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IOMPortListCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    private PortListProperty m_connList;
    private AssociationProperty m_connProp;
    private Prototype m_connProto;
    private ServerComponent m_source;
    private String m_appProtocol;

    public IOMPortListCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    @Override
    public String createFinishString() {
        try {
            if (this.m_root instanceof TCPIPConnection) {
                IOMPortListCustomizer.setRootConnectionHostName(((TCPIPConnection)this.m_root).getApplicationProtocol(), this.m_source);
            }
            return super.createFinishString();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    @Override
    protected void initialize() {
        try {
            this.m_iomProps = new IOMPropertyList();
            if (!(this.m_root instanceof TCPIPConnection)) {
                return;
            }
            for (int i = 0; i < this.m_propList.size(); ++i) {
                AbstractProperty prop = (AbstractProperty)this.m_propList.get(i);
                if (!(prop instanceof AssociationProperty) || !((AssociationProperty)prop).getAssociationName().equals("SourceConnections") || !((AssociationProperty)prop).getMetadataType().equals("TCPIPConnection")) continue;
                this.m_connProp = (AssociationProperty)prop;
                break;
            }
            if (null == this.m_connProp) {
                return;
            }
            try {
                this.setName(this.m_connProp.getAssociatedPropertyGroup().getName());
                AssociationList protos = this.m_connProp.getAssociatedPrototypes();
                AssociationList usedProtos = this.m_root.getUsingPrototypes();
                for (int i = 0; i < protos.size(); ++i) {
                    Prototype proto = (Prototype)protos.get(i);
                    if (!proto.getMetadataType().equals("TCPIPConnection")) continue;
                    for (int j = 0; j < usedProtos.size(); ++j) {
                        if (((Prototype)usedProtos.get(j)).getName().equals(proto.getName())) continue;
                        this.m_connProto = proto;
                        break;
                    }
                    if (this.m_connProto == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (this.m_connProto == null) {
                return;
            }
            try {
                PropertyGroup propGroup = this.m_connProto.getPrimaryPropertyGroup();
                AssociationList props = propGroup.getGroupedProperties();
                for (int i = 0; i < props.size(); ++i) {
                    if (!(props.get(i) instanceof AttributeProperty) || !((AttributeProperty)props.get(i)).getPropertyName().equals("ApplicationProtocol")) continue;
                    this.m_appProtocol = ((AttributeProperty)props.get(i)).getDefaultValue();
                    break;
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            if (this.m_appProtocol == null) {
                return;
            }
            this.m_connList = new PortListProperty(null, (AbstractProperty)this.m_connProp, this.m_viewType);
            this.m_connList.setButtonText(0, IOMProperty.getDisplayString(0, "PortListDialog.AddButton.Name.xmlKey.txt"));
            this.m_connList.setButtonMnemonic(0, "PortListDialog.AddButton.Name.xmlKey.txt");
            this.m_connList.setButtonDialog(0, new PortListDialog());
            this.m_connList.setButtonText(3, IOMProperty.getDisplayString(0, "PortListDialog.ClearButton.Name.xmlKey.txt"));
            this.m_connList.setButtonMnemonic(3, "PortListDialog.ClearButton.Name.xmlKey.txt");
            this.m_connList.setUseButton(1, false);
            this.m_iomProps.add(this.m_connList);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        IOMPortListCustomizer.setRootConnectionHostName("MultiBridge", this.m_source);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        AssociationList sources = ((TCPIPConnection)this.m_root).getSources();
        if (sources.size() == 1) {
            this.m_source = (ServerComponent)sources.get(0);
        } else if (this.m_viewType == 0) {
            WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
            this.m_source = (ServerComponent)wizard.getWizardData("DeployedComponent");
        }
        if (this.m_source == null) {
            return;
        }
        this.m_connList.setOwningObject((CMetadata)this.m_source);
        this.m_connList.addPersistedPropertyEventListener(new PortListPersistedPropertyListener((DeployedComponent)this.m_source, this.m_connProto));
        this.removePPVFormatting();
        super.moveDataToView();
    }

    public static void setRootConnectionHostName(String rootProtocol, ServerComponent sc) {
        try {
            AssociationList trees = sc.getSoftwareTrees();
            Tree machines = null;
            for (int i = 0; i < trees.size(); ++i) {
                if (!((Tree)trees.get(i)).getTreeType().equals("MachineGroup")) continue;
                machines = (Tree)trees.get(i);
                break;
            }
            if (machines != null && machines.getMembers().size() > 0) {
                Machine rootMachine = (Machine)machines.getMembers().get(0);
                AssociationList conns = sc.getSourceConnections();
                TCPIPConnection conn = null;
                for (int k = 0; k < conns.size(); ++k) {
                    conn = (TCPIPConnection)conns.get(k);
                    String currHost = conn.getHostName();
                    if (currHost.equalsIgnoreCase(rootMachine.getName()) || !conn.getApplicationProtocol().equals(rootProtocol)) continue;
                    conn.setHostName(rootMachine.getName());
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public boolean validateData() {
        try {
            int i;
            List<String> currPorts = this.m_connList.getPortList();
            AssociationList conns = this.m_source.getSourceConnections();
            Vector<String> ports = new Vector<String>();
            String labelKey = "";
            if (this.m_appProtocol.equals("Bridge") || this.m_appProtocol.equals("MultiBridge")) {
                labelKey = "Connection.Property.Bridge.Port.Name.xmlKey.txt";
            } else if (this.m_appProtocol.equals("Operator") || this.m_appProtocol.equals("PortBank")) {
                labelKey = "Connection.Property.Port.Name.xmlKey.txt";
            }
            for (i = 0; i < conns.size(); ++i) {
                TCPIPConnection conn;
                if (!(conns.get(i) instanceof TCPIPConnection) || (conn = (TCPIPConnection)conns.get(i)).getApplicationProtocol().equals(this.m_appProtocol)) continue;
                if (conn.getApplicationProtocol().equals("Bridge") || conn.getApplicationProtocol().equals("Operator") || conn.getApplicationProtocol().equals("")) {
                    ports.add(this.getCurrentPortValue(labelKey));
                    continue;
                }
                ports.add(Integer.toString(conn.getPort()));
            }
            for (i = 0; i < currPorts.size(); ++i) {
                if (ports.contains(currPorts.get(i))) {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), IOMProperty.getDisplayString(0, "PortListDialog.Error.DuplicatePort.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.DuplicatePort.Title.xmlKey.txt"), 0);
                    return false;
                }
                ports.add(currPorts.get(i));
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        return super.validateData();
    }

    private String getCurrentPortValue(String labelKey) {
        int comp;
        Container gParent = this.getParent().getParent();
        Component[] comps = gParent.getComponents();
        if (labelKey.equals("")) {
            return "0";
        }
        String portLabel = IOMProperty.getFinishStringName(1, labelKey) + ":";
        boolean foundLabel = false;
        for (comp = 0; comp < gParent.getComponentCount() && !foundLabel; ++comp) {
            if (!(comps[comp] instanceof JLabel) || !((JLabel)comps[comp]).getText().equalsIgnoreCase(portLabel)) continue;
            foundLabel = true;
        }
        if (foundLabel && comps[comp] instanceof WATextField) {
            WATextField portField = (WATextField)comps[comp];
            return portField.getText();
        }
        return "0";
    }

    public class PortListPersistedPropertyListener
    implements IOMProperty.PersistedPropertyEventListener {
        private final Prototype m_proto;
        private String m_baseName;
        private final DeployedComponent m_comp;

        public PortListPersistedPropertyListener(DeployedComponent comp, Prototype connProto) {
            this(comp, "", connProto);
        }

        public PortListPersistedPropertyListener(DeployedComponent comp, String base, Prototype connProto) {
            this.m_comp = comp;
            this.m_baseName = base;
            this.m_proto = connProto;
        }

        private String createPortList() {
            StringBuffer portList = new StringBuffer();
            Vector<String> temp = new Vector<String>();
            try {
                AssociationList conns = this.m_comp.getSourceConnections(true);
                for (int i = 0; i < conns.size(); ++i) {
                    TCPIPConnection conn = (TCPIPConnection)conns.get(i);
                    if (!conn.getApplicationProtocol().equals(IOMPortListCustomizer.this.m_appProtocol)) continue;
                    temp.add(Integer.toString(conn.getPort()));
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            Collections.sort(temp);
            int port = 0;
            while (port < temp.size()) {
                String start;
                String curr = start = (String)temp.get(port);
                if (port < temp.size() - 1) {
                    String next = (String)temp.get(port + 1);
                    while (Integer.parseInt(next) == Integer.parseInt(curr) + 1) {
                        curr = next;
                        if (++port + 1 == temp.size()) break;
                        next = (String)temp.get(port + 1);
                    }
                }
                if (curr == start) {
                    portList.append(start);
                } else {
                    portList.append(start + "-" + curr);
                }
                if (++port >= temp.size()) continue;
                portList.append(",");
            }
            return portList.toString();
        }

        @Override
        public void deleteProperty(IOMProperty.PersistedPropertyEvent evt) {
            try {
                AssociationList conns = this.m_comp.getSourceConnections(true);
                for (int j = 0; j < conns.size(); ++j) {
                    TCPIPConnection tcpConn = (TCPIPConnection)conns.get(j);
                    if (!tcpConn.getApplicationProtocol().equals(IOMPortListCustomizer.this.m_appProtocol)) continue;
                    this.m_comp.getObjectStore().deleteObject((CMetadata)tcpConn);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        private AuthenticationDomain getComponentDomain() throws MdException, RemoteException {
            AssociationList conns = this.m_comp.getSourceConnections();
            for (int i = 0; i < conns.size(); ++i) {
                TCPIPConnection conn = (TCPIPConnection)conns.get(i);
                if (!conn.getApplicationProtocol().equals("Bridge")) continue;
                return conn.getDomain();
            }
            return null;
        }

        @Override
        public void readProperty(IOMProperty.PersistedPropertyEvent evt) {
            evt.getProperty().setPropertyValue(this.createPortList());
        }

        @Override
        public void writeProperty(IOMProperty.PersistedPropertyEvent evt) {
            PortListProperty prop = (PortListProperty)evt.getProperty();
            List<String> ports = prop.getPortList();
            Vector<String> oldPorts = new Vector<String>();
            try {
                TCPIPConnection tcpConn;
                AssociationList conns = this.m_comp.getSourceConnections(false);
                Vector<String> nouse = new Vector<String>();
                for (int j = 0; j < conns.size(); ++j) {
                    if (!(conns.get(j) instanceof TCPIPConnection)) continue;
                    tcpConn = (TCPIPConnection)conns.get(j);
                    if (tcpConn.getApplicationProtocol().equals(IOMPortListCustomizer.this.m_appProtocol)) {
                        oldPorts.add(String.valueOf(tcpConn.getPort()));
                        continue;
                    }
                    nouse.add(String.valueOf(tcpConn.getPort()));
                }
                int pIndex = oldPorts.size();
                for (int i = 0; i < ports.size(); ++i) {
                    if (oldPorts.contains(ports.get(i))) {
                        oldPorts.remove(ports.get(i));
                        continue;
                    }
                    if (this.m_baseName.equals("")) {
                        this.m_baseName = this.m_comp.getRepositoryID() + IOMPortListCustomizer.this.m_appProtocol;
                    }
                    String name = this.m_baseName + "_" + Integer.toString(pIndex++);
                    tcpConn = (TCPIPConnection)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_comp.getObjectStore(), null, name, "TCPIPConnection", this.m_comp.getRepositoryID(), null);
                    tcpConn.setApplicationProtocol(IOMPortListCustomizer.this.m_appProtocol);
                    tcpConn.setPort(ports.get(i));
                    tcpConn.setCommunicationProtocol("TCP");
                    tcpConn.setUsingPrototype((Root)this.m_proto);
                    tcpConn.setDomain(this.getComponentDomain());
                    this.m_comp.getSourceConnections().add((Object)tcpConn);
                }
                for (int k = 0; k < oldPorts.size(); ++k) {
                    String port = (String)oldPorts.get(k);
                    for (int l = 0; l < conns.size(); ++l) {
                        tcpConn = (TCPIPConnection)conns.get(l);
                        if (!String.valueOf(tcpConn.getPort()).equals(port) || !tcpConn.getApplicationProtocol().equalsIgnoreCase(IOMPortListCustomizer.this.m_appProtocol)) continue;
                        Workspace.getMdFactory().deleteMetadataObject((CMetadata)tcpConn);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public class PortListProperty
    extends ListProperty {
        public PortListProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
            super(object, metaProp, viewType);
        }

        @Override
        public void addPropertyToPanel(JPanel panel) {
            try {
                GridBagConstraints gbc;
                if (!this.m_visible) {
                    return;
                }
                if (this.m_viewType == 1) {
                    this.m_scrPane.setPreferredSize(new Dimension(240, 100));
                } else {
                    this.m_scrPane.setPreferredSize(new Dimension(180, 100));
                }
                int gridx = 0;
                int gridy = PortListProperty.getNextComponentHorizontalGridValue(panel);
                GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
                JPanel pnlButton = new JPanel();
                int btnsUsed = 0;
                for (int i = 0; i < this.m_numButtons; ++i) {
                    if (!this.m_useButton[i]) continue;
                    ++btnsUsed;
                }
                GridLayout gLayout = new GridLayout(1, 1, 10, 10);
                gLayout.setRows(btnsUsed == 4 ? 2 : btnsUsed);
                gLayout.setColumns(btnsUsed == 4 ? 2 : 1);
                pnlButton.setLayout(gLayout);
                for (int i = 0; i < this.m_numButtons; ++i) {
                    if (!this.m_useButton[i]) continue;
                    pnlButton.add(this.m_buttons[i]);
                }
                if (this.m_sep != null) {
                    gbc = new GridBagConstraints();
                    gbc.anchor = 17;
                    gbc.fill = 2;
                    gbc.gridy = gridy++;
                    gbc.gridx = gridx++;
                    gbc.gridwidth = 0;
                    gbc.insets = new Insets(12, 12, 12, 0);
                    gbLayout.setConstraints(this.m_sep, gbc);
                    panel.add(this.m_sep);
                } else if (this.m_useLabel) {
                    ((JLabel)this.m_label).setLabelFor(this.m_list);
                    PortListProperty.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                    gbc = new GridBagConstraints();
                    gbc.anchor = 17;
                    gbc.fill = 1;
                    gbc.gridx = gridx++;
                    gbc.gridy = gridy;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(12, 12, 0, 12);
                    gbLayout.setConstraints(this.m_label, gbc);
                    panel.add(this.m_label);
                }
                gbc = new GridBagConstraints();
                gbc.gridy = gridy;
                gbc.gridx = gridx;
                gbc.weightx = 1.0;
                gbc.anchor = 17;
                gbc.insets = new Insets(12, 12, 0, 12);
                gbLayout.setConstraints(this.m_scrPane, gbc);
                panel.add(this.m_scrPane);
                gbc = new GridBagConstraints();
                gbc.gridy = gridy;
                gbc.gridx = gridx += 3;
                gbc.insets = new Insets(0, 36, 0, 0);
                gbLayout.setConstraints(pnlButton, gbc);
                panel.add(pnlButton);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public List<String> getPortList() {
            Vector<String> ports = new Vector<String>();
            Vector<String> temp = new Vector<String>();
            String rest = (String)this.getDataValue();
            if (rest == null) {
                return ports;
            }
            int pos = rest.indexOf(44, 0);
            while (pos != -1) {
                temp.add(rest.substring(0, pos));
                rest = rest.substring(pos + 1, rest.length()).trim();
                pos = rest.indexOf(44, 0);
            }
            if (rest.trim().length() > 0) {
                temp.add(rest);
            }
            for (int i = 0; i < temp.size(); ++i) {
                rest = (String)temp.get(i);
                pos = rest.indexOf(45, 0);
                if (pos == -1) {
                    ports.add(rest);
                    continue;
                }
                int begin = Integer.parseInt(rest.substring(0, pos));
                int end = Integer.parseInt(rest.substring(pos + 1, rest.length()).trim());
                for (int j = begin; j <= end; ++j) {
                    ports.add(String.valueOf(j));
                }
            }
            Collections.sort(ports);
            return ports;
        }
    }

    public class PortListDialog
    extends ListPropertyDialogImpl
    implements ItemListener {
        private ButtonGroup m_btnGroup;
        private StringBuffer m_currValue;
        private JLabel m_lblBegin;
        private JLabel m_lblEnd;
        private JLabel m_lblSingle;
        private JRadioButton m_radRange;
        private JRadioButton m_radSingle;
        private List<String> m_rgPorts;
        private WATextField m_txtRangeBegin;
        private WATextField m_txtRangeEnd;
        private WATextField m_txtSingle;

        public PortListDialog() {
            this.initialize();
        }

        private void AddToList(int port) {
            this.m_rgPorts.add(Integer.toString(port));
        }

        private void AddToList(String port) {
            this.m_rgPorts.add(port);
        }

        private void EnableRange() {
            this.m_txtRangeEnd.setEnabled(true);
            this.m_txtRangeBegin.setEnabled(true);
            this.m_lblEnd.setEnabled(true);
            this.m_lblBegin.setEnabled(true);
            this.m_txtSingle.setEnabled(false);
            this.m_lblSingle.setEnabled(false);
        }

        private void EnableSingle() {
            this.m_txtRangeEnd.setEnabled(false);
            this.m_txtRangeBegin.setEnabled(false);
            this.m_lblEnd.setEnabled(false);
            this.m_lblBegin.setEnabled(false);
            this.m_txtSingle.setEnabled(true);
            this.m_lblSingle.setEnabled(true);
        }

        @Override
        public WAStandardDialog getDialog(Dialog owner, int button) {
            WAPanel panel = new WAPanel();
            GridBagLayout gbLayout = new GridBagLayout();
            panel.setLayout((LayoutManager)gbLayout);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 10, 5);
            gbLayout.setConstraints(this.m_radSingle, gbc);
            panel.add((Component)this.m_radSingle);
            gbc.gridx = 5;
            gbLayout.setConstraints(this.m_lblSingle, gbc);
            panel.add((Component)this.m_lblSingle);
            gbc.gridx = 6;
            gbLayout.setConstraints((Component)this.m_txtSingle, gbc);
            panel.add((Component)this.m_txtSingle);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 0, 0, 5);
            gbLayout.setConstraints(this.m_radRange, gbc);
            panel.add((Component)this.m_radRange);
            gbc.gridx = 2;
            gbLayout.setConstraints(this.m_lblBegin, gbc);
            panel.add((Component)this.m_lblBegin);
            gbc.gridx = 3;
            gbLayout.setConstraints((Component)this.m_txtRangeBegin, gbc);
            panel.add((Component)this.m_txtRangeBegin);
            gbc.gridx = 5;
            gbLayout.setConstraints(this.m_lblEnd, gbc);
            panel.add((Component)this.m_lblEnd);
            gbc.gridx = 6;
            gbLayout.setConstraints((Component)this.m_txtRangeEnd, gbc);
            panel.add((Component)this.m_txtRangeEnd);
            this.m_radSingle.setSelected(true);
            this.EnableSingle();
            this.m_dialog = new WAStandardDialog(owner, IOMProperty.getDisplayString(0, "PortListDialog.Title.xmlKey.txt"), true, panel){
                private static final long serialVersionUID = 1L;

                protected boolean onOK() {
                    PortListDialog.this.m_currValue = new StringBuffer();
                    if (PortListDialog.this.m_radSingle.isSelected()) {
                        if (PortListDialog.this.m_txtSingle.getText().trim().length() == 0) {
                            JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidNumber.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidNumber.Title.xmlKey.txt"), 0);
                            return false;
                        }
                        try {
                            int port = Integer.parseInt(PortListDialog.this.m_txtSingle.getText());
                            if (port < 0 || port > 65535) {
                                JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidNumber.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidNumber.Title.xmlKey.txt"), 0);
                                return false;
                            }
                            if (PortListDialog.this.Overlap(port)) {
                                JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.DuplicateValue.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.DuplicateValue.Title.xmlKey.txt"), 0);
                                return false;
                            }
                            PortListDialog.this.m_currValue.append(Integer.toString(port));
                        }
                        catch (NumberFormatException nex) {
                            JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidNumber.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidNumber.Title.xmlKey.txt"), 0);
                            return false;
                        }
                    }
                    if (PortListDialog.this.m_radRange.isSelected()) {
                        if (PortListDialog.this.m_txtRangeBegin.getText().trim().length() == 0 || PortListDialog.this.m_txtRangeEnd.getText().trim().length() == 0) {
                            JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidRange.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidRange.Title.xmlKey.txt"), 0);
                            return false;
                        }
                        try {
                            int begin = Integer.parseInt(PortListDialog.this.m_txtRangeBegin.getText());
                            int end = Integer.parseInt(PortListDialog.this.m_txtRangeEnd.getText());
                            if (begin < 0 || begin > 65535 || end < 0 || end > 65535 || begin > end) {
                                JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidRange.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidRange.Title.xmlKey.txt"), 0);
                                return false;
                            }
                            if (PortListDialog.this.Overlap(begin, end)) {
                                JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.DuplicateRange.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.DuplicateRange.Title.xmlKey.txt"), 0);
                                return false;
                            }
                            PortListDialog.this.m_currValue.append(Integer.toString(begin) + "-" + Integer.toString(end));
                        }
                        catch (NumberFormatException nex) {
                            JOptionPane.showMessageDialog(PortListDialog.this.m_dialog.getOwner(), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidRange.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "PortListDialog.Error.InvalidRange.Title.xmlKey.txt"), 0);
                            return false;
                        }
                    }
                    return super.onOK();
                }
            };
            this.m_dialog.setHelpProduct("templatedata");
            if (IOMPortListCustomizer.this.m_appProtocol.equalsIgnoreCase("PortBank")) {
                this.m_dialog.setHelpTopic("add_spawner_port");
            } else if (IOMPortListCustomizer.this.m_appProtocol.equalsIgnoreCase("MultiBridge")) {
                this.m_dialog.setHelpTopic("add_port");
            }
            return this.m_dialog;
        }

        @Override
        public Object getValue() {
            if (this.m_currValue != null) {
                return this.m_currValue.toString();
            }
            return null;
        }

        protected void initialize() {
            this.m_rgPorts = new ArrayList<String>();
            this.m_btnGroup = new ButtonGroup();
            this.m_radSingle = new JRadioButton(IOMProperty.getDisplayString(0, "PortListDialog.Selection.SinglePort.Name.xmlKey.txt"));
            IOMProperty.setMnemonic(this.m_radSingle, 0, "PortListDialog.Selection.SinglePort.Name.xmlKey.txt");
            this.m_radSingle.addItemListener(this);
            this.m_lblSingle = new JLabel(IOMProperty.getDisplayString(0, "PortListDialog.SinglePort.Name.xmlKey.txt"));
            this.m_txtSingle = new WATextField();
            this.m_lblSingle.setLabelFor((Component)this.m_txtSingle);
            IOMProperty.setMnemonic(this.m_lblSingle, 0, "PortListDialog.SinglePort.Name.xmlKey.txt");
            this.m_txtSingle.setPreferredSize(new Dimension(40, this.m_txtSingle.getMinimumSize().height));
            this.m_txtSingle.setToolTipText(IOMProperty.getDisplayString(0, "PortListDialog.SinglePort.Desc.xmlKey.txt"));
            this.m_radRange = new JRadioButton(IOMProperty.getDisplayString(0, "PortListDialog.Selection.PortRange.Name.xmlKey.txt"));
            IOMProperty.setMnemonic(this.m_radRange, 0, "PortListDialog.Selection.PortRange.Name.xmlKey.txt");
            this.m_radRange.addItemListener(this);
            this.m_lblBegin = new JLabel(IOMProperty.getDisplayString(0, "PortListDialog.PortRange.Begin.Name.xmlKey.txt"));
            this.m_txtRangeBegin = new WATextField();
            this.m_lblBegin.setLabelFor((Component)this.m_txtRangeBegin);
            IOMProperty.setMnemonic(this.m_lblBegin, 0, "PortListDialog.PortRange.Begin.Name.xmlKey.txt");
            this.m_txtRangeBegin.setPreferredSize(new Dimension(40, this.m_txtRangeBegin.getMinimumSize().height));
            this.m_txtRangeBegin.setToolTipText(IOMProperty.getDisplayString(0, "PortListDialog.PortRange.Begin.Desc.xmlKey.txt"));
            this.m_lblEnd = new JLabel(IOMProperty.getDisplayString(0, "PortListDialog.PortRange.End.Name.xmlKey.txt"));
            this.m_txtRangeEnd = new WATextField();
            this.m_lblEnd.setLabelFor((Component)this.m_txtRangeEnd);
            IOMProperty.setMnemonic(this.m_lblEnd, 0, "PortListDialog.PortRange.End.Name.xmlKey.txt");
            this.m_txtRangeEnd.setPreferredSize(new Dimension(40, this.m_txtRangeEnd.getMinimumSize().height));
            this.m_txtRangeEnd.setToolTipText(IOMProperty.getDisplayString(0, "PortListDialog.PortRange.End.Desc.xmlKey.txt"));
            this.m_btnGroup.add(this.m_radSingle);
            this.m_btnGroup.add(this.m_radRange);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.m_radSingle.isSelected()) {
                    this.EnableSingle();
                } else if (this.m_radRange.isSelected()) {
                    this.EnableRange();
                }
            }
        }

        private boolean Overlap(int port) {
            return this.m_rgPorts.contains(Integer.toString(port));
        }

        private boolean Overlap(int begin, int end) {
            for (int i = 0; i < this.m_rgPorts.size(); ++i) {
                String portInCurrRange = this.m_rgPorts.get(i);
                int intPortInCurrRange = Integer.parseInt(portInCurrRange);
                if (begin > intPortInCurrRange || intPortInCurrRange < end) continue;
                return true;
            }
            return false;
        }

        @Override
        public void Reset() {
            this.m_txtSingle.setText("");
            this.m_txtRangeBegin.setText("");
            this.m_txtRangeEnd.setText("");
            this.m_radSingle.setSelected(true);
            this.m_rgPorts.clear();
        }

        @Override
        public void setInitialValue(Object val) {
            String regex = "-";
            if (val == null) {
                return;
            }
            String value = (String)val;
            boolean nomore = false;
            while (!nomore) {
                String entry;
                int pos = value.indexOf(44, 0);
                if (pos == -1) {
                    nomore = true;
                    entry = value;
                } else {
                    entry = value.substring(0, pos);
                    value = value.substring(pos + 1, value.length()).trim();
                }
                String[] parts = entry.split(regex);
                if (parts.length == 2) {
                    int end = Integer.parseInt(parts[1]);
                    for (int begin = Integer.parseInt(parts[0]); begin <= end; ++begin) {
                        this.AddToList(begin);
                    }
                    continue;
                }
                if (parts.length != 1) continue;
                this.AddToList(entry);
            }
        }
    }
}

