/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.DefaultPropertyListener;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.ListPropertyDialog;
import com.sas.workspace.mgmt.visuals.customizers.iom.Puddle;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClientSidePoolingCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;

    public ClientSidePoolingCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    public static void clearClientSidePooling(LogicalServer lserver) {
        try {
            AssociationList trees = lserver.getSoftwareTrees();
            for (int i = 0; i < trees.size(); ++i) {
                Tree pooling = (Tree)trees.get(i);
                if (!pooling.getTreeType().equals("Pooling")) continue;
                AssociationList puddles = pooling.getMembers();
                for (int j = 0; j < puddles.size(); ++j) {
                    Puddle puddle = new Puddle(pooling, (Group)puddles.get(i), ClientSidePoolingCustomizer.findPoolingPrototype(lserver), 0);
                    puddle.delete();
                }
                lserver.getObjectStore().deleteObject((CMetadata)pooling);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Prototype findPoolingPrototype(LogicalServer lserver) throws Exception {
        int flags = 412;
        String strTemplate = "<XMLSelect search=\"*[@Name='Pooling.Puddle.Name.xmlKey.txt']\"/>";
        List protos = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(lserver.getObjectStore(), "A0000001." + lserver.getRepositoryID(), "Prototype", flags, strTemplate);
        if (protos != null) {
            return (Prototype)protos.get(0);
        }
        return null;
    }

    @Override
    protected void initialize() {
        this.m_iomProps = new IOMPropertyList();
        for (int i = 0; i < this.m_propList.size(); ++i) {
            try {
                IOMProperty iomProp;
                if (this.m_propList.get(i) instanceof AssociationProperty && ((AssociationProperty)this.m_propList.get(i)).getAssociationName().equalsIgnoreCase("Members") && this.m_root instanceof Tree) {
                    iomProp = new PuddleList((Tree)this.m_root, (AssociationProperty)this.m_propList.get(i), this.m_viewType);
                    iomProp.addPersistedPropertyEventListener(new DefaultPropertyListener());
                    if (this.m_viewType == 1) {
                        iomProp.addDivider();
                    }
                } else {
                    iomProp = new IOMProperty((CMetadata)this.m_root, (AbstractProperty)this.m_propList.get(i), this.m_viewType);
                }
                this.m_iomProps.add(iomProp);
                continue;
            }
            catch (IOMProperty.IllegalPropertyTypeException illegalPropertyTypeException) {
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        AssociationList comps = ((Tree)this.m_root).getSoftwareComponents();
        for (int i = 0; i < comps.size(); ++i) {
            if (!(comps.get(i) instanceof LogicalServer)) continue;
            ClientSidePoolingCustomizer.UpdateSecurityProperties((LogicalServer)comps.get(i));
        }
    }

    public static void UpdateSecurityProperties(LogicalServer logSrvr) {
        try {
            AssociationList props = logSrvr.getProperties();
            int j = 0;
            while (j < props.size()) {
                boolean didDelete = false;
                Property prop = (Property)props.get(j);
                if (prop.getPropertyName().equalsIgnoreCase("EnableSACS")) {
                    prop.setDefaultValue("False");
                }
                if (prop.getPropertyName().equalsIgnoreCase("AuthService")) {
                    prop.setDefaultValue("Host");
                } else if (prop.getPropertyName().equalsIgnoreCase("SecurityPackage") || prop.getPropertyName().equalsIgnoreCase("SPN") || prop.getPropertyName().equalsIgnoreCase("SecurityPackageList")) {
                    prop.delete();
                    didDelete = true;
                }
                if (didDelete) continue;
                ++j;
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public class PuddleList
    extends ListProperty {
        private final Tree m_pool;
        private Prototype m_pudProto;

        public PuddleList(Tree tree, AssociationProperty metaProp, int viewType) {
            super((CMetadata)tree, (AbstractProperty)metaProp, viewType);
            this.m_pool = tree;
            try {
                AssociationList protoList = metaProp.getAssociatedPrototypes();
                for (int i = 0; i < protoList.size(); ++i) {
                    Prototype prototype = (Prototype)protoList.get(i);
                    if (!prototype.getName().equals("Pooling.Puddle.Name.xmlKey.txt")) continue;
                    this.m_pudProto = prototype;
                    break;
                }
                AssociationList members = this.m_pool.getMembers();
                for (int i = 0; i < members.size(); ++i) {
                    Puddle puddle = new Puddle(this.m_pool, (Group)members.get(i), this.m_pudProto, viewType);
                    this.m_listMdl.addElement(puddle);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getActionCommand().equals("New")) {
                    Puddle propDialog = new Puddle(this.m_pool, this.m_pudProto, this.m_viewType);
                    propDialog.setInitialValue(this.m_listMdl);
                    Dialog owner = (Dialog)this.m_buttons[0].getTopLevelAncestor();
                    WAStandardDialog dialog = propDialog.getDialog(owner, 0);
                    dialog.show();
                    if (dialog.getReturnValue() == 1) {
                        this.m_listMdl.addElement(propDialog);
                    }
                } else if (e.getActionCommand().equals("Edit")) {
                    ListPropertyDialog propDialog = (ListPropertyDialog)this.m_listMdl.get(this.m_list.getSelectedIndex());
                    propDialog.setInitialValue(this.m_listMdl);
                    Dialog owner = (Dialog)this.m_buttons[0].getTopLevelAncestor();
                    WAStandardDialog dialog = propDialog.getDialog(owner, 1);
                    dialog.show();
                } else if (e.getActionCommand().equals("Remove")) {
                    int[] indices = this.m_list.getSelectedIndices();
                    for (int i = 0; i < indices.length; ++i) {
                        ((Puddle)this.m_listMdl.get(indices[i])).delete();
                        this.m_listMdl.remove(indices[i]);
                    }
                } else if (e.getActionCommand().equals("Clear")) {
                    for (int i = 0; i < this.m_listMdl.size(); ++i) {
                        ((Puddle)this.m_listMdl.get(i)).delete();
                    }
                    this.m_listMdl.removeAllElements();
                }
            }
            catch (Exception ex) {
                return;
            }
        }

        @Override
        public void addPropertyToPanel(JPanel panel) {
            GridBagConstraints gbc;
            if (!this.m_visible) {
                return;
            }
            if (this.m_viewType == 1) {
                this.m_scrPane.setPreferredSize(new Dimension(360, 100));
            } else {
                this.m_scrPane.setPreferredSize(new Dimension(160, 100));
            }
            int gridx = 0;
            int gridy = PuddleList.getNextComponentHorizontalGridValue(panel);
            GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
            JPanel pnlButton = new JPanel();
            int btnsUsed = 0;
            for (int i = 0; i < this.m_numButtons; ++i) {
                if (!this.m_useButton[i]) continue;
                ++btnsUsed;
            }
            GridLayout gLayout = new GridLayout(1, 1, 10, 10);
            gLayout.setRows(btnsUsed == 4 ? 2 : btnsUsed);
            gLayout.setColumns(btnsUsed == 4 ? 2 : 1);
            pnlButton.setLayout(gLayout);
            for (int i = 0; i < this.m_numButtons; ++i) {
                if (!this.m_useButton[i]) continue;
                pnlButton.add(this.m_buttons[i]);
            }
            if (this.m_sep != null) {
                gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.gridy = gridy++;
                gbc.gridx = gridx++;
                gbc.gridwidth = 0;
                gbc.insets = new Insets(12, 12, 12, 0);
                gbLayout.setConstraints(this.m_sep, gbc);
                panel.add(this.m_sep);
            } else if (this.m_useLabel) {
                try {
                    ((JLabel)this.m_label).setLabelFor(this.m_list);
                    PuddleList.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                    gbc = new GridBagConstraints();
                    gbc.anchor = 17;
                    gbc.fill = 2;
                    gbc.gridx = gridx;
                    gbc.gridy = gridy++;
                    gbc.insets = new Insets(0, 0, 12, 12);
                    gbLayout.setConstraints(this.m_label, gbc);
                    panel.add(this.m_label);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
            gbc = new GridBagConstraints();
            gbc.gridy = gridy;
            gbc.gridx = gridx;
            gbc.weightx = 1.0;
            if (this.m_viewType != 1) {
                gbc.insets = new Insets(0, 0, 0, 12);
            }
            gbLayout.setConstraints(this.m_scrPane, gbc);
            panel.add(this.m_scrPane);
            gbc = new GridBagConstraints();
            gbc.gridy = gridy;
            gbc.gridx = gridx += 3;
            gbLayout.setConstraints(pnlButton, gbc);
            panel.add(pnlButton);
        }

        @Override
        public Property createNewProperty() {
            return null;
        }

        @Override
        public Object getDataValue() {
            Group[] puddles = new Group[this.m_listMdl.size()];
            for (int i = 0; i < this.m_listMdl.size(); ++i) {
                puddles[i] = ((Puddle)this.m_listMdl.get(i)).getGroup();
            }
            return puddles;
        }

        public List getPuddles() {
            Vector<Puddle> puddles = new Vector<Puddle>();
            for (int i = 0; i < this.m_listMdl.size(); ++i) {
                puddles.add((Puddle)this.m_listMdl.get(i));
            }
            return puddles;
        }
    }
}

