/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.dbms;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DirectSQLPanel
extends WsDescriptionWizardTab {
    private SASLibrary m_library;
    private String m_strReposID;
    private List<Property> m_lstProperties;
    private JRadioButton m_rdoProcessing;
    private WAComboBox m_cbxProcessing;
    private JRadioButton m_rdoExceptions;
    private DualListSelector m_lstExceptions;
    protected static final WAdminResource bundle = new WAdminResource(DirectSQLPanel.class);
    protected static final WAdminResource templBundle = new WAdminResource("com.sas.workspace.visuals.res.PropertyBundle");
    private static final long serialVersionUID = 1L;

    public DirectSQLPanel(SASLibrary library, String reposID, List<Property> propertyList) {
        this.m_library = library;
        this.m_strReposID = reposID;
        this.m_lstProperties = propertyList;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        int index;
        Property property;
        Property propPrototype = null;
        String strSelectedValues = new String();
        if (this.m_rdoProcessing.isSelected()) {
            for (int index2 = 0; index2 < this.m_lstProperties.size(); ++index2) {
                property = this.m_lstProperties.get(index2);
                if (!property.getPropertyName().equalsIgnoreCase("DIRECT_SQL") || !property.getDefaultValue().equalsIgnoreCase("YES")) continue;
                propPrototype = property;
                break;
            }
            if ((strSelectedValues = (String)this.m_cbxProcessing.getSelectedItem()).equalsIgnoreCase("YES")) {
                AssociationList lstProperties = this.m_library.getProperties();
                for (int index3 = 0; index3 < lstProperties.size(); ++index3) {
                    Property property2 = (Property)lstProperties.get(index3);
                    if (!property2.getPropertyName().equalsIgnoreCase("DIRECT_SQL")) continue;
                    this.m_library.getProperties().remove((Object)property2);
                    PrototypeUtil.deleteProperty(property2);
                    break;
                }
                return;
            }
        } else if (this.m_rdoExceptions.isSelected()) {
            for (int index4 = 0; index4 < this.m_lstProperties.size(); ++index4) {
                property = this.m_lstProperties.get(index4);
                if (!property.getPropertyName().equalsIgnoreCase("DIRECT_SQL") || !property.getDefaultValue().equalsIgnoreCase("")) continue;
                propPrototype = property;
                break;
            }
            ArrayList<String> lstTargetData = new ArrayList<String>();
            ListModel mdlTarget = this.m_lstExceptions.getTargetModel();
            for (index = 0; index < mdlTarget.getSize(); ++index) {
                lstTargetData.add((String)mdlTarget.getElementAt(index));
            }
            for (index = 0; index < lstTargetData.size(); ++index) {
                String strValue = (String)lstTargetData.get(index);
                if (lstTargetData.size() > 1 && !strSelectedValues.startsWith("(")) {
                    strSelectedValues = strSelectedValues + "(";
                }
                strSelectedValues = strSelectedValues + strValue;
                if (index < lstTargetData.size() - 1) {
                    strSelectedValues = strSelectedValues + ", ";
                }
                if (index <= 0 || index != lstTargetData.size() - 1) continue;
                strSelectedValues = strSelectedValues + ")";
            }
        }
        boolean bPropertyFound = false;
        AssociationList lstProperties = this.m_library.getProperties();
        for (index = 0; index < lstProperties.size(); ++index) {
            Property property3 = (Property)lstProperties.get(index);
            if (!property3.getPropertyName().equalsIgnoreCase("DIRECT_SQL")) continue;
            if (!strSelectedValues.equalsIgnoreCase(property3.getDefaultValue())) {
                property3.setDefaultValue(strSelectedValues);
            }
            bPropertyFound = true;
            break;
        }
        if (!bPropertyFound) {
            Property property4 = PrototypeUtil.createProperty(propPrototype, (MdObjectStore)this.m_library.getObjectStore(), this.m_strReposID);
            property4.setDefaultValue(strSelectedValues);
            this.m_library.getProperties().add((Object)property4);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        AssociationList lstProperties = this.m_library.getProperties();
        for (int index = 0; index < lstProperties.size(); ++index) {
            Property property = (Property)lstProperties.get(index);
            if (!property.getPropertyName().equalsIgnoreCase("DIRECT_SQL")) continue;
            String strValue = property.getDefaultValue();
            if (strValue.equalsIgnoreCase("YES") || strValue.equalsIgnoreCase("NO") || strValue.equalsIgnoreCase("NONE")) {
                this.m_rdoProcessing.setSelected(true);
                this.m_cbxProcessing.setSelectedItem((Object)strValue);
                break;
            }
            this.m_rdoExceptions.setSelected(true);
            ArrayList<String> lstSourceData = new ArrayList<String>();
            DefaultListModel mdlSource = this.m_lstExceptions.getModel();
            for (int sIndex = 0; sIndex < mdlSource.getSize(); ++sIndex) {
                lstSourceData.add((String)mdlSource.getElementAt(sIndex));
            }
            ArrayList<String> lstTargetData = new ArrayList<String>();
            DefaultListModel mdlTarget = this.m_lstExceptions.getTargetModel();
            if (strValue.contains("NOFUNCTIONS")) {
                lstSourceData.remove("NOFUNCTIONS");
                lstTargetData.add("NOFUNCTIONS");
            }
            if (strValue.contains("NOMULTOUTJOINS")) {
                lstSourceData.remove("NOMULTOUTJOINS");
                lstTargetData.add("NOMULTOUTJOINS");
            }
            if (strValue.contains("NOGENSQL")) {
                lstSourceData.remove("NOGENSQL");
                lstTargetData.add("NOGENSQL");
            }
            if (strValue.contains("NOWHERE")) {
                lstSourceData.remove("NOWHERE");
                lstTargetData.add("NOWHERE");
            }
            mdlSource = new DefaultListModel();
            for (int sIndex = 0; sIndex < lstSourceData.size(); ++sIndex) {
                mdlSource.add(sIndex, lstSourceData.get(sIndex));
            }
            mdlTarget = new DefaultListModel();
            for (int tIndex = 0; tIndex < lstTargetData.size(); ++tIndex) {
                mdlTarget.add(tIndex, lstTargetData.get(tIndex));
            }
            this.m_lstExceptions.setModel(mdlSource);
            this.m_lstExceptions.setTargetModel(mdlTarget);
            break;
        }
        this.enableComponent(this.m_rdoProcessing, (JComponent)this.m_cbxProcessing);
        this.enableComponent(this.m_rdoExceptions, (JComponent)this.m_lstExceptions);
    }

    public boolean validateData() {
        ListModel mdlTarget;
        if (this.m_rdoExceptions.isSelected() && (mdlTarget = this.m_lstExceptions.getTargetModel()).getSize() == 0) {
            String strMessage = bundle.getString("DirectSQLPanel.Required.ExceptionsDBMSProcessing.txt");
            String strTitle = bundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            return false;
        }
        return true;
    }

    public String createFinishString() {
        String strFinish = "";
        try {
            AssociationList lstProperties = this.m_library.getProperties();
            for (int index = 0; index < lstProperties.size(); ++index) {
                Property property = (Property)lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase("DIRECT_SQL")) continue;
                Property propProperty = null;
                String strValue = property.getDefaultValue();
                for (int pIndex = 0; pIndex < this.m_lstProperties.size(); ++pIndex) {
                    Property prop = this.m_lstProperties.get(pIndex);
                    if (prop.getPropertyName().equalsIgnoreCase("DIRECT_SQL") && prop.getDefaultValue().equalsIgnoreCase("YES")) {
                        if (!strValue.equalsIgnoreCase("YES") && !strValue.equalsIgnoreCase("NO") && !strValue.equalsIgnoreCase("NONE")) continue;
                        if (strValue.equalsIgnoreCase("YES")) {
                            return strFinish;
                        }
                        propProperty = prop;
                        break;
                    }
                    if (!prop.getPropertyName().equalsIgnoreCase("DIRECT_SQL") || !prop.getDefaultValue().equalsIgnoreCase("") || !strValue.contains("NOFUNCTIONS") && !strValue.contains("NOMULTOUTJOINS") && !strValue.contains("NOGENSQL") && !strValue.contains("NOWHERE")) continue;
                    propProperty = prop;
                    break;
                }
                strFinish = templBundle.getString(propProperty.getName()) + "\n\t" + this.getRendererText(strValue) + "\n";
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return strFinish;
    }

    protected void initialize() {
        this.m_rdoProcessing = new JRadioButton(bundle.getString("DirectSQLPanel.Label.DBMSProcessing.txt"));
        this.m_rdoProcessing.setSelected(true);
        this.m_cbxProcessing = new WAComboBox();
        this.m_cbxProcessing.setRenderer((ListCellRenderer)new ValuesCellRenderer());
        this.m_cbxProcessing.addItem((Object)"YES");
        this.m_cbxProcessing.addItem((Object)"NO");
        this.m_cbxProcessing.addItem((Object)"NONE");
        this.m_cbxProcessing.setToolTipText(bundle.getString("DirectSQLPanel.Label.DBMSProcessing.Desc.txt"));
        this.m_rdoProcessing.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DirectSQLPanel.this.enableComponent(DirectSQLPanel.this.m_rdoProcessing, (JComponent)DirectSQLPanel.this.m_cbxProcessing);
            }
        });
        this.m_rdoExceptions = new JRadioButton(bundle.getString("DirectSQLPanel.Label.ExceptionsDBMSProcessing.txt"));
        this.m_lstExceptions = new DualListSelector();
        this.m_lstExceptions.setSourceLabel(bundle.getString("DirectSQLPanel.Label.AvailableItems.txt"));
        this.m_lstExceptions.setTargetLabel(bundle.getString("DirectSQLPanel.Label.SelectedItems.txt"));
        this.m_lstExceptions.setToolTipText(bundle.getString("DirectSQLPanel.Label.ExceptionsDBMSProcessing.Desc.txt"));
        this.m_lstExceptions.setSourceCellRenderer((ListCellRenderer)new ValuesCellRenderer());
        this.m_lstExceptions.setTargetCellRenderer((ListCellRenderer)new ValuesCellRenderer());
        this.m_lstExceptions.setPreferredSize(new Dimension(250, 90));
        this.m_lstExceptions.setMinimumSize(new Dimension(75, 75));
        ArrayList<String> lstSourceData = new ArrayList<String>();
        lstSourceData.add("NOFUNCTIONS");
        lstSourceData.add("NOMULTOUTJOINS");
        lstSourceData.add("NOGENSQL");
        lstSourceData.add("NOWHERE");
        DefaultListModel mdlSource = new DefaultListModel();
        for (int index = 0; index < lstSourceData.size(); ++index) {
            mdlSource.add(index, lstSourceData.get(index));
        }
        this.m_lstExceptions.setModel(mdlSource);
        this.m_rdoExceptions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DirectSQLPanel.this.enableComponent(DirectSQLPanel.this.m_rdoExceptions, (JComponent)DirectSQLPanel.this.m_lstExceptions);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdoProcessing);
        buttonGroup.add(this.m_rdoExceptions);
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_rdoProcessing, gbc);
        this.add(this.m_rdoProcessing);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_cbxProcessing, gbc);
        this.add((Component)this.m_cbxProcessing);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_rdoExceptions, gbc);
        this.add(this.m_rdoExceptions);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_lstExceptions, gbc);
        this.add((Component)this.m_lstExceptions);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private void enableComponent(JToggleButton source, JComponent target) {
        target.setEnabled(source.isSelected());
    }

    private String getRendererText(String value) {
        if (value instanceof String && value.toString().equalsIgnoreCase("YES")) {
            return templBundle.getString("Library.DBMS.Value.Yes.xmlKey.txt");
        }
        if (value instanceof String && value.toString().equalsIgnoreCase("NO")) {
            return templBundle.getString("Library.DBMS.Value.No.xmlKey.txt");
        }
        if (value instanceof String && value.toString().equalsIgnoreCase("NONE")) {
            return templBundle.getString("Library.DBMS.Value.None.xmlKey.txt");
        }
        if (value instanceof String && value.toString().equalsIgnoreCase("NOFUNCTIONS")) {
            return templBundle.getString("Library.DBMS.DirSqlSpType.NoFunctions.xmlKey.txt");
        }
        if (value instanceof String && value.toString().equalsIgnoreCase("NOMULTOUTJOINS")) {
            return templBundle.getString("Library.DBMS.DirSqlSpType.NoMultJoin.xmlKey.txt");
        }
        if (value instanceof String && value.toString().equalsIgnoreCase("NOGENSQL")) {
            return templBundle.getString("Library.DBMS.DirSqlSpType.NoGenSql.xmlKey.txt");
        }
        if (value instanceof String && value.toString().equalsIgnoreCase("NOWHERE")) {
            return templBundle.getString("Library.DBMS.DirSqlSpType.NoWhere.xmlKey.txt");
        }
        return value;
    }

    private class ValuesCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ValuesCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                this.setText(DirectSQLPanel.this.getRendererText((String)value));
            }
            return comp;
        }
    }
}

