/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransformPropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Transformation m_transformation;
    protected Prototype m_transformationPrototype;
    protected int m_type;
    protected JPanel m_view;
    protected static final WAdminResource bundle = new WAdminResource(TransformPropertyView.class);

    public TransformPropertyView(Server server, int type) {
        super(bundle.getString("TransformPropertyView.WizardTitle.txt"));
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets(false);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_type == 1 && this.m_view instanceof PropertiesPropertyView) {
                this._setViewProperties();
            }
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                this.m_transformation = (Transformation)parent.getWizardData("Transformation");
                this.m_transformationPrototype = (Prototype)parent.getWizardData("TransformationPrototype");
            }
            if (this.m_type == 1) {
                try {
                    AssociationList initProcessesList = this.m_server.getDeployedComponent().getInitProcesses();
                    for (int ipIndex = 0; ipIndex < initProcessesList.size(); ++ipIndex) {
                        Transformation transform = (Transformation)initProcessesList.get(ipIndex);
                        if (!transform.getTransformRole().equals("Load Balancing") && !transform.getTransformRole().equals("Initialization")) continue;
                        this.m_transformation = transform;
                    }
                    this.m_transformationPrototype = this.m_server.getTransformationPrototype(this.m_transformation, this.getTopLevelAncestor());
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            this.removeAll();
            this._layoutWidgets(true);
            this.revalidate();
            if (this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).doDataExchange(false);
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
        }
        return false;
    }

    public boolean validateData() {
        if (this.m_view instanceof PropertiesPropertyView) {
            return ((PropertiesPropertyView)((Object)this.m_view)).validateData();
        }
        return true;
    }

    protected void _setViewProperties() {
        try {
            ((PropertiesPropertyView)((Object)this.m_view)).setViewProperties();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).onNext();
        }
        try {
            this.m_server.getDeployedComponent().getInitProcesses().add((Object)this.m_transformation);
            this.m_transformation.setUsingPrototype((Root)((Prototype)parent.getWizardData("TransformationPrototype")));
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        this.setConditionState("NEXT");
        parent.replaceWizardData("Transformation", (Object)this.m_transformation);
    }

    public void onBack() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).onBack();
        }
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_view instanceof PropertiesPropertyView) {
            strFinish = strFinish + ((PropertiesPropertyView)((Object)this.m_view)).createFinishString();
        }
        return strFinish;
    }

    public Component getDefaultFocusComponent() {
        Component comp = null;
        if (this.m_view instanceof PropertiesPropertyView) {
            comp = ((PropertiesPropertyView)((Object)this.m_view)).getDefaultFocusComponent();
        }
        return comp;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).saveSettingsAndCleanUp();
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("ServerPropertyView.TabName.txt"));
    }

    protected void _layoutWidgets(boolean bShowErrorMessage) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        PropertyGroup group = null;
        try {
            if (this.m_transformationPrototype != null) {
                group = this.m_transformationPrototype.getPrimaryPropertyGroup();
            }
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        if (group != null) {
            Hashtable propertiesTable = null;
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                propertiesTable = (Hashtable)parent.getWizardData("Properties");
            }
            this.m_view = new PropertiesPropertyView((Root)this.m_transformation, group, this.m_type, propertiesTable, this.m_transformationPrototype);
            try {
                AssociationList extensionList = group.getExtensions();
                for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                    Extension extension = (Extension)extensionList.get(extIndex);
                    if (extension.getName().equalsIgnoreCase("HelpSet")) {
                        String strHelpSet = extension.getValue();
                        this.setHelpProduct(strHelpSet);
                    }
                    if (!extension.getName().equalsIgnoreCase("HelpTopicSimple")) continue;
                    String strHelpTopic = extension.getValue();
                    this.setHelpTopic(strHelpTopic);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            ((PropertiesPropertyView)((Object)this.m_view)).setMinimumViewHeight(250);
        } else {
            this.m_view = new JPanel();
            this.m_view.setPreferredSize(new Dimension(475, 300));
            if (bShowErrorMessage) {
                this.m_view.add(new JLabel(bundle.getString("Common.UnableToShowProperties.txt")));
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 0, 0, 12);
        gridBagLayout.setConstraints(this.m_view, gbc);
        this.add(this.m_view);
    }
}

