/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.Connection;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.visuals.ConnectionFailedException;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerConnectionInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TestConnectionView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected WATextArea m_titleText;
    protected JButton m_testButton;
    protected WATextArea m_messageText;
    protected JScrollPane m_messagePane;
    private static final WAdminResource bundle = WAdminResource.getBundle(TestConnectionView.class);

    public TestConnectionView(Server server) {
        this.m_server = server;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            // empty if block
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public void onNext() {
    }

    public void onBack() {
    }

    public void onTestConnection() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        List connectionsList = (List)parent.getWizardData("SourceConnections");
        Connection connection = (Connection)connectionsList.get(connectionsList.size() - 1);
        boolean bSuccess = false;
        String strFailMessage = bundle.getString("Common.Connection.UnableToTest.txt");
        ServerConnectionInterface serverConnection = this.m_server.getServerConnection(connection);
        if (serverConnection != null) {
            serverConnection.setParentComponent((Component)parent);
            try {
                bSuccess = serverConnection.testConnection(connection);
            }
            catch (ConnectionFailedException exc) {
                strFailMessage = exc.getMessage();
            }
        }
        if (bSuccess) {
            this.m_messageText.setText(bundle.getString("Common.Connection.TestSuccess.txt"));
        } else {
            this.m_messageText.setText(strFailMessage);
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("TestConnectionView.TabName.txt"));
        this.m_titleText = new WATextArea(bundle.getString("TestConnectionView.WizardTitle.txt"));
        this.m_titleText.setEditable(false);
        this.m_titleText.setLineWrap(true);
        this.m_titleText.setWrapStyleWord(true);
        this.m_titleText.setBorder(null);
        this.m_titleText.setBackground(this.getBackground());
        this.m_testButton = new JButton(bundle.getString("TestConnectionView.Test.txt"));
        this.m_testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TestConnectionView.this.onTestConnection();
            }
        });
        this.m_messageText = new WATextArea();
        this.m_messageText.setEditable(false);
        this.m_messageText.setLineWrap(true);
        this.m_messageText.setWrapStyleWord(true);
        this.m_messageText.setBackground(this.getBackground());
        this.m_messagePane = new JScrollPane((Component)this.m_messageText);
        this.m_messagePane.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_titleText, gbc);
        this.add((Component)this.m_titleText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_testButton, gbc);
        this.add(this.m_testButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_messagePane, gbc);
        this.add(this.m_messagePane);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

