/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.impl.repository.ResourceTemplateHelper;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.visuals.PrototypeSelector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrototypeTypicalView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected JTree m_tree;
    protected JScrollPane m_treePane;
    protected JButton m_selectAllButton;
    protected String m_strContext;
    protected Vector m_dataList;
    protected List m_filesList;
    protected List m_metadataTypeList;
    protected List m_uniqueIDList;
    protected boolean m_bListsLoaded = false;
    protected PrototypeSelector m_selector;
    protected static final WAdminResource bundle = new WAdminResource(PrototypeTypicalView.class);

    public PrototypeTypicalView(String strContext) {
        super(bundle.getString("PrototypeTypicalView.WizardTitle.txt"));
        this.m_strContext = strContext;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                URL url = ResourceTemplateHelper.getURLfromPrototypeIndexFile();
                this._loadLists(url);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        return false;
    }

    public boolean validateData() {
        boolean bValid = false;
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        TreePath[] pathArray = this.m_tree.getSelectionPaths();
        for (int i = 0; pathArray != null && i < pathArray.length; ++i) {
            TreePath path = pathArray[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!node.isLeaf()) continue;
            bValid = true;
            break;
        }
        if (!bValid) {
            JOptionPane.showMessageDialog((Component)parent, bundle.getString("PrototypeTypicalView.NoneSelected.txt"), bundle.getString("Common.Information.txt"), 1);
        }
        return bValid;
    }

    protected void _loadLists(URL url) {
        if (this.m_bListsLoaded) {
            return;
        }
        Document doc = null;
        try {
            doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            return;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        if (doc != null) {
            this._buildData(doc);
        }
        this.m_tree.expandRow(0);
        this.m_bListsLoaded = true;
    }

    protected void _buildData(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildData(children.item(childIndex));
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Prototype")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strPrototypeName = PrototypeUtil.getDisplayString(childNodeMap.getNamedItem("Name").getNodeValue());
                    String strFileName = childNodeMap.getNamedItem("FileName").getNodeValue();
                    if (strFileName.indexOf("_gx.xml") == -1) break;
                    this.m_dataList.add(strPrototypeName);
                    this.m_filesList.add(strFileName);
                    String strMetadataType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    this.m_metadataTypeList.add(strMetadataType);
                    Node classIDNode = childNodeMap.getNamedItem("ClassIdentifier");
                    Node engineIDNode = childNodeMap.getNamedItem("Engine");
                    Node serverClassIDNode = childNodeMap.getNamedItem("ServerClassIdentifier");
                    String strUniqueID = "";
                    if (classIDNode != null && classIDNode.getNodeValue().length() > 0) {
                        strUniqueID = classIDNode.getNodeValue();
                    }
                    if (engineIDNode != null) {
                        if (engineIDNode.getNodeValue().length() > 0) {
                            strUniqueID = engineIDNode.getNodeValue();
                        }
                        if (strUniqueID.equals("DB2")) {
                            strUniqueID = serverClassIDNode.getNodeValue();
                        }
                    }
                    if (serverClassIDNode != null && serverClassIDNode.getNodeValue().length() > 0) {
                        strUniqueID = serverClassIDNode.getNodeValue();
                    }
                    this.m_uniqueIDList.add(strUniqueID);
                    String strType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    String strCategory = "";
                    if (strType.equals("ServerComponent") || strType.equals("LogicalServer") || strType.equals("ServerContext")) {
                        strCategory = bundle.getString("PrototypeSelector.Category.Servers.txt");
                    }
                    if (strType.equals("SASLibrary")) {
                        strCategory = bundle.getString("PrototypeSelector.Category.Libraries.txt");
                    }
                    if (strType.equals("DatabaseSchema")) {
                        strCategory = bundle.getString("PrototypeSelector.Category.Schemas.txt");
                    }
                    String strSubCategory = PrototypeUtil.getDisplayString(childNodeMap.getNamedItem("UITreeCategory").getNodeValue());
                    String strName = strCategory + "." + strSubCategory + "." + strPrototypeName;
                    String strDesc = PrototypeUtil.getDisplayString(childNodeMap.getNamedItem("Desc").getNodeValue());
                    this.m_selector.buildTree(strName, strDesc);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildData(children.item(childIndex));
                }
                break;
            }
        }
    }

    public void onSelectAll() {
        int i;
        int rowCount = 0;
        while (rowCount != this.m_tree.getRowCount()) {
            for (i = 0; i < this.m_tree.getRowCount(); ++i) {
                this.m_tree.expandRow(i);
            }
            rowCount = this.m_tree.getRowCount();
        }
        for (i = 0; i < this.m_tree.getRowCount(); ++i) {
            this.m_tree.addSelectionRow(i);
            if (!this.m_tree.isExpanded(i)) continue;
            this.m_tree.removeSelectionRow(i);
        }
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        Vector<String> xmlToAddList = new Vector<String>();
        Vector xmlDataNameList = new Vector();
        Vector xmlFileNameList = new Vector();
        Vector metadataTypeList = new Vector();
        Vector uniqueIDList = new Vector();
        TreePath[] pathArray = this.m_tree.getSelectionPaths();
        for (int i = 0; pathArray != null && i < pathArray.length; ++i) {
            String strPrototypeFile;
            TreePath path = pathArray[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!node.isLeaf()) continue;
            int index = -1;
            for (int j = 0; j < this.m_dataList.size(); ++j) {
                String strPrototypeName = (String)this.m_dataList.get(j);
                if (!strPrototypeName.equals(node.toString())) continue;
                index = j;
                break;
            }
            if (index == -1 || !this.m_filesList.contains(strPrototypeFile = (String)this.m_filesList.get(index))) continue;
            xmlDataNameList.add(this.m_dataList.get(index));
            xmlFileNameList.add(this.m_filesList.get(index));
            metadataTypeList.add(this.m_metadataTypeList.get(index));
            uniqueIDList.add(this.m_uniqueIDList.get(index));
            try {
                URL url = XMLUtility.urlFromFile((String)strPrototypeFile);
                Document doc = null;
                try {
                    doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    return;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
                String strContents = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
                int reposIndex = strContents.lastIndexOf("_ReposID_");
                String strXML = strContents.substring(0, reposIndex) + this.m_strContext + strContents.substring(reposIndex + 9);
                xmlToAddList.add(strXML);
                continue;
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        parent.addWizardData("XMLList", xmlToAddList);
        parent.addWizardData("XMLNameList", xmlDataNameList);
        parent.addWizardData("XMLFileNameList", xmlFileNameList);
        parent.addWizardData("MetadataTypeList", metadataTypeList);
        parent.addWizardData("UniqueIDList", uniqueIDList);
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.removeWizardData("XMLList");
        parent.removeWizardData("XMLNameList");
        parent.removeWizardData("XMLFileNameList");
        parent.removeWizardData("MetadataTypeList");
        parent.removeWizardData("UniqueIDList");
    }

    public String createFinishString() {
        String strFinish = bundle.getString("PrototypeFinishView.ResourceTemplateTitle.txt") + "\n";
        TreePath[] pathArray = this.m_tree.getSelectionPaths();
        for (int i = 0; pathArray != null && i < pathArray.length; ++i) {
            String strPrototypeFile;
            TreePath path = pathArray[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!node.isLeaf()) continue;
            int index = -1;
            for (int j = 0; j < this.m_dataList.size(); ++j) {
                String strPrototypeName = (String)this.m_dataList.get(j);
                if (!strPrototypeName.equals(node.toString())) continue;
                index = j;
                break;
            }
            if (index == -1 || !this.m_filesList.contains(strPrototypeFile = (String)this.m_filesList.get(index))) continue;
            strFinish = strFinish + "\t" + (String)this.m_dataList.get(index) + "\n";
        }
        return strFinish;
    }

    protected void _initialize() {
        this.setName(bundle.getString("PrototypeTypicalView.TabName.txt"));
        this.m_filesList = new Vector();
        this.m_dataList = new Vector();
        this.m_metadataTypeList = new Vector();
        this.m_uniqueIDList = new Vector();
        this.m_selector = new PrototypeSelector(bundle.getString("PrototypeSelector.Category.ResourceTemplates.txt"));
        this.m_tree = this.m_selector.getTree();
        this.m_tree.getSelectionModel().setSelectionMode(4);
        this.m_treePane = new JScrollPane(this.m_tree, 20, 30);
        this.m_treePane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_treePane.setMinimumSize(new Dimension(315, 235));
        this.m_treePane.setPreferredSize(new Dimension(315, 235));
        this.m_selectAllButton = new JButton(bundle.getString("PrototypeTypicalView.SelectAll.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.m_selectAllButton, bundle.getString("PrototypeTypicalView.SelectAll.txt"));
        this.m_selectAllButton.setToolTipText(bundle.getString("PrototypeTypicalView.SelectAllTooltip"));
        this.m_selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrototypeTypicalView.this.onSelectAll();
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_treePane, gbc);
        this.add(this.m_treePane);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_selectAllButton, gbc);
        this.add(this.m_selectAllButton);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

