/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrototypeCustomView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected JList m_list;
    protected Vector m_dataList;
    protected JButton m_addButton;
    protected JButton m_removeButton;
    protected JScrollPane m_listPane;
    protected Component m_component;
    protected String m_strContext;
    protected List m_filesList;
    protected boolean m_bValid = true;
    protected static String searchPath = null;
    private static final WAdminResource bundle = WAdminResource.getBundle(PrototypeCustomView.class);

    public PrototypeCustomView(String strContext) {
        super(bundle.getString("PrototypeCustomView.WizardTitle.txt"));
        this.m_strContext = strContext;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.m_filesList = new Vector();
        }
        return false;
    }

    private Vector unzip(String file) {
        Vector<File> files = new Vector<File>();
        try {
            ZipEntry entry;
            int BUFFER = 2048;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(file);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[BUFFER];
                String suffix = entry.getName().substring(entry.getName().lastIndexOf("."));
                File tempFile = File.createTempFile(entry.getName(), suffix);
                files.add(tempFile);
                FileOutputStream fos = new FileOutputStream(tempFile);
                dest = new BufferedOutputStream(fos, BUFFER);
                while ((count = zis.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    public boolean validateData() {
        this.m_bValid = true;
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_dataList.size() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("PrototypeCustomView.NoResourceTemplates.txt"), (String)bundle.getString("Common.Information.txt"), (int)1);
            this.m_bValid = false;
            return this.m_bValid;
        }
        Vector<String> xmlToAddList = new Vector<String>();
        Vector<String> xmlFileNameList = new Vector<String>();
        Vector<String> invalidTemplatesList = new Vector<String>();
        Vector localeList = new Vector();
        Vector metadataTypeList = new Vector();
        Vector uniqueIDList = new Vector();
        for (int i = 0; i < this.m_dataList.size(); ++i) {
            Vector<String> propertyBundleFiles = new Vector<String>();
            String strPrototype = (String)this.m_dataList.get(i);
            if (strPrototype.endsWith(".jar") || strPrototype.endsWith(".zip")) {
                try {
                    Vector files = this.unzip(strPrototype);
                    for (int j = 0; j < files.size(); ++j) {
                        File tempFile = (File)files.get(j);
                        if (tempFile.getName().endsWith(".xml")) {
                            strPrototype = tempFile.getAbsolutePath();
                        }
                        if (!tempFile.getName().endsWith(".properties")) continue;
                        propertyBundleFiles.add(tempFile.getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            xmlFileNameList.add(strPrototype);
            try {
                URL url = XMLUtility.urlFromFile((String)strPrototype);
                Document doc = null;
                try {
                    HashMap<String, Boolean> features = new HashMap<String, Boolean>();
                    features.put("http://apache.org/xml/features/disallow-doctype-decl", true);
                    doc = Workspace.getMdFactory().getOMIUtil().parseXML(url, features);
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    this.m_bValid = false;
                    return this.m_bValid;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
                if (propertyBundleFiles.size() > 0) {
                    NodeList prototypeNodes = doc.getElementsByTagName("Prototype");
                    for (int k = 0; k < prototypeNodes.getLength(); ++k) {
                        Element prototypeNode = (Element)prototypeNodes.item(k);
                        NodeList noteNodes = prototypeNode.getElementsByTagName("Notes");
                        Node noteNode = null;
                        if (noteNodes.getLength() == 0) {
                            noteNode = doc.createElement("Notes");
                            prototypeNode.appendChild(noteNode);
                        } else {
                            noteNode = noteNodes.item(0);
                        }
                        try {
                            for (int j = 0; j < propertyBundleFiles.size(); ++j) {
                                PrototypeUtil.addPropertyBundleNode(propertyBundleFiles.get(j).toString(), doc, noteNode);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this._buildData(doc, localeList, metadataTypeList, uniqueIDList);
                String strContents = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
                int reposIndex = strContents.lastIndexOf("_ReposID_");
                if (reposIndex == -1) {
                    invalidTemplatesList.add(strPrototype);
                    continue;
                }
                String strXML = strContents.substring(0, reposIndex) + this.m_strContext + strContents.substring(reposIndex + 9);
                xmlToAddList.add(strXML);
                continue;
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        if (invalidTemplatesList.size() > 0) {
            String strInvalid = bundle.getString("PrototypeCustomView.InvalidResourceTemplates.txt") + "\n\n";
            for (int tempIndex = 0; tempIndex < invalidTemplatesList.size(); ++tempIndex) {
                String strTemplate = (String)invalidTemplatesList.get(tempIndex);
                strInvalid = strInvalid + strTemplate + "\n";
                this.m_dataList.remove(strTemplate);
            }
            MessageUtil.displayMessage((String)strInvalid, (String)bundle.getString("Common.Error.txt"), (int)0);
            this.m_list.setListData(this.m_dataList);
            this.m_bValid = false;
            return false;
        }
        parent.addWizardData("XMLList", xmlToAddList);
        parent.addWizardData("XMLNameList", xmlFileNameList);
        parent.addWizardData("LocaleList", localeList);
        parent.addWizardData("MetadataTypeList", metadataTypeList);
        parent.addWizardData("UniqueIDList", uniqueIDList);
        return this.m_bValid;
    }

    protected void _buildData(Node node, List localeList, List metadataTypeList, List uniqueIDList) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildData(children.item(childIndex), localeList, metadataTypeList, uniqueIDList);
                }
                break;
            }
            case 1: {
                NamedNodeMap childNodeMap = node.getAttributes();
                if (node.getNodeName().equals("Prototype")) {
                    String strMetadataType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    if (!strMetadataType.equals("ServerContext") && !strMetadataType.equals("ServerComponent") && !strMetadataType.equals("SASLibrary") && !strMetadataType.equals("DatabaseSchema")) break;
                    metadataTypeList.add(strMetadataType);
                    this._buildExtensionData(node, localeList, uniqueIDList);
                    this._buildAttributePropertyData(node, uniqueIDList);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildData(children.item(childIndex), localeList, metadataTypeList, uniqueIDList);
                }
                break;
            }
        }
    }

    protected void _buildExtensionData(Node node, List localeList, List uniqueIDList) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildExtensionData(children.item(childIndex), localeList, uniqueIDList);
                }
                break;
            }
            case 1: {
                NamedNodeMap childNodeMap = node.getAttributes();
                if (node.getNodeName().equals("Extension")) {
                    String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                    if (strName.equals("Locale")) {
                        childNodeMap.getNamedItem("Value").setNodeValue("Generic");
                        localeList.add("Generic");
                    }
                    if (!strName.equals("ServerClassIdentifier") || !childNodeMap.equals("VARCHAR")) break;
                    String strValue = childNodeMap.getNamedItem("Value").getNodeValue();
                    uniqueIDList.add(strValue);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildExtensionData(children.item(childIndex), localeList, uniqueIDList);
                }
                break;
            }
        }
    }

    protected void _buildAttributePropertyData(Node node, List uniqueIDList) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildAttributePropertyData(children.item(childIndex), uniqueIDList);
                }
                break;
            }
            case 1: {
                NamedNodeMap childNodeMap = node.getAttributes();
                if (node.getNodeName().equals("AttributeProperty")) {
                    String strPropertyName = childNodeMap.getNamedItem("PropertyName").getNodeValue();
                    if (!strPropertyName.equals("ClassIdentifier") && !strPropertyName.equals("Engine")) break;
                    String strDefaultValue = childNodeMap.getNamedItem("DefaultValue").getNodeValue();
                    uniqueIDList.add(strDefaultValue);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this._buildAttributePropertyData(children.item(childIndex), uniqueIDList);
                }
                break;
            }
        }
    }

    public void onListSelectionChanged() {
        this.m_removeButton.setEnabled(!this.m_list.isSelectionEmpty());
    }

    public void onAdd() {
        File selectedFile;
        Container parent = this.getTopLevelAncestor();
        if (searchPath == null) {
            searchPath = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(searchPath);
        chooser.setApproveButtonText(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.OK.txt")));
        chooser.setDialogTitle(bundle.getString("PrototypeCustomView.DialogTitle.Add.txt"));
        int returnType = chooser.showDialog(parent, null);
        String strFile = null;
        if (returnType == 0 && (selectedFile = chooser.getSelectedFile()) != null) {
            searchPath = chooser.getCurrentDirectory().getPath();
            strFile = selectedFile.getPath();
        }
        if (strFile == null) {
            return;
        }
        if (!(strFile.endsWith(".xml") || strFile.endsWith(".jar") || strFile.endsWith(".zip"))) {
            MessageUtil.displayMessage((String)bundle.getString("PrototypeCustomView.NonXMLFile.txt"), (String)bundle.getString("Common.Error.txt"), (int)0);
            return;
        }
        if (!this.m_dataList.contains(strFile)) {
            this.m_dataList.add(strFile);
        }
        this.m_list.setListData(this.m_dataList);
    }

    public void onRemove() {
        Object[] selectedArray = this.m_list.getSelectedValues();
        for (int i = 0; i < selectedArray.length; ++i) {
            String strSelected = (String)selectedArray[i];
            this.m_dataList.remove(strSelected);
        }
        this.m_list.setListData(this.m_dataList);
        this.onListSelectionChanged();
    }

    public void onNext() {
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.removeWizardData("XMLList");
        parent.removeWizardData("XMLNameList");
        parent.removeWizardData("LocaleList");
        parent.removeWizardData("MetadataTypeList");
        parent.removeWizardData("UniqueIDList");
    }

    public String createFinishString() {
        String strFinish = bundle.getString("PrototypeFinishView.ResourceTemplateTitle.txt") + "\n";
        for (int i = 0; i < this.m_dataList.size(); ++i) {
            strFinish = strFinish + "\t" + (String)this.m_dataList.get(i) + "\n";
        }
        return strFinish;
    }

    protected void _initialize() {
        this.setName(bundle.getString("PrototypeCustomView.TabName.txt"));
        this.m_dataList = new Vector();
        this.m_list = new JList(this.m_dataList);
        this.m_list.setToolTipText(bundle.getString("PrototypeCustomView.ListTooltip"));
        this.m_list.setSelectionMode(2);
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                PrototypeCustomView.this.onListSelectionChanged();
            }
        });
        this.m_listPane = new JScrollPane(this.m_list, 22, 30);
        this.m_listPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_listPane.setPreferredSize(new Dimension(315, 175));
        this.m_addButton = new JButton(bundle.getString("PrototypeCustomView.Add.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.m_addButton, bundle.getString("PrototypeCustomView.Add.txt"));
        this.m_addButton.setToolTipText(bundle.getString("PrototypeCustomView.AddTooltip"));
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrototypeCustomView.this.onAdd();
            }
        });
        this.m_removeButton = new JButton(bundle.getString("PrototypeCustomView.Remove.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.m_removeButton, bundle.getString("PrototypeCustomView.Remove.txt"));
        this.m_removeButton.setToolTipText(bundle.getString("PrototypeCustomView.RemoveTooltip"));
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrototypeCustomView.this.onRemove();
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_listPane, gbc);
        this.add(this.m_listPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        buttonPanel.add(this.m_addButton);
        buttonPanel.add(this.m_removeButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(buttonPanel, gbc);
        this.add(buttonPanel);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

