/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASCatalog;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.mgmt.visuals.FolderUtil;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class Library {
    protected DeployedDataPackage m_deployedDataPackage;
    protected String m_strContext;
    protected Component m_parentComponent;
    protected MdObjectStore m_objectStore = null;
    private static final WAdminResource bundle = WAdminResource.getBundle(Library.class);

    public Library(String strContext, MdObjectStore objectStore) {
        try {
            this.m_strContext = strContext;
            this.m_objectStore = objectStore;
            this.m_deployedDataPackage = (DeployedDataPackage)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, bundle.getString("Library.LibraryIdentifierName.Library.txt"), "DeployedDataPackage", strContext.substring(9), null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public Library(String strContext, DeployedDataPackage deployedDataPackage) {
        this(strContext, deployedDataPackage, null);
    }

    public Library(String strContext, DeployedDataPackage deployedDataPackage, MdObjectStore objectStore) {
        this.m_strContext = strContext;
        this.m_deployedDataPackage = deployedDataPackage;
        this.m_objectStore = objectStore;
    }

    public MdObjectStore getStore() {
        return this.m_objectStore;
    }

    public DeployedDataPackage getDeployedDataPackage() {
        return this.m_deployedDataPackage;
    }

    public void setDeployedDataPackage(DeployedDataPackage deployedDataPackage) {
        this.m_deployedDataPackage = deployedDataPackage;
    }

    public Component getParentComponent() {
        return this.m_parentComponent;
    }

    public void setParentComponent(Component component) {
        this.m_parentComponent = component;
    }

    public Prototype getDeployedDataPackagePrototype(Component parent) throws MdException, RemoteException {
        return this.getDeployedDataPackagePrototype(parent, false);
    }

    public Prototype getDeployedDataPackagePrototype(Component parent, boolean bShowPrototypeSelector) throws MdException, RemoteException {
        Prototype prototype = (Prototype)this.getDeployedDataPackage().getUsingPrototype();
        if (prototype != null) {
            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
            int flags = 268;
            prototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)prototype, new Vector(), new Vector(), strTemplate, flags);
        }
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                String localeValue = extension.getValue();
                if (!localeValue.equalsIgnoreCase("Generic")) break;
                return prototype;
            }
        }
        Locale locale = Locale.getDefault();
        if (prototype != null) {
            AssociationList extensionList = PrototypeUtil.getParentPrototype(prototype, this.m_strContext).getExtensions();
            boolean bLocaleExtensionFound = false;
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (!extension.getName().equals("Locale")) continue;
                if (!PrototypeUtil.getLocale(extension.getValue()).equals(locale) && !PrototypeUtil.getLocale(extension.getValue()).getLanguage().equals(locale.getLanguage())) {
                    prototype = null;
                }
                bLocaleExtensionFound = true;
                break;
            }
            if (!bLocaleExtensionFound && !PrototypeUtil.getLocale("en_US").equals(locale)) {
                prototype = null;
            }
        }
        if (prototype == null) {
            String strEngine = ((SASLibrary)this.getDeployedDataPackage()).getEngine();
            if (!strEngine.equals("DB2")) {
                int returnValue;
                if (strEngine.equalsIgnoreCase("V7") || strEngine.equalsIgnoreCase("V701") || strEngine.equalsIgnoreCase("V8") || strEngine.equalsIgnoreCase("V9")) {
                    strEngine = "BASE";
                }
                if ((prototype = ServerWizard.getPrototype("PrototypeProperties", "Engine", strEngine, this.getContext(), this.getStore(), parent, "SASLibrary")) != null) {
                    this.getDeployedDataPackage().setUsingPrototype((Root)prototype);
                } else if (bShowPrototypeSelector && (returnValue = MessageUtil.displayMessage((String)bundle.getString("ServerWizard.NoAssociatedResourceTemplate.Library.txt"), (String)bundle.getString("Common.Warning.txt"), (int)2, (int)0)) == 0) {
                    prototype = Server.getPrototypeViaSelector(parent, "SASLibrary", this.m_strContext, this.m_objectStore);
                }
            } else {
                int returnValue;
                SASClientConnection libraryConnection = ((SASLibrary)this.getDeployedDataPackage()).getLibraryConnection();
                String strClassID = null;
                if (libraryConnection != null) {
                    strClassID = libraryConnection.getSource().getClassIdentifier();
                }
                if (strClassID != null) {
                    prototype = ServerWizard.getPrototype("Extensions", "ServerClassIdentifier", strClassID, this.getContext(), this.getStore(), parent, "SASLibrary");
                }
                if (prototype != null) {
                    this.getDeployedDataPackage().setUsingPrototype((Root)prototype);
                } else if (bShowPrototypeSelector && (returnValue = MessageUtil.displayMessage((String)bundle.getString("ServerWizard.NoAssociatedResourceTemplate.Library.txt"), (String)bundle.getString("Common.Warning.txt"), (int)2, (int)0)) == 0) {
                    prototype = Server.getPrototypeViaSelector(parent, "SASLibrary", this.m_strContext, this.m_objectStore);
                    this.getDeployedDataPackage().setUsingPrototype((Root)prototype);
                }
            }
        }
        return prototype;
    }

    public String getContext() {
        return this.m_strContext;
    }

    public void persist() throws MdException, RemoteException {
        Workspace.getDefaultLogger().debug((Object)"Starting write");
        this.m_deployedDataPackage.updateMetadataAll();
        Workspace.getDefaultLogger().debug((Object)"Finished write");
    }

    public void assignToServer(DeployedComponent deployedComponent) {
        try {
            this.getDeployedDataPackage().getDeployedComponents().add((Object)deployedComponent);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void assignToServer(List deployedComponentList) {
        try {
            if (!this.getDeployedDataPackage().getDeployedComponents().equals((Object)deployedComponentList)) {
                this.getDeployedDataPackage().getDeployedComponents().removeAllElements();
                for (int i = 0; i < deployedComponentList.size(); ++i) {
                    DeployedComponent deployedComponent = (DeployedComponent)deployedComponentList.get(i);
                    this.getDeployedDataPackage().getDeployedComponents().add((Object)deployedComponent);
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void aliasFor(DeployedDataPackage deployedDataPackage) {
        try {
            this.getDeployedDataPackage().getAliasFors().add((Object)deployedDataPackage);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public DatabaseSchema addDatabaseSchema() {
        DatabaseSchema mySchema = null;
        try {
            mySchema = (DatabaseSchema)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "DatabaseSchema", "DatabaseSchema", this.m_strContext.substring(9), null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return mySchema;
    }

    public Directory addDirectory() {
        Directory myDir = null;
        try {
            myDir = (Directory)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "Directory", "Directory", this.m_strContext.substring(9), null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return myDir;
    }

    public OLAPSchema addOLAPSchema() {
        OLAPSchema mySchema = null;
        try {
            mySchema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "OLAPSchema", "OLAPSchema", this.m_strContext.substring(9), null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return mySchema;
    }

    public SASCatalog addSASCatalog() {
        SASCatalog myCat = null;
        try {
            myCat = (SASCatalog)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "SASCatalog", "SASCatalog", this.m_strContext.substring(9), null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return myCat;
    }

    public SASLibrary addSASLibrary() {
        SASLibrary myLib = null;
        try {
            myLib = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "SASLibrary", "SASLibrary", this.m_strContext.substring(9), null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return myLib;
    }

    public RelationalSchema addTablePackage() {
        RelationalSchema myTP = null;
        try {
            myTP = (RelationalSchema)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, "RelationalSchema", "RelationalSchema", this.m_strContext.substring(9), null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return myTP;
    }

    public static boolean validateLibraryName(String libId, String libName, Tree tree, List serverList) {
        boolean bValidated = true;
        AssociationList m_oList = new Vector();
        try {
            if (tree != null && !WsMetadataNameUtil.isNameUniqueInFolder((String)libName, (Tree)tree, (String)"Library")) {
                MessageUtil.displayMessage((String)bundle.formatString("LibraryValidation.LibraryNameExistsError.Location.txt", (Object)libName, (Object)FolderUtil.getDisplayPathFromTree(tree)), (String)bundle.getString("Common.Error.txt"), (int)0);
                bValidated = false;
            }
            if (bValidated && serverList != null) {
                block3: for (int i = 0; i < serverList.size() && bValidated; ++i) {
                    DeployedComponent dc = (DeployedComponent)serverList.get(i);
                    m_oList = dc.getDataPackages(true);
                    for (int j = 0; j < m_oList.size(); ++j) {
                        SASLibrary sasLib;
                        Object obj = m_oList.get(j);
                        if (!(obj instanceof SASLibrary) || !(sasLib = (SASLibrary)obj).getName().equalsIgnoreCase(libName) || sasLib.getId().equalsIgnoreCase(libId)) continue;
                        String changedStateStr = sasLib.getChangeState();
                        String checkedOutToStr = "";
                        if (changedStateStr.contains("Checked-out to :")) {
                            checkedOutToStr = changedStateStr.substring(changedStateStr.indexOf(":") + 1).trim();
                        }
                        if (checkedOutToStr.equalsIgnoreCase(libId)) continue;
                        MessageUtil.displayMessage((String)bundle.formatString("LibraryValidation.LibraryNameExistsError.Server.txt", (Object)libName, (Object)dc.getName()), (String)bundle.getString("Common.Error.txt"), (int)0);
                        bValidated = false;
                        continue block3;
                    }
                }
            }
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
            bValidated = false;
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
            bValidated = false;
        }
        return bValidated;
    }
}

