/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMCommon.IServerStatus;
import com.sas.iom.SASIOMCommon.IServerStatusHelper;
import com.sas.iom.SASIOMCommon.ServerState;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMRConnectionImpl;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.ConnectionFailedException;
import com.sas.workspace.mgmt.visuals.ServerConnectionInterface;
import com.sas.workspace.visuals.LogonView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.omg.CORBA.Object;

public class IOMBridgeConnection
implements ServerConnectionInterface {
    protected IWorkspace m_workspace;
    protected ConnectAction m_connectAction;
    protected DisconnectAction m_disconnectAction;
    protected boolean m_bIsConnected = false;
    protected Component m_parentComponent;
    static final WAdminResource bundle = WAdminResource.getBundle(IOMBridgeConnection.class);

    @Override
    public List getContextMenuActions(Connection connection) {
        return this._getActions(connection);
    }

    @Override
    public List getToolBarActions(Connection connection) {
        return this._getActions(connection);
    }

    protected List _getActions(Connection connection) {
        Vector<TestConnectAction> actionsList = new Vector<TestConnectAction>();
        try {
            if (!(connection instanceof TCPIPConnection) || !connection.getApplicationProtocol().equalsIgnoreCase("bridge")) {
                return actionsList;
            }
            TestConnectAction testConnectAction = new TestConnectAction(connection);
            actionsList.add(testConnectAction);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return actionsList;
    }

    @Override
    public boolean testConnection(Connection connection) throws ConnectionFailedException {
        try {
            if (!(connection instanceof TCPIPConnection)) {
                return false;
            }
            DeployedComponent dc = null;
            try {
                dc = connection.getSource();
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                return false;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)re);
            }
            String host = null;
            int port = -1;
            String encryptionPolicy = null;
            String encryptionContent = null;
            String encryptionAlgorithms = null;
            TCPIPConnection cx = (TCPIPConnection)connection;
            String protocol = cx.getApplicationProtocol();
            if ("Bridge".equals(protocol)) {
                host = cx.getHostName();
                port = cx.getPort();
                AssociationList propertyList = cx.getProperties();
                if (propertyList != null) {
                    HashMap cxProperties = new HashMap();
                    IOMBridgeConnection.addProperties((List)propertyList, cxProperties);
                    String requiredEncryptionLevel = (String)cxProperties.get("RequiredEncryptionLevel");
                    if ("credentials".equals(requiredEncryptionLevel) || "authentication".equals(requiredEncryptionLevel)) {
                        encryptionPolicy = "required";
                        encryptionContent = "authentication";
                    } else if ("everything".equals(requiredEncryptionLevel) || "all".equals(requiredEncryptionLevel)) {
                        encryptionPolicy = "required";
                        encryptionContent = "all";
                    }
                    encryptionAlgorithms = (String)cxProperties.get("ServerEncryptionAlgorithms");
                }
            }
            BridgeServer server = new BridgeServer(dc.getClassIdentifier(), host, port);
            String strDomain = cx.getDomain().getName();
            server.setDomain(strDomain);
            if (encryptionPolicy != null) {
                server.setEncryptionPolicy(encryptionPolicy);
            }
            if (encryptionContent != null) {
                server.setEncryptionContent(encryptionContent);
            }
            if (encryptionAlgorithms != null) {
                server.setEncryptionAlgorithms(encryptionAlgorithms);
            }
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
            String factoryName = ConnectionFactoryManager.getConnectionFactoryLoggerName((ConnectionFactoryConfiguration)cxfConfig);
            MdOMRConnectionImpl.configLogger((String)factoryName);
            ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            WAStandardDialog dialog = null;
            if (this.m_parentComponent instanceof Dialog) {
                dialog = new WAStandardDialog((Dialog)this.m_parentComponent, bundle.getString("IOMBridgeConnection.LogOnTo.txt") + host, true);
            } else if (this.m_parentComponent instanceof Frame) {
                dialog = new WAStandardDialog((Frame)this.m_parentComponent, bundle.getString("IOMBridgeConnection.LogOnTo.txt") + host, true);
            }
            LogonView view = new LogonView();
            dialog.setMainPanel((WAPanel)view);
            dialog.show();
            if (dialog.getReturnValue() == 2) {
                return false;
            }
            String strUserName = view.getUserName();
            ConnectionInterface IOMcx = cxf.getConnection(strUserName, view.getPassword(), strDomain);
            if (IOMcx == null) {
                return false;
            }
            IOMcx.close();
        }
        catch (Exception e) {
            this.m_parentComponent.setCursor(Cursor.getPredefinedCursor(0));
            throw new ConnectionFailedException(e.getLocalizedMessage());
        }
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.m_workspace != null;
    }

    @Override
    public void setParentComponent(Component component) {
        this.m_parentComponent = component;
    }

    protected void _setState() {
        this.m_connectAction.setEnabled(!this.m_bIsConnected);
        this.m_disconnectAction.setEnabled(this.m_bIsConnected);
    }

    protected IWorkspace _connectToWorkspace(String strHost, String strPort) throws Exception {
        WAStandardDialog dialog = null;
        if (this.m_parentComponent instanceof Dialog) {
            dialog = new WAStandardDialog((Dialog)this.m_parentComponent, bundle.getString("IOMBridgeConnection.LogOnTo.txt") + strHost, true);
        } else if (this.m_parentComponent instanceof Frame) {
            dialog = new WAStandardDialog((Frame)this.m_parentComponent, bundle.getString("IOMBridgeConnection.LogOnTo.txt") + strHost, true);
        }
        LogonView view = new LogonView();
        dialog.setMainPanel((WAPanel)view);
        dialog.show();
        if (dialog.getReturnValue() == 2) {
            return null;
        }
        String strUserName = view.getUserName();
        this.m_parentComponent.setCursor(Cursor.getPredefinedCursor(3));
        this.m_workspace = Workspace.getMdFactory().getConnection().makeIOMConnection(strHost, strPort, strUserName, view.getPassword());
        this.m_bIsConnected = true;
        this.m_parentComponent.setCursor(Cursor.getPredefinedCursor(0));
        return this.m_workspace;
    }

    protected void _disconnectFromWorkspace() throws Exception {
        if (this.m_workspace != null) {
            Workspace.getMdFactory().getConnection().closeIOMConnection(this.m_workspace);
            this.m_workspace = null;
            this.m_bIsConnected = false;
        }
    }

    private static void addProperties(List propertyList, Map table) {
        try {
            int propertyListSize = propertyList != null ? propertyList.size() : 0;
            for (int i = 0; i < propertyListSize; ++i) {
                Property property = (Property)propertyList.get(i);
                table.put(property.getPropertyName(), property.getDefaultValue());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public boolean testSPConnection(Connection connection) throws ConnectionFailedException {
        IServerStatus status = null;
        TCPIPConnection tcpip = (TCPIPConnection)connection;
        try {
            BridgeServer omrServer = new BridgeServer("15931e31-667f-11d5-8804-00c04f35ac8c", tcpip.getHostName(), tcpip.getPort());
            ManualConnectionFactoryConfiguration connectConfig = new ManualConnectionFactoryConfiguration((Server)omrServer);
            String factoryName = ConnectionFactoryManager.getConnectionFactoryLoggerName((ConnectionFactoryConfiguration)connectConfig);
            MdOMRConnectionImpl.configLogger((String)factoryName);
            ConnectionFactoryInterface connectFactory = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)connectConfig);
            ConnectionInterface connect = connectFactory.getConnection();
            Object obj = connect.getObject();
            status = IServerStatusHelper.narrow((Object)obj);
        }
        catch (Exception e) {
            throw new ConnectionFailedException(e.getLocalizedMessage());
        }
        ServerState serverState = status.ServerStatusState();
        return serverState.value() == 2;
    }

    protected class DisconnectAction
    extends AbstractAction {
        protected Connection m_connection;
        private static final long serialVersionUID = -6474153454718568587L;

        public DisconnectAction(Connection connection) {
            this.m_connection = connection;
            MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("IOMBridgeConnection.DisconnectAction.Name.txt"), null, bundle.getImageIcon("IOMBridgeConnection.DisconnectAction.Icon.image"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!(this.m_connection instanceof TCPIPConnection)) {
                JOptionPane.showMessageDialog(IOMBridgeConnection.this.m_parentComponent, bundle.getString("IOMBridgeConnection.UnableToDisconnect.txt"), bundle.getString("Common.Error.txt"), 0);
                return;
            }
            try {
                IOMBridgeConnection.this._disconnectFromWorkspace();
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(IOMBridgeConnection.this.m_parentComponent, exc.getMessage(), bundle.getString("Common.Error.txt"), 0);
            }
            IOMBridgeConnection.this._setState();
        }
    }

    protected class ConnectAction
    extends AbstractAction {
        protected Connection m_connection;
        private static final long serialVersionUID = 3672374929877423906L;

        public ConnectAction(Connection connection) {
            this.m_connection = connection;
            MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("IOMBridgeConnection.ConnectAction.Name.txt"), null, bundle.getImageIcon("IOMBridgeConnection.ConnectAction.Icon.image"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!(this.m_connection instanceof TCPIPConnection)) {
                JOptionPane.showMessageDialog(IOMBridgeConnection.this.m_parentComponent, bundle.getString("IOMBridgeConnection.UnableToConnect.txt"), bundle.getString("Common.Error.txt"), 0);
                return;
            }
            TCPIPConnection tcpConnection = (TCPIPConnection)this.m_connection;
            try {
                IOMBridgeConnection.this.testConnection((Connection)tcpConnection);
            }
            catch (Exception exc) {
                IOMBridgeConnection.this.m_parentComponent.setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(IOMBridgeConnection.this.m_parentComponent, exc.getMessage(), bundle.getString("Common.Error.txt"), 0);
            }
            IOMBridgeConnection.this._setState();
            IOMBridgeConnection.this.m_parentComponent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class TestConnectAction
    extends AbstractAction {
        protected Connection m_connection;
        private static final long serialVersionUID = 368581263372387874L;

        public TestConnectAction(Connection connection) {
            this.m_connection = connection;
            MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("IOMBridgeConnection.TestConnectAction.Name.txt"), bundle.getString("IOMBridgeConnection.TestConnectAction.Name.txt"), bundle.getImageIcon("IOMBridgeConnection.TestConnectAction.Icon.image"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("IOMBridgeConnection.ProgressIndicator.Message.txt"), bundle.getString("IOMBridgeConnection.ProgressIndicator.Title.txt"));
            Runnable rblConnect = new Runnable(){

                @Override
                public void run() {
                    TestConnectAction.this.test();
                }
            };
            request.execute(rblConnect);
        }

        void test() {
            boolean bSuccess = false;
            try {
                bSuccess = IOMBridgeConnection.this.testConnection(this.m_connection);
                if (bSuccess) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(IOMBridgeConnection.this.m_parentComponent, bundle.getString("Common.Connection.TestSuccess.txt"), bundle.getString("Common.Connection.Test.txt"), 1);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage());
                    }
                    catch (InvocationTargetException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage());
                    }
                }
            }
            catch (ConnectionFailedException exc) {
                final String strFailMessage = exc.getMessage();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            MessageUtil.displayMessage((String)strFailMessage, (String)bundle.getString("Common.Connection.Test.txt"), (int)0);
                        }
                    });
                }
                catch (InterruptedException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage());
                }
                catch (InvocationTargetException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage());
                }
            }
        }
    }
}

