/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.MnemonicModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GenericQuestionTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected String m_question;
    protected String m_expandedYesAnswer;
    protected String m_expandedNoAnswer;
    protected WATextArea m_questionTextArea;
    protected boolean b_defaultYes;
    protected JPanel m_buttonPanel;
    protected JRadioButton m_yesButton;
    protected JRadioButton m_noButton;
    protected ButtonGroup m_buttons;
    protected String m_wizardDataTag;
    private static WAdminResource bundle = WAdminResource.getBundle(GenericQuestionTab.class);

    public GenericQuestionTab(String question, boolean defaultYes) {
        this(question, null, null, defaultYes, null);
    }

    public GenericQuestionTab(String question, String expandedYesAnswer, String expandedNoAnswer, boolean defaultYes, String wizardDataTag) {
        this.m_question = question;
        this.b_defaultYes = defaultYes;
        this.m_expandedYesAnswer = expandedYesAnswer;
        this.m_expandedNoAnswer = expandedNoAnswer;
        this.m_wizardDataTag = wizardDataTag;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean validateData() {
        if (this.m_yesButton.isSelected()) {
            this.setConditionState("YES");
        } else {
            this.setConditionState("NO");
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    public void onNext() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_wizardDataTag != null) {
            wizard.replaceWizardData(this.m_wizardDataTag, (Object)(this.m_yesButton.isSelected() ? "YES" : "NO"));
        }
    }

    protected void _initialize() {
        if (this.m_expandedYesAnswer == null) {
            this.m_yesButton = new JRadioButton(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")));
            this.m_yesButton.setName(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")));
        } else {
            this.m_yesButton = new JRadioButton(this.m_expandedYesAnswer);
            this.m_yesButton.setName(this.m_expandedYesAnswer);
        }
        if (this.m_expandedNoAnswer == null) {
            this.m_noButton = new JRadioButton(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.No.txt")));
            this.m_noButton.setName(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")));
        } else {
            this.m_noButton = new JRadioButton(this.m_expandedNoAnswer);
            this.m_noButton.setName(this.m_expandedNoAnswer);
        }
        this.m_buttons = new ButtonGroup();
        this.m_buttons.add(this.m_yesButton);
        this.m_buttons.add(this.m_noButton);
        this.m_buttons.setSelected(this.b_defaultYes ? this.m_yesButton.getModel() : this.m_noButton.getModel(), true);
        this.m_questionTextArea = new WATextArea(this.m_question);
        this.m_questionTextArea.setBackground(this.getBackground());
        this.m_questionTextArea.setWrapStyleWord(true);
        this.m_questionTextArea.setLineWrap(true);
        this.m_questionTextArea.setEditable(false);
        this.m_questionTextArea.setBehavior(1);
        this.m_buttonPanel = new JPanel();
    }

    protected void _layoutWidgets() {
        GridBagLayout gblMain = new GridBagLayout();
        this.setLayout(gblMain);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(12, 6, 12, 0);
        gblMain.setConstraints((Component)this.m_questionTextArea, gbc);
        this.add((Component)this.m_questionTextArea);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 6, 0, 6);
        gbc.anchor = 17;
        gblMain.setConstraints(this.m_yesButton, gbc);
        this.add(this.m_yesButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 6, 12, 0);
        gbc.anchor = 17;
        gblMain.setConstraints(this.m_noButton, gbc);
        this.add(this.m_noButton);
    }
}

