/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DirectoryDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    protected Directory m_directory;
    protected List m_directoryList;
    protected Component m_component;
    protected String m_strContext;
    protected MdObjectStore m_objectStore;
    protected JLabel m_nameLabel;
    protected JTextField m_nameText;
    protected JButton m_browseButton;
    private static final WAdminResource bundle = WAdminResource.getBundle(DirectoryDialog.class);

    public DirectoryDialog(Frame frame, MdObjectStore objectStore, String strContext) {
        super(frame, bundle.getString("DirectoryDialog.Title.txt"), true);
        this.m_component = frame;
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this._initialize();
        this._layoutWidgets();
    }

    public DirectoryDialog(Dialog dialog, MdObjectStore objectStore, String strContext) {
        super(dialog, bundle.getString("DirectoryDialog.Title.txt"), true);
        this.m_component = dialog;
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (bSaveToModel) {
                this.m_directory = (Directory)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, this.m_nameText.getText().trim(), "Directory", this.m_strContext.substring(9));
                this.m_directory.setDirectoryName(this.m_nameText.getText().trim());
                try {
                    this.m_directory.updateMetadataAll();
                    this.m_objectStore.dispose();
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            } else {
                try {
                    int flags = 8456;
                    this.m_directoryList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.m_strContext, "Directory", flags, "");
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean validateData() {
        try {
            boolean bValid = true;
            if (this.m_nameText.getText().trim().length() == 0) {
                return false;
            }
            for (int i = 0; i < this.m_directoryList.size(); ++i) {
                Directory directory = (Directory)this.m_directoryList.get(i);
                if (!directory.getName().equalsIgnoreCase(this.m_nameText.getText().trim())) continue;
                JOptionPane.showMessageDialog(this.m_component, bundle.getString("DirectoryDialog.DirectoryExists.txt"), bundle.getString("Common.Error.txt"), 0);
                bValid = false;
                break;
            }
            return bValid;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public void onBrowse() {
        File selectedFile;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int returnType = chooser.showOpenDialog((Component)((Object)this));
        if (returnType == 0 && (selectedFile = chooser.getSelectedFile()) != null) {
            String strPath = selectedFile.getPath();
            this.m_nameText.setText(strPath);
        }
    }

    public Directory getDirectory() {
        return this.m_directory;
    }

    public Root getMetadataObject() {
        return this.m_directory;
    }

    protected void _initialize() {
        this.setHelpProduct("templatedata");
        this.setHelpTopic("new_dir");
        this.m_nameLabel = new JLabel(bundle.getString("DirectoryDialog.PathLabel.txt"));
        this.m_nameText = new JTextField(15);
        this.m_browseButton = new JButton(bundle.getString("Common.Browse....txt"));
        this.m_browseButton.setMargin(new Insets(0, 4, 0, 4));
        this.m_browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryDialog.this.onBrowse();
            }
        });
    }

    protected void _layoutWidgets() {
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gridBagLayout.setConstraints(this.m_nameLabel, gbc);
        panel.add(this.m_nameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 12, 0);
        gridBagLayout.setConstraints(this.m_nameText, gbc);
        panel.add(this.m_nameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(this.m_browseButton, gbc);
        panel.add(this.m_browseButton);
        this.getContentPane().add(panel);
    }
}

