/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Tree;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class ConnectSpawnerServersView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected int m_type;
    protected List m_serversList;
    protected String m_strHost;
    protected JLabel m_serversLabel;
    protected DualListSelector m_serversChoice;
    protected Vector m_dataList;
    protected JButton m_serversButton;
    protected Machine m_associatedMachine;
    protected List m_associatedMachines;
    private static final WAdminResource bundle = WAdminResource.getBundle(ConnectSpawnerServersView.class);

    public ConnectSpawnerServersView(Server server, int type) {
        super(bundle.getString("ConnectSpawnerServersView.WizardTitle.txt"));
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_type == 1) {
            this._setViewProperties();
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_dataList.removeAllElements();
        this.m_dataList.addAll(this.m_serversList);
        Vector sourceDataList = new Vector();
        Vector targetDataList = new Vector();
        for (int serverIndex = 0; serverIndex < this.m_serversList.size(); ++serverIndex) {
            ServerComponent serverComponent = (ServerComponent)this.m_serversList.get(serverIndex);
            if (Server.isConnectServer((DeployedComponent)serverComponent)) continue;
            this.m_dataList.remove(serverComponent);
        }
        AssociationList serversList = null;
        String hstName = "";
        Vector<ServerComponent> targetsToRemoveList = new Vector<ServerComponent>();
        try {
            serversList = this.m_server.getDeployedComponent().getUsedByComponents();
            for (int j = 0; j < serversList.size(); ++j) {
                ServerComponent sc = (ServerComponent)serversList.get(j);
                hstName = sc.getAssociatedMachine().getName().trim();
                this.m_strHost = this.m_strHost.trim();
                if (!hstName.equals(this.m_strHost)) {
                    targetsToRemoveList.add(sc);
                }
                if (this.m_associatedMachines == null || this.m_associatedMachines.size() == 0) {
                    hstName = sc.getAssociatedMachine().getName().trim();
                    this.m_strHost = this.m_strHost.trim();
                    if (hstName.equals(this.m_strHost)) continue;
                    targetsToRemoveList.add(sc);
                    continue;
                }
                List machines = this.getServerComponentMachines((DeployedComponent)sc);
                boolean found = false;
                for (int k = 0; k < machines.size() && !found; ++k) {
                    found = this.m_associatedMachines.contains(machines.get(k));
                }
                if (found) continue;
                targetsToRemoveList.add(sc);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            return;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        sourceDataList.addAll(this.m_dataList);
        sourceDataList.removeAll((Collection<?>)serversList);
        targetDataList.addAll(serversList);
        targetDataList.removeAll(targetsToRemoveList);
        DefaultListModel sourceModel = new DefaultListModel();
        for (int index = 0; index < sourceDataList.size(); ++index) {
            sourceModel.add(index, sourceDataList.get(index));
        }
        this.m_serversChoice.setModel(sourceModel);
        DefaultListModel targetModel = new DefaultListModel();
        for (int index = 0; index < targetDataList.size(); ++index) {
            targetModel.add(index, targetDataList.get(index));
        }
        this.m_serversChoice.setTargetModel(targetModel);
    }

    public void populateStore() throws MdException, RemoteException {
        try {
            this.m_associatedMachine = this.m_server.getDeployedComponent().getAssociatedMachine();
            this.m_strHost = this.m_associatedMachine.getName();
            int flags = 8604;
            String strTemplate = "<ServerComponent><ServiceTypes/></ServerComponent>";
            String strSelect = "<XMLSELECT search=\"*[SourceConnections/*[@RemoteAddress='" + this.m_strHost + "']]\"/>";
            String strOptions = strTemplate + strSelect;
            this.m_serversList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_server.getDeployedComponent().getObjectStore(), this.m_server.getContext(), "ServerComponent", flags, strOptions);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            return;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public boolean validateData() {
        boolean bValid = true;
        Container parent = this.getTopLevelAncestor();
        if (this.m_serversChoice.getTargetModel().getSize() == 0) {
            bValid = false;
            String strMessage = bundle.getString("ConnectSpawnerServersView.ServerError.txt");
            String strTitle = bundle.getString("ConnectSpawnerServersView.ServerError.Title.txt");
            JOptionPane.showMessageDialog(parent, strMessage, strTitle, 0);
        }
        return bValid;
    }

    public void onNewServer() {
        try {
            ViewListener viewListener = new ViewListener(this.m_serversChoice);
            Workspace.getMdFactory().addMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            String strClassID = "SAS Application Server";
            String[] classIDArray = new String[]{strClassID};
            Container parent = this.getTopLevelAncestor();
            ServerWizard wizard = null;
            MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore();
            objectStore.setIsObjectCopiedFromParentOnCreation(false);
            Connection conn = (Connection)Workspace.getMdFactory().createComplexMetadataObject(objectStore, null, "Connection", "Connection", this.m_server.getContext().substring(9));
            Hashtable<Connection, Hashtable[]> propertiesTable = new Hashtable<Connection, Hashtable[]>();
            Hashtable<String, String> valueTable = new Hashtable<String, String>();
            valueTable.put("PropertyName", "RemoteAddress");
            valueTable.put("MetadataType", "TCPIPConnection");
            valueTable.put("IsUpdateable", "0");
            valueTable.put("DefaultValue", this.m_strHost);
            Hashtable[] tableArray = new Hashtable[]{valueTable};
            propertiesTable.put(conn, tableArray);
            if (parent instanceof JFrame) {
                wizard = new ServerWizard((JFrame)parent, this.m_server.getContext(), bundle.getString("ConnectSpawnerServersView.ServerWizard.Title.txt"), classIDArray, objectStore, propertiesTable);
            } else if (parent instanceof Dialog) {
                wizard = new ServerWizard((Dialog)parent, objectStore, this.m_server.getContext(), bundle.getString("ConnectSpawnerServersView.ServerWizard.Title.txt"), classIDArray, propertiesTable);
            }
            wizard.show();
            if (wizard.getReturnValue() == 2) {
                Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            }
            objectStore.dispose();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void _setViewProperties() {
        try {
            ListModel targetListModel = this.m_serversChoice.getTargetModel();
            Vector serversList = new Vector();
            for (int tIndex = 0; tIndex < targetListModel.getSize(); ++tIndex) {
                serversList.add(targetListModel.getElementAt(tIndex));
            }
            Object[] serversArray = serversList.toArray();
            if (!this.m_server.getDeployedComponent().getUsedByComponents().equals(serversList)) {
                this.m_server.getDeployedComponent().getUsedByComponents().removeAllElements();
                for (int index = 0; index < serversArray.length; ++index) {
                    ServerComponent sc = (ServerComponent)serversArray[index];
                    this.m_server.getDeployedComponent().getUsedByComponents().add((Object)sc);
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNext() {
        this._setViewProperties();
    }

    public void onBack() {
        this._setViewProperties();
    }

    public String createFinishString() {
        String strFinish = "\n" + bundle.getString("ConnectSpawnerServersView.SpawnedServersLabel.txt") + "\n\t";
        ListModel targetListModel = this.m_serversChoice.getTargetModel();
        Vector serversList = new Vector();
        for (int tIndex = 0; tIndex < targetListModel.getSize(); ++tIndex) {
            serversList.add(targetListModel.getElementAt(tIndex));
        }
        Object[] serversArray = serversList.toArray();
        for (int objIndex = 0; objIndex < serversArray.length; ++objIndex) {
            Object obj = serversArray[objIndex];
            Root root = (Root)obj;
            String strRootDisplayName = MetadataObjectCellRenderer.getDisplayName(root);
            strFinish = strFinish + strRootDisplayName;
            if (objIndex < 0 || objIndex >= serversArray.length - 1) continue;
            strFinish = strFinish + ",\n\t";
        }
        strFinish = strFinish + "\n";
        return strFinish;
    }

    protected void _initialize() {
        this.setName(bundle.getString("ConnectSpawnerServersView.TabName.txt"));
        this.setHelpProduct("templatedata");
        this.setHelpTopic("servwiz_connspawner_servers");
        this.m_serversLabel = new JLabel(bundle.getString("SpawnerServersView.ServersLabel.txt"));
        this.m_serversChoice = new DualListSelector();
        ((JList)this.m_serversChoice.getSourceComponent()).setFixedCellHeight(this.getFontMetrics(this.getFont()).getHeight());
        ((JList)this.m_serversChoice.getSourceComponent()).setFixedCellHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.m_serversChoice.setSourceLabel(bundle.getString("SpawnerServersView.Label.AvailableServers.txt"));
        this.m_serversChoice.setTargetLabel(bundle.getString("SpawnerServersView.Label.SelectedServers.txt"));
        this.m_dataList = new Vector();
        this.m_serversButton = new JButton();
        MnemonicModel.setButtonTextAndMnemonic(this.m_serversButton, bundle.getString("Common.New....txt"));
        this.m_serversButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectSpawnerServersView.this.onNewServer();
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_serversLabel, gbc);
        this.add(this.m_serversLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_serversChoice, gbc);
        this.add((Component)this.m_serversChoice);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 0));
        buttonPanel.add(this.m_serversButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(8, 12, 0, 12);
        gridBagLayout.setConstraints(buttonPanel, gbc);
        this.add(buttonPanel);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private List getServerComponentMachines(DeployedComponent sc) {
        Vector<Machine> machines = new Vector<Machine>();
        try {
            AssociationList trees = sc.getSoftwareTrees();
            for (int i = 0; i < trees.size(); ++i) {
                if (!((Tree)trees.get(i)).getTreeType().equals("MachineGroup")) continue;
                machines.addAll((Collection<Machine>)((Tree)trees.get(i)).getMembers());
                break;
            }
            if (trees.size() == 0) {
                machines.add(sc.getAssociatedMachine());
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return machines;
    }

    protected class ViewListener
    implements MdObjectFactoryListener {
        protected DualListSelector m_choice;
        protected boolean m_Found = false;

        public ViewListener(DualListSelector m_serversChoice) {
            this.m_choice = m_serversChoice;
        }

        public void MdObjectCreated(MdEvent event, String strID) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(strID);
            this._onCreate(list);
        }

        public void MdObjectsCreated(MdEvent event, List idList) {
            this._onCreate(idList);
        }

        public void MdObjectDeleted(MdEvent event, String strID) {
        }

        protected void _onCreate(List idList) {
            try {
                Object object;
                int i;
                Vector sourceDataList = new Vector();
                Vector targetDataList = new Vector();
                ListModel sourceListModel = this.m_choice.getModel();
                ListModel targetListModel = this.m_choice.getTargetModel();
                for (i = 0; i < sourceListModel.getSize(); ++i) {
                    object = sourceListModel.getElementAt(i);
                    sourceDataList.add(object);
                }
                for (i = 0; i < targetListModel.getSize(); ++i) {
                    object = targetListModel.getElementAt(i);
                    targetDataList.add(object);
                }
                for (i = 0; i < idList.size(); ++i) {
                    String strID = (String)idList.get(i);
                    CMetadata meta = Workspace.getMdFactory().getObject(strID);
                    if (!meta.getCMetadataType().equals("ServerComponent") || this.m_Found) continue;
                    Root root = (Root)meta;
                    ConnectSpawnerServersView.this.m_dataList.removeAllElements();
                    List itemsList = null;
                    String strType = "ServerComponent";
                    String strTemplate = "<ServerComponent><ServiceTypes/></ServerComponent>";
                    String clsId = "028e4060-d545-11d5-880d-aa0004006d06";
                    String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + clsId + "'][AssociatedMachine/*[@Name='" + ConnectSpawnerServersView.this.m_strHost + "']]\"/>";
                    String strOptions = strTemplate + strSelect;
                    int flags = 8588;
                    try {
                        itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(ConnectSpawnerServersView.this.m_server.getDeployedComponent().getObjectStore(), ConnectSpawnerServersView.this.m_server.getContext(), strType, flags, strOptions);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                        return;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    Vector listData = new Vector();
                    listData.addAll(itemsList);
                    try {
                        AssociationList serversList = ConnectSpawnerServersView.this.m_server.getDeployedComponent().getUsedByComponents();
                        for (int serverIndex = 0; serverIndex < ConnectSpawnerServersView.this.m_serversList.size(); ++serverIndex) {
                            ServerComponent serverComponent = (ServerComponent)ConnectSpawnerServersView.this.m_serversList.get(serverIndex);
                            if (serversList.contains(serverComponent) || serverComponent.getUsingComponents().size() <= 0) continue;
                            listData.remove(serverComponent);
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    for (int j = 0; j < listData.size(); ++j) {
                        Root itemRoot = (Root)listData.get(j);
                        if (!itemRoot.getFQID().equals(root.getFQID())) continue;
                        targetDataList.add(itemRoot);
                        sourceDataList.remove(itemRoot);
                        this.m_Found = true;
                    }
                    DefaultListModel sourceModel = new DefaultListModel();
                    for (int index = 0; index < sourceDataList.size(); ++index) {
                        sourceModel.add(index, sourceDataList.get(index));
                    }
                    sourceListModel = null;
                    this.m_choice.setModel(sourceModel);
                    DefaultListModel targetModel = new DefaultListModel();
                    for (int index = 0; index < targetDataList.size(); ++index) {
                        targetModel.add(index, targetDataList.get(index));
                    }
                    targetListModel = null;
                    this.m_choice.setTargetModel(targetModel);
                }
                if (this.m_Found) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)this);
                }
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }
}

