/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.DBSchema;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CompletionView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Library m_library;
    protected DBSchema m_schema;
    protected WATextArea m_titleText;
    protected WATextArea m_summaryText;
    protected JScrollPane m_summaryPane;
    private static final WAdminResource bundle = WAdminResource.getBundle(CompletionView.class);

    public CompletionView(Server server) {
        this.m_server = server;
        this._initialize();
        this._layoutWidgets();
    }

    public CompletionView(Library library) {
        this.m_library = library;
        this._initialize();
        this._layoutWidgets();
    }

    public CompletionView(DBSchema schema) {
        this.m_schema = schema;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (bSaveToModel) {
                ((WAStandardDialog)this.getTopLevelAncestor()).setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (this.m_server != null) {
                        this.onServerCompletion();
                    }
                    if (this.m_library != null) {
                        this.onLibraryCompletion();
                    }
                    if (this.m_schema != null) {
                        this.onSchemaCompletion();
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
                ((WAStandardDialog)this.getTopLevelAncestor()).setCursor(Cursor.getPredefinedCursor(0));
            } else {
                AssociationList serversList;
                DeployedDataPackage ddp;
                this.m_summaryText.setText("");
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                if (this.m_server != null) {
                    List transformationsList;
                    DeployedComponent deployedComponent = (DeployedComponent)parent.getWizardData("DeployedComponent");
                    this.m_summaryText.setText(bundle.getString("CompletionView.ServerLabel.txt") + "\n\t" + deployedComponent.getName() + "\n\n");
                    List sourceConnectionsList = (List)parent.getWizardData("SourceConnections");
                    if (sourceConnectionsList != null) {
                        this.m_summaryText.append(bundle.getString("CompletionView.ConnectionsLabel.txt"));
                        for (int i = 0; i < sourceConnectionsList.size(); ++i) {
                            Connection connection = (Connection)sourceConnectionsList.get(i);
                            this.m_summaryText.append("\n\t" + connection.getName());
                        }
                        this.m_summaryText.append("\n\n");
                    }
                    if ((transformationsList = (List)parent.getWizardData("Transformations")) != null) {
                        this.m_summaryText.append(bundle.getString("CompletionView.TransformationsLabel.txt"));
                        for (int i = 0; i < transformationsList.size(); ++i) {
                            Transformation transformation = (Transformation)transformationsList.get(i);
                            this.m_summaryText.append("\n\t" + transformation.getName());
                        }
                    }
                }
                if (this.m_library != null) {
                    ddp = (DeployedDataPackage)parent.getWizardData("DeployedDataPackage");
                    this.m_summaryText.setText(bundle.getString("CompletionView.LibraryLabel.txt") + "\n\t" + ddp.getName() + "\n\n");
                    try {
                        serversList = ddp.getDeployedComponents();
                        if (serversList != null) {
                            this.m_summaryText.append(bundle.getString("CompletionView.AssignedToServersLabel.txt"));
                            for (int i = 0; i < serversList.size(); ++i) {
                                DeployedComponent dc = (DeployedComponent)serversList.get(i);
                                this.m_summaryText.append("\n\t" + dc.getName());
                            }
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
                if (this.m_schema != null) {
                    ddp = (DeployedDataPackage)parent.getWizardData("DatabaseSchema");
                    this.m_summaryText.setText(bundle.getString("CompletionView.SchemaLabel.txt") + "\n\t" + ddp.getName() + "\n\n");
                    try {
                        serversList = ddp.getDeployedComponents();
                        if (serversList != null) {
                            this.m_summaryText.append(bundle.getString("CompletionView.AssignedToServersLabel.txt"));
                            for (int i = 0; i < serversList.size(); ++i) {
                                DeployedComponent dc = (DeployedComponent)serversList.get(i);
                                this.m_summaryText.append("\n\t" + dc.getName());
                            }
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean validateData() {
        return true;
    }

    public void onNext() {
    }

    public void onBack() {
        this.m_summaryText.setText("");
        try {
            if (this.m_library != null) {
                this.m_library.getDeployedDataPackage().getDeployedComponents().removeAllElements();
            }
            if (this.m_schema != null) {
                this.m_schema.getSchema().getDeployedComponents().removeAllElements();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onServerCompletion() throws MdException, RemoteException {
        int i;
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        DeployedComponent deployedComponent = (DeployedComponent)parent.getWizardData("DeployedComponent");
        List sourceConnectionsList = (List)parent.getWizardData("SourceConnections");
        List transformationsList = (List)parent.getWizardData("Transformations");
        Prototype deployedComponentPrototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
        Machine machine = null;
        for (i = 0; sourceConnectionsList != null && i < sourceConnectionsList.size(); ++i) {
            Connection sourceConnection = (Connection)sourceConnectionsList.get(i);
            if (sourceConnection == null) continue;
            deployedComponent.getSourceConnections().add((Object)sourceConnection);
            machine = this.m_server.getMachine(sourceConnection);
        }
        for (i = 0; transformationsList != null && i < transformationsList.size(); ++i) {
            Transformation transformation = (Transformation)transformationsList.get(i);
            if (transformation == null) continue;
            if (deployedComponent.getClassIdentifier().equalsIgnoreCase("IOM Spawner")) {
                deployedComponent.getInitProcesses().add((Object)transformation);
                continue;
            }
            deployedComponent.getTargetTransformations().add((Object)transformation);
        }
        String strDCClassID = deployedComponent.getClassIdentifier();
        for (int i2 = 0; transformationsList != null && i2 < transformationsList.size(); ++i2) {
            Transformation transformation = (Transformation)transformationsList.get(i2);
            if (transformation == null || strDCClassID.equalsIgnoreCase("IOM Spawner")) continue;
            AssociationList transformSourcesList = transformation.getTransformationSources();
            String strClassIdentifier = strDCClassID;
            for (int j = 0; j < transformSourcesList.size(); ++j) {
                Root tsRoot = (Root)transformSourcesList.get(j);
                if (!(tsRoot instanceof DeployedComponent)) continue;
                DeployedComponent dc = (DeployedComponent)tsRoot;
                if (!strDCClassID.equalsIgnoreCase(dc.getClassIdentifier())) {
                    strClassIdentifier = dc.getClassIdentifier();
                }
                dc.setClassIdentifier("", 1);
            }
            deployedComponent.setClassIdentifier(strClassIdentifier, 1);
        }
        if (machine != null) {
            deployedComponent.setAssociatedMachine(machine);
        }
        deployedComponent.setUsingPrototype((Root)deployedComponentPrototype);
        this.m_server.setDeployedComponent(deployedComponent);
        this.m_server.persist();
        MdObjectStore objectStore = (MdObjectStore)parent.getWizardData("OBJECTSTORE");
        objectStore.dispose();
    }

    public void onLibraryCompletion() throws MdException, RemoteException {
        this.m_library.persist();
    }

    public void onSchemaCompletion() throws MdException, RemoteException {
        this.m_schema.persist();
    }

    protected void _initialize() {
        this.setName(bundle.getString("CompletionView.TabName.txt"));
        String type = null;
        if (this.m_server != null) {
            type = "server";
        }
        if (this.m_library != null) {
            type = "library";
        }
        if (this.m_schema != null) {
            type = "schema";
        }
        this.m_titleText = new WATextArea(bundle.formatString("CompletionView.WizardTitle.fmt.txt", (Object)type));
        this.m_titleText.setEditable(false);
        this.m_titleText.setLineWrap(true);
        this.m_titleText.setWrapStyleWord(true);
        this.m_titleText.setBorder(null);
        this.m_titleText.setBackground(this.getBackground());
        this.m_summaryText = new WATextArea();
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setLineWrap(true);
        this.m_summaryText.setWrapStyleWord(true);
        this.m_summaryText.setBackground(this.getBackground());
        this.m_summaryPane = new JScrollPane((Component)this.m_summaryText, 20, 30);
        this.m_summaryPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_summaryPane.setPreferredSize(new Dimension(315, 400));
        this.m_summaryPane.setMinimumSize(new Dimension(315, 400));
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_titleText, gbc);
        this.add((Component)this.m_titleText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_summaryPane, gbc);
        this.add(this.m_summaryPane);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

