/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.Library;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssignLibraryView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Library m_library;
    protected int m_type;
    protected String m_reposID;
    protected DualListSelector m_list;
    protected WATextArea m_descText;
    protected List m_serversList;
    protected Vector m_dataList;
    protected Vector prevSelectedValues;
    protected boolean m_selectionChanged;
    protected ListSelectionListener sourceSelectionListener;
    protected ListSelectionListener targetSelectionListener;
    protected ListDataListener targetListDataListener;
    private static final WAdminResource bundle = WAdminResource.getBundle(AssignLibraryView.class);

    public AssignLibraryView(Library library, int type) {
        super(bundle.getString("AssignLibraryView.LibraryDescription.txt"));
        this.setName(bundle.getString("AssignLibraryView.TabName.txt"));
        this.m_library = library;
        this.m_type = type;
        this.m_reposID = library.getContext();
        this._initialize();
        this._layoutWidgets();
    }

    public AssignLibraryView(String reposID) {
        super(bundle.getString("AssignLibraryView.WizardDescription.txt"));
        this.m_library = null;
        this.m_reposID = reposID;
        this.m_type = 0;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (bSaveToModel) {
                if (this.m_type != 0 && this.m_selectionChanged) {
                    this.assignServersToLibrary();
                }
            } else {
                WAWizardDialog parent;
                Hashtable propertiesTable;
                this.m_dataList.removeAllElements();
                this.m_serversList.clear();
                Vector<String> assignedList = new Vector<String>(1);
                Vector alreadyAssignedServers = new Vector(1);
                boolean bIsRemoteLibrary = false;
                this.m_selectionChanged = false;
                String strType = bundle.getString("AssignLibraryView.DeployedComponent.Type.notrans");
                String strTemplate = bundle.getString("AssignLibraryView.DeployedComponent.Template.notrans");
                String strSelect = bundle.getString("AssignLibraryView.DeployedComponent.Select.notrans");
                String strOptions = strTemplate + strSelect;
                int flags = 8604;
                try {
                    int i;
                    MdObjectStore oStore = null;
                    if (this.m_library == null) {
                        if (this.m_type == 0) {
                            WAWizardDialog parent2 = (WAWizardDialog)this.getTopLevelAncestor();
                            oStore = (MdObjectStore)parent2.getWizardData("OBJECTSTORE");
                            this.m_serversList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)oStore, this.m_reposID, strType, flags, strOptions);
                        } else {
                            Workspace.getDefaultLogger().error((Object)"Library is null, can't retrieve MdObjectStore");
                        }
                    } else {
                        oStore = this.m_library.getStore();
                        this.m_serversList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)oStore, this.m_reposID, strType, flags, strOptions);
                    }
                    for (i = 0; i < this.m_serversList.size(); ++i) {
                        ServerContext serverCont;
                        AssociationList logicalServerList;
                        ServerComponent serverComp = (ServerComponent)this.m_serversList.get(i);
                        if (!(serverComp instanceof ServerContext) || (logicalServerList = (serverCont = (ServerContext)serverComp).getUsingComponents()).size() != 1 || !((LogicalServer)logicalServerList.get(0)).getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) continue;
                        this.m_serversList.remove(serverComp);
                        --i;
                    }
                    if (this.m_library != null) {
                        alreadyAssignedServers = this.m_library.getDeployedDataPackage().getDeployedComponents();
                        if (this.m_library.getDeployedDataPackage() instanceof SASLibrary && ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine().startsWith("REMOTE")) {
                            bIsRemoteLibrary = true;
                        }
                    } else {
                        alreadyAssignedServers = this.prevSelectedValues;
                    }
                    block6: for (i = 0; i < this.m_serversList.size(); ++i) {
                        DeployedComponent deployedComponent = (DeployedComponent)this.m_serversList.get(i);
                        if (bIsRemoteLibrary && deployedComponent.getClassIdentifier().equalsIgnoreCase("SHARE")) continue;
                        this.m_dataList.add(deployedComponent.getName());
                        for (int j = 0; j < alreadyAssignedServers.size(); ++j) {
                            DeployedComponent assignedServer = (DeployedComponent)alreadyAssignedServers.get(j);
                            if (!assignedServer.equals(deployedComponent)) continue;
                            String serverName = assignedServer.getName();
                            if (this.m_dataList.contains(serverName)) {
                                this.m_dataList.remove(serverName);
                            }
                            if (assignedList.contains(serverName)) continue block6;
                            assignedList.add(serverName);
                            continue block6;
                        }
                    }
                }
                catch (MdException mde) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
                }
                catch (RemoteException re) {
                    String msg = re.getLocalizedMessage();
                    Workspace.getDefaultLogger().error((Object)msg);
                    MessageUtil.displayMessage((String)msg, (int)0);
                }
                if (this.m_type == 0 && (propertiesTable = (Hashtable)(parent = (WAWizardDialog)this.getTopLevelAncestor()).getWizardData("Properties")) != null) {
                    Enumeration e = propertiesTable.keys();
                    while (e.hasMoreElements()) {
                        Object key = e.nextElement();
                        if (!(key instanceof SASLibrary)) continue;
                        SASLibrary lib = (SASLibrary)key;
                        Hashtable[] libTableArray = (Hashtable[])propertiesTable.get(lib);
                        for (int index = 0; index < libTableArray.length; ++index) {
                            Object defaultValue;
                            Hashtable libTable = libTableArray[index];
                            String strDC = (String)libTable.get("AssociationName");
                            if (strDC == null || !strDC.equals("DeployedComponents") || (defaultValue = libTable.get("DefaultValue")) == null) continue;
                            for (int serverIndex = 0; serverIndex < this.m_serversList.size(); ++serverIndex) {
                                DeployedComponent deployedComponent = (DeployedComponent)this.m_serversList.get(serverIndex);
                                if (!deployedComponent.getFQID().equals(((Root)defaultValue).getFQID())) continue;
                                String dcName = deployedComponent.getName();
                                if (this.m_dataList.contains(dcName)) {
                                    this.m_dataList.remove(dcName);
                                }
                                if (assignedList.contains(dcName)) continue;
                                assignedList.add(dcName);
                                this.m_selectionChanged = true;
                            }
                        }
                    }
                }
                if (this.targetListDataListener != null) {
                    this.m_list.getTargetModel().removeListDataListener(this.targetListDataListener);
                }
                DefaultListModel sourceModel = new DefaultListModel();
                for (int index = 0; index < this.m_dataList.size(); ++index) {
                    sourceModel.add(index, this.m_dataList.get(index));
                }
                this.m_list.setModel(sourceModel);
                DefaultListModel targetModel = new DefaultListModel();
                for (int index = 0; index < assignedList.size(); ++index) {
                    targetModel.add(index, assignedList.get(index));
                }
                this.m_list.setTargetModel(targetModel);
                this.targetListDataListener = new ListDataListener(){

                    @Override
                    public void contentsChanged(ListDataEvent event) {
                        AssignLibraryView.this.m_selectionChanged = true;
                    }

                    @Override
                    public void intervalAdded(ListDataEvent event) {
                        AssignLibraryView.this.m_selectionChanged = true;
                    }

                    @Override
                    public void intervalRemoved(ListDataEvent event) {
                        AssignLibraryView.this.m_selectionChanged = true;
                    }
                };
                this.m_list.getTargetModel().addListDataListener(this.targetListDataListener);
            }
            return false;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
            return false;
        }
    }

    private void onListSelectionChanged(JList selList) {
        try {
            String strServer = "";
            if (!selList.getSelectionModel().isSelectionEmpty()) {
                strServer = (String)selList.getSelectedValue();
            }
            DeployedComponent dc = null;
            if (strServer != null) {
                for (int i = 0; i < this.m_serversList.size() && !(dc = (DeployedComponent)this.m_serversList.get(i)).getName().equals(strServer); ++i) {
                }
            }
            this.m_descText.setText(dc != null ? dc.getDesc() : "");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
    }

    public boolean validateData() {
        boolean bValidated = true;
        Vector<DeployedComponent> serversToAssign = new Vector<DeployedComponent>();
        if (this.m_selectionChanged && this.m_library != null) {
            try {
                ListModel targetListModel = this.m_list.getTargetModel();
                block2: for (int tIndex = 0; tIndex < targetListModel.getSize(); ++tIndex) {
                    String strServer = (String)targetListModel.getElementAt(tIndex);
                    for (int j = 0; j < this.m_serversList.size(); ++j) {
                        DeployedComponent dc = (DeployedComponent)this.m_serversList.get(j);
                        if (!dc.getName().equals(strServer)) continue;
                        serversToAssign.add(dc);
                        continue block2;
                    }
                }
                if (!Library.validateLibraryName(this.m_library.getDeployedDataPackage().getId(), this.m_library.getDeployedDataPackage().getName(), null, serversToAssign)) {
                    bValidated = false;
                }
            }
            catch (RemoteException rex) {
                String msg = rex.getLocalizedMessage();
                Workspace.getDefaultLogger().error((Object)msg);
                MessageUtil.displayMessage((String)msg, (int)0);
                bValidated = false;
            }
        }
        return bValidated;
    }

    public void onNext() {
        if (this.m_selectionChanged) {
            this.assignServersToLibrary();
        }
        this.m_selectionChanged = false;
        if (this.m_library != null) {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            parent.replaceWizardData("DeployedDataPackage", (Object)this.m_library.getDeployedDataPackage());
        }
    }

    public void onBack() {
        if (this.m_selectionChanged) {
            this.assignServersToLibrary();
        }
        this.prevSelectedValues = new Vector(1);
        ListModel targetListModel = this.m_list.getTargetModel();
        int targetListSize = targetListModel.getSize();
        if (this.m_library == null && targetListSize > 0) {
            block2: for (int i = 0; i < targetListSize; ++i) {
                String strServer = (String)targetListModel.getElementAt(i);
                for (int j = 0; j < this.m_serversList.size(); ++j) {
                    DeployedComponent dc = (DeployedComponent)this.m_serversList.get(j);
                    try {
                        if (!dc.getName().equals(strServer)) continue;
                        this.prevSelectedValues.add(dc);
                        continue block2;
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                    }
                }
            }
        }
    }

    public String createFinishString() {
        String strFinish = "";
        ListModel targetListModel = this.m_list.getTargetModel();
        int targetListSize = targetListModel.getSize();
        if (targetListSize == 0 || this.m_library == null) {
            return strFinish;
        }
        strFinish = strFinish + bundle.getString("AssignLibraryView.FinishString.txt") + "\n\t";
        for (int i = 0; i < targetListSize; ++i) {
            String strServer = (String)targetListModel.getElementAt(i);
            strFinish = strFinish + strServer;
            strFinish = strFinish + (i < targetListSize - 1 ? "\n\t" : "\n");
        }
        return strFinish;
    }

    public void saveSettingsAndCleanUp() {
        if (this.targetListDataListener != null) {
            this.m_list.getTargetModel().removeListDataListener(this.targetListDataListener);
        }
        if (this.sourceSelectionListener != null) {
            ((JList)this.m_list.getSourceComponent()).removeListSelectionListener(this.sourceSelectionListener);
        }
        if (this.targetSelectionListener != null) {
            ((JList)this.m_list.getTargetComponent()).removeListSelectionListener(this.targetSelectionListener);
        }
    }

    public void setEditable(boolean isEditable) {
        super.setEditable(isEditable);
        this.m_list.setEnabled(isEditable);
    }

    private void assignServersToLibrary() {
        Vector<DeployedComponent> assignedServers = new Vector<DeployedComponent>(1);
        Vector selectedValues = new Vector(1);
        boolean updateNeeded = false;
        ListModel targetListModel = this.m_list.getTargetModel();
        for (int tIndex = 0; tIndex < targetListModel.getSize(); ++tIndex) {
            selectedValues.add(targetListModel.getElementAt(tIndex));
        }
        block6: for (int i = 0; i < selectedValues.size(); ++i) {
            String strServer = (String)selectedValues.get(i);
            for (int j = 0; j < this.m_serversList.size(); ++j) {
                DeployedComponent dc = (DeployedComponent)this.m_serversList.get(j);
                try {
                    if (!dc.getName().equals(strServer)) continue;
                    if (this.m_library != null) {
                        assignedServers.add(dc);
                        updateNeeded = true;
                        continue block6;
                    }
                    if (this.m_type != 0) continue;
                    WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                    parent.replaceWizardData("APPID", (Object)dc.getId());
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                }
            }
        }
        if (selectedValues.size() == 0) {
            Object selectedServers = null;
            if (this.m_library == null) {
                selectedServers = new Vector(1);
            } else {
                try {
                    selectedServers = this.m_library.getDeployedDataPackage().getDeployedComponents();
                }
                catch (MdException mde) {
                    Workspace.getDefaultLogger().error((Object)mde.getLocalizedMessage());
                    selectedServers = new Vector(1);
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                    selectedServers = new Vector(1);
                }
            }
            if (selectedServers.size() > 0) {
                updateNeeded = true;
            }
        }
        if (updateNeeded) {
            this.m_library.assignToServer(assignedServers);
        }
    }

    protected void _initialize() {
        this.setHelpTopic("libwiz_5");
        this.m_serversList = new Vector();
        this.m_dataList = new Vector();
        this.prevSelectedValues = new Vector();
        this.m_list = new DualListSelector();
        this.m_list.setSourceLabel(bundle.getString("AssignLibraryView.AvailableServersLabel.txt"));
        this.m_list.setTargetLabel(bundle.getString("AssignLibraryView.AssignedServersLabel.txt"));
        this.sourceSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                AssignLibraryView.this.onListSelectionChanged((JList)event.getSource());
            }
        };
        ((JList)this.m_list.getSourceComponent()).addListSelectionListener(this.sourceSelectionListener);
        this.targetSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                AssignLibraryView.this.onListSelectionChanged((JList)event.getSource());
            }
        };
        ((JList)this.m_list.getTargetComponent()).addListSelectionListener(this.targetSelectionListener);
        this.m_descText = new WATextArea();
        this.m_descText.setEditable(false);
        this.m_descText.setLineWrap(true);
        this.m_descText.setWrapStyleWord(true);
        this.m_descText.setBorder(null);
        this.m_descText.setBackground(this.getBackground());
    }

    protected void _layoutWidgets() {
        GridBagConstraints gbc;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int y = 0;
        if (this.m_type == 1 || this.m_type == 2) {
            WATextArea descArea = new WATextArea(bundle.getString("AssignLibraryView.LibraryDescription.txt"));
            descArea.setBehavior(1);
            descArea.setLineWrap(true);
            descArea.setWrapStyleWord(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = this.m_type == 1 ? new Insets(0, 12, 0, 12) : new Insets(0, 0, 12, 0);
            gridBagLayout.setConstraints((Component)descArea, gbc);
            this.add((Component)descArea);
            ++y;
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        if (this.m_type == 1) {
            gbc.insets = new Insets(12, 12, 0, 12);
        }
        gridBagLayout.setConstraints((Component)this.m_list, gbc);
        this.add((Component)this.m_list);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = ++y;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_descText, gbc);
        this.add((Component)this.m_descText);
    }
}

