/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.plugins.AboutInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected AboutInterface m_info;
    protected String m_className;
    protected JLabel nameLabel;
    protected JLabel versionLabel;
    protected WATextArea copyrightTextArea;
    protected JLabel iconLabel;
    protected WATextArea descriptionTextArea;
    protected WATextArea infoTextArea;
    protected JScrollPane infoScrollPane;
    protected JList infoList;
    protected WAPanel mainPanel;
    protected Vector additionalInfo;
    protected JButton okBtn;
    private static final WAdminResource bundle = WAdminResource.getBundle(AboutDialog.class);

    public AboutDialog(Frame frame, AboutInterface info, String name, String className) {
        super(frame, true);
        this.setTitle(bundle.formatString("AboutDialog.Title.fmt.txt", (Object)name));
        this.setDefaultCloseOperation(2);
        this.m_info = info;
        this.m_className = className;
        this._initialize();
        this._layoutWidgets();
        this.setResizable(false);
        if (this.infoScrollPane.isVisible()) {
            this.setSize(new Dimension(500, 350));
        } else {
            this.setSize(new Dimension(500, 300));
        }
        WorkspaceUtil.center((Window)this);
    }

    protected void _initialize() {
        this.mainPanel = new WAPanel();
        this.mainPanel.setPreferredSize(new Dimension(250, 325));
        this.mainPanel.setMinimumSize(new Dimension(250, 325));
        this.iconLabel = new JLabel();
        this.iconLabel.setIcon(this.m_info.getImage());
        this.iconLabel.setMaximumSize(new Dimension(32, 32));
        this.nameLabel = new JLabel("<html>" + this.m_info.getFormalName() + "<br>" + this.m_className + "</html>");
        this.versionLabel = new JLabel(bundle.formatString("AboutDialog.Version.fmt.txt", (Object)this.m_info.getVersion()));
        this.copyrightTextArea = new WATextArea(bundle.formatString("AboutDialog.Copyright.fmt.txt", (Object)this.m_info.getCopyright()));
        this.copyrightTextArea.setBehavior(1);
        this.copyrightTextArea.setLineWrap(true);
        this.copyrightTextArea.setWrapStyleWord(true);
        this.copyrightTextArea.setFont(this.nameLabel.getFont());
        this.descriptionTextArea = new WATextArea(this.m_info.getDescription());
        this.descriptionTextArea.setBehavior(1);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setFont(this.nameLabel.getFont());
        this.okBtn = new JButton(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.OK.txt")));
        this.okBtn.setPreferredSize(new Dimension(120, 30));
        this.okBtn.setMinimumSize(new Dimension(120, 30));
        this.okBtn.addActionListener(this);
        this.infoScrollPane = new JScrollPane(20, 30);
        this.infoScrollPane.setPreferredSize(new Dimension(75, 100));
        this.infoScrollPane.setMinimumSize(new Dimension(75, 100));
        this.infoScrollPane.getViewport().setBackground(Color.white);
        this.infoScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.additionalInfo = this.m_info.getAdditionalInfo();
        if (this.additionalInfo != null && this.additionalInfo.size() > 0) {
            Object tempObj = this.additionalInfo.get(0);
            if (this.additionalInfo.size() == 1 && tempObj instanceof String) {
                this.infoTextArea = new WATextArea((String)tempObj);
                this.infoTextArea.setEditable(false);
                this.infoTextArea.setLineWrap(true);
                this.infoTextArea.setWrapStyleWord(true);
                this.infoTextArea.setCaretPosition(0);
                this.infoScrollPane.getViewport().add((Component)this.infoTextArea);
            } else {
                this.infoList = new JList();
                DefaultListModel listModel = new DefaultListModel();
                for (int i = 0; i < this.additionalInfo.size(); ++i) {
                    tempObj = this.additionalInfo.get(i);
                    if (tempObj instanceof String) {
                        listModel.addElement(tempObj);
                    }
                    if (listModel.getSize() <= 0) continue;
                    this.infoList.setModel(listModel);
                    this.infoScrollPane.getViewport().add(this.infoList);
                }
            }
        } else {
            this.infoScrollPane.setVisible(false);
        }
    }

    protected void _layoutWidgets() {
        GridBagLayout gbl = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(12, 12, 6, 12);
        gbl.setConstraints(this.iconLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(12, 0, 6, 12);
        gbl.setConstraints(this.nameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 0, 0, 12);
        gbl.setConstraints(this.versionLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 12, 12);
        gbl.setConstraints((Component)this.copyrightTextArea, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 12, 12);
        gbl.setConstraints((Component)this.descriptionTextArea, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 12, 12);
        if (this.infoScrollPane.isVisible()) {
            gbl.setConstraints(this.infoScrollPane, gbc);
            this.mainPanel.add((Component)this.infoScrollPane);
        } else {
            JPanel blankPanel = new JPanel();
            gbl.setConstraints(blankPanel, gbc);
            this.mainPanel.add((Component)blankPanel);
        }
        JSeparator hsep = new JSeparator(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 12, 0, 12);
        gbl.setConstraints(hsep, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(6, 0, 6, 12);
        gbl.setConstraints(this.okBtn, gbc);
        this.mainPanel.add((Component)this.iconLabel);
        this.mainPanel.add((Component)this.nameLabel);
        this.mainPanel.add((Component)this.versionLabel);
        this.mainPanel.add((Component)this.copyrightTextArea);
        this.mainPanel.add((Component)this.descriptionTextArea);
        this.mainPanel.add((Component)hsep);
        this.mainPanel.add((Component)this.okBtn);
        this.setContentPane((Container)this.mainPanel);
        EscapeKeyListener keyKA = new EscapeKeyListener(this);
        AboutDialog.addKeyListenersToAll(this, keyKA);
    }

    private static void addKeyListenersToAll(Container container, KeyAdapter keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            components[index].addKeyListener(keyHandler);
            if (!(components[index] instanceof Container)) continue;
            AboutDialog.addKeyListenersToAll((Container)components[index], keyHandler);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okBtn) {
            this.dispose();
        }
    }

    class EscapeKeyListener
    extends KeyAdapter {
        JDialog m_me;

        public EscapeKeyListener(JDialog me) {
            this.m_me = me;
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 27) {
                this.m_me.dispose();
            }
        }
    }
}

