/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.MetadataSearchEvent;
import com.sas.workspace.mgmt.MetadataSearchModel;
import com.sas.workspace.mgmt.MetadataSearchOperator;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoginSearchModel
extends MetadataSearchModel {
    private AuthenticationDomain m_authDomain = null;
    private String m_strUserIDOperator = MetadataSearchOperator.COND_CONTAINS;
    private String m_strUserID = null;
    private boolean m_bNoAssociatedDomain = false;
    List m_loginList = null;
    protected static WAdminResource m_bundle = WAdminResource.getBundle(LoginSearchModel.class);

    public LoginSearchModel(IOMI iOMI, MdObjectStore store, String reposID) {
        super(iOMI, store, reposID);
    }

    public AuthenticationDomain getAuthDomain() {
        return this.m_authDomain;
    }

    public void setAuthDomain(AuthenticationDomain domain) {
        this.m_authDomain = domain;
    }

    public boolean isNoAssociatedAuthDomain() {
        return this.m_bNoAssociatedDomain;
    }

    public void setNoAssociatedAuthDomain(boolean flag) {
        this.m_bNoAssociatedDomain = flag;
    }

    public void setUserIDOperator(String operator) {
        if (operator == null) {
            throw new NullPointerException("Argument 'operator' should not be null!");
        }
        if (!operator.equalsIgnoreCase(MetadataSearchOperator.COND_CONTAINS) && !operator.equalsIgnoreCase(MetadataSearchOperator.COND_EQUALS)) {
            throw new IllegalArgumentException("Argument 'operator' should be one of the following: MetadataSearchOperator.COND_CONTAINS, MetadataSearchOperator.COND_EQUALS");
        }
        this.m_strUserIDOperator = operator;
    }

    public String getUserID() {
        return this.m_strUserID;
    }

    public void setUserID(String userID) {
        this.m_strUserID = userID;
    }

    @Override
    public void search() {
        this.m_loginList = null;
        this.retrieveResults();
    }

    private synchronized void retrieveResults() {
        Vector loginList = new Vector();
        try {
            String strQLoginType = "<XMLSELECT search=\"Login";
            String strQUserID = "";
            if (this.getUserID() != null) {
                strQUserID = "[@UserID " + this.m_strUserIDOperator + " '" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(this.getUserID()) + "']";
            }
            String strQAuthDomain = "";
            if (this.getAuthDomain() != null) {
                strQAuthDomain = "[Domain/AuthenticationDomain[@Name='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(this.getAuthDomain().getName()) + "']]";
            }
            String strQEnd = "\" />";
            String strTemplate = "<TEMPLATES><Login><Domain/></Login></TEMPLATES>";
            String strXMLSelect = strQLoginType + strQUserID + strQAuthDomain + strQEnd;
            String strOptions = strTemplate + strXMLSelect;
            int flags = 8604;
            MetadataSearchEvent executingEvent = new MetadataSearchEvent(this, 1, m_bundle.getString("LoginSearchModel.Executing.txt"), loginList);
            this.fireSearchPerformed(executingEvent);
            StringHolder outXML = new StringHolder();
            this.getIOMI().GetMetadataObjects(this.getRepositoryID(), "Login", outXML, Workspace.getMdFactory().getOMIUtil().getNamespace(), flags, strOptions);
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(outXML.value);
            Vector resultsList = new Vector();
            this.parseLoginResults(doc, resultsList);
            Collections.sort(resultsList);
            if (this.isNoAssociatedAuthDomain()) {
                for (int pairIndex = 0; pairIndex < resultsList.size(); ++pairIndex) {
                    LoginDomainPair retPair = (LoginDomainPair)resultsList.get(pairIndex);
                    if (retPair.getAuthDomain().length() <= 0) continue;
                    resultsList.remove(retPair);
                    --pairIndex;
                }
            }
            if (resultsList != null) {
                loginList.addAll(resultsList);
                MetadataSearchEvent successEvent = new MetadataSearchEvent(this, 0, m_bundle.getString("LoginSearchModel.Success.txt"), loginList);
                this.fireSearchPerformed(successEvent);
            }
        }
        catch (MdException exc) {
            MetadataSearchEvent failureEvent = new MetadataSearchEvent(this, 2, exc.getLocalizedMessage(), loginList);
            this.fireSearchPerformed(failureEvent);
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (GenericError err) {
            MetadataSearchEvent failureEvent = new MetadataSearchEvent(this, 2, err.getLocalizedMessage(), loginList);
            this.fireSearchPerformed(failureEvent);
        }
    }

    private void parseLoginResults(Node node, List results) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.parseLoginResults(children.item(childIndex), results);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Login")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strUserID = childNodeMap.getNamedItem("UserID").getNodeValue();
                    Vector domainList = new Vector();
                    this.parseDomainForLogin(node, domainList);
                    String strDomain = (String)domainList.get(0);
                    LoginDomainPair pair = new LoginDomainPair(strUserID, strDomain);
                    results.add(pair);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.parseLoginResults(children.item(childIndex), results);
                }
                break;
            }
        }
    }

    private void parseDomainForLogin(Node node, List results) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.parseDomainForLogin(children.item(childIndex), results);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Domain")) {
                    if (!node.hasChildNodes()) {
                        results.add("");
                        break;
                    }
                    this.parseDomainForLogin(node.getFirstChild(), results);
                    break;
                }
                if (node.getNodeName().equals("AuthenticationDomain")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                    results.add(strName);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.parseDomainForLogin(children.item(childIndex), results);
                }
                break;
            }
        }
    }

    public void setResults(List results) {
        try {
            if (results == null) {
                throw new NullPointerException("Argument 'results' should not be null!");
            }
            Vector loginList = new Vector();
            for (int resultIndex = 0; resultIndex < results.size(); ++resultIndex) {
                if (!(results.get(resultIndex) instanceof LoginDomainPair)) {
                    throw new IllegalArgumentException("Argument 'results' should be of type LoginSearchModel.LoginDomainPair");
                }
                LoginDomainPair resultPair = (LoginDomainPair)results.get(resultIndex);
                String strQLoginType = "<XMLSELECT search=\"Login";
                String strQUserID = "";
                if (resultPair.getUserID() != null) {
                    strQUserID = "[@UserID = '" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(resultPair.getUserID()) + "']";
                }
                String strQAuthDomain = "";
                if (resultPair.getAuthDomain() != null && resultPair.getAuthDomain().length() > 0) {
                    strQAuthDomain = "[Domain/AuthenticationDomain[@Name='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(resultPair.getAuthDomain()) + "']]";
                }
                String strQEnd = "\" />";
                String strTemplate = "<TEMPLATES><Login><Domain/></Login></TEMPLATES>";
                String strXMLSelect = strQLoginType + strQUserID + strQAuthDomain + strQEnd;
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                try {
                    List retLoginList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.getObjectStore(), this.getRepositoryID(), "Login", flags, strOptions, false);
                    if (resultPair.getAuthDomain() != null && resultPair.getAuthDomain().length() == 0) {
                        for (int loginIndex = 0; loginIndex < retLoginList.size(); ++loginIndex) {
                            Login retLogin = (Login)retLoginList.get(loginIndex);
                            if (retLogin.getDomain() == null) continue;
                            retLoginList.remove(retLogin);
                            --loginIndex;
                        }
                    }
                    loginList.addAll(retLoginList);
                    continue;
                }
                catch (MdException exc) {
                    continue;
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            this.m_loginList = new Vector();
            this.m_loginList.addAll(loginList);
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public List getResults() {
        if (this.m_loginList == null) {
            throw new IllegalStateException("Search has not been performed!");
        }
        return this.m_loginList;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_loginList = null;
    }

    public class LoginDomainPair
    implements Comparable {
        private String m_strUserIDLogin;
        private String m_strDomain;

        public LoginDomainPair(String userID, String domain) {
            this.m_strUserIDLogin = userID;
            this.m_strDomain = domain;
        }

        public String getUserID() {
            return this.m_strUserIDLogin;
        }

        public String getAuthDomain() {
            return this.m_strDomain;
        }

        public String toString() {
            String strLogin = this.getUserID();
            String strDomain = this.getAuthDomain();
            String strDisplayName = strLogin;
            if (strDomain.length() > 0) {
                strDisplayName = strDisplayName + " (" + strDomain + ")";
            }
            return strDisplayName;
        }

        public int compareTo(Object o) {
            int valCompare = this.getUserID().compareToIgnoreCase(((LoginDomainPair)o).getUserID());
            if (valCompare == 0) {
                return this.getAuthDomain().compareToIgnoreCase(((LoginDomainPair)o).getAuthDomain());
            }
            return valCompare;
        }
    }
}

