/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.backup.analyze.model.RuntimeSASEnvironment;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.backup.common.definitions.BackupException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class OperationDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String slug;
    private String name;
    private String runBy;
    private Date startTime;
    private boolean scheduled;
    private String type;
    private OperationStatus status = OperationStatus.NOT_STARTED;
    private Date endTime;
    String logFilePath;
    private List<BackupSourceDetails> sourceDetails;
    private float percentComplete;
    protected BackupConfiguration config;
    private String comment = "";
    private StringBuffer errorMessage;
    private RuntimeSASEnvironment runtimeEnvironment;
    private long size;

    public String getSlug() {
        return this.slug;
    }

    @SASScope
    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getName() {
        return this.name;
    }

    @SASScope
    public void setName(String name) {
        this.name = name;
    }

    public String getRunBy() {
        return this.runBy;
    }

    @SASScope
    public void setRunBy(String runBy) {
        this.runBy = runBy;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    @SASScope
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    @SASScope
    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    public String getType() {
        return this.type;
    }

    @SASScope
    public void setType(String type) {
        this.type = type;
    }

    public BackupConfiguration getConfig() {
        return this.config;
    }

    @SASScope
    public void setConfig(BackupConfiguration config) {
        this.config = config;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    @SASScope
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    @SASScope
    public void setStatus(OperationStatus status) throws BackupException {
        if (status == null) {
            status = OperationStatus.FAIL;
        }
        this.status = status;
        switch (status) {
            case INPROGRESS: {
                this.setStartTime(new Date());
                break;
            }
            case SUCCESS: 
            case ANALYSIS_WARN: 
            case WARN: 
            case FAIL: 
            case CANCELLED: 
            case FATAL: {
                this.setEndTime(new Date());
                break;
            }
            case NOT_STARTED: 
            case UNKNOWN: {
                break;
            }
            default: {
                throw new BackupException((Throwable)new IllegalArgumentException("The operation status is unknown!"), 601);
            }
        }
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    @SASScope
    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public List<BackupSourceDetails> getSourceDetails() {
        if (this.sourceDetails == null) {
            this.sourceDetails = new ArrayList<BackupSourceDetails>();
        }
        return this.sourceDetails;
    }

    @SASScope
    public void setSourceDetails(List<BackupSourceDetails> sourceDetails) {
        this.sourceDetails = sourceDetails;
    }

    public float getPercentComplete() {
        return this.percentComplete;
    }

    @SASScope
    public void setPercentComplete(float percentComplete) {
        this.percentComplete = percentComplete;
    }

    public long getSize() {
        return this.size;
    }

    @SASScope
    public void setSize(long size) {
        this.size = size;
    }

    public String getComment() {
        return this.comment;
    }

    @SASScope
    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        String value = null;
        if (this.name != null) {
            value = "Name: " + this.name;
        }
        if (this.type != null) {
            value = value + " Type: " + this.type;
        }
        return value == null ? super.toString() : value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OperationDetails)) {
            return false;
        }
        OperationDetails details = (OperationDetails)obj;
        return this == details || this.name.equalsIgnoreCase(details.getName()) && this.type.equalsIgnoreCase(details.getType());
    }

    public int hashCode() {
        int result = 17;
        if (this.name != null) {
            result = 31 * result + this.name.hashCode();
        }
        if (this.type != null) {
            result = 31 * result + this.type.hashCode();
        }
        return result;
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : this.errorMessage.toString();
    }

    public void setErrorMessage(String errorMessage) {
        if (this.errorMessage == null) {
            this.errorMessage = new StringBuffer();
        }
        if (this.errorMessage.length() != 0) {
            this.errorMessage.append(", ");
        }
        this.errorMessage.append(errorMessage);
    }

    public BackupSourceDetails getBackupSourceDetails(BackupSourceNode node, BackupSourceConfig.BackupSource source) {
        List<BackupSourceDetails> backupSourcedetails = this.getSourceDetails();
        for (BackupSourceDetails details : backupSourcedetails) {
            if (!node.equals(details.getSourceConfig().getBackupSourceNode()) || !source.equals((Object)details.getSourceConfig().getSourceType())) continue;
            return details;
        }
        return null;
    }

    public RuntimeSASEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public void setRuntimeEnvironment(RuntimeSASEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    public static enum OperationStatus {
        NOT_STARTED(6, true, false),
        INPROGRESS(-1, false, false),
        SUCCESS(0, false, true),
        ANALYSIS_WARN(2, true, true),
        WARN(4, true, true),
        FAIL(8, true, false),
        CANCELLED(10, true, false),
        FATAL(12, true, false),
        UNKNOWN(99, true, false);

        private int intCode;
        private boolean canBeRecovered;
        private boolean notificationRequired;

        private OperationStatus(int intCode, boolean notificationRequired, boolean canBeRecovered) {
            this.setIntCode(intCode);
            this.notificationRequired = notificationRequired;
            this.canBeRecovered = canBeRecovered;
        }

        public int getIntCode() {
            return this.intCode;
        }

        private void setIntCode(int intCode) {
            this.intCode = intCode;
        }

        public boolean canBeRecovered() {
            return this.canBeRecovered;
        }

        public boolean isNotificationRequired() {
            return this.notificationRequired;
        }
    }
}

