/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import com.sas.svcs.backup.client.BackupSourceNode;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import java.io.Serializable;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

public class BackupSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BackupSource sourceType;
    private Properties properties;
    private BackupSourceNode backupSourceNode;

    @XmlAttribute
    public BackupSource getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(BackupSource sourceType) {
        this.sourceType = sourceType;
    }

    @XmlTransient
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @XmlTransient
    public BackupSourceNode getBackupSourceNode() {
        return this.backupSourceNode;
    }

    public void setBackupSourceNode(BackupSourceNode backupSourceNode) {
        this.backupSourceNode = backupSourceNode;
    }

    public static enum BackupSource {
        METADATASERVER("metadataServer", new DeploymentDiscoveryDAO.ComponentType[]{DeploymentDiscoveryDAO.ComponentType.METADATA_SERVER}),
        CONTENTSERVER("contentServer", new DeploymentDiscoveryDAO.ComponentType[]{DeploymentDiscoveryDAO.ComponentType.CONTENT_SERVER}),
        CONFIGDIR("configDirectories", new DeploymentDiscoveryDAO.ComponentType[]{DeploymentDiscoveryDAO.ComponentType.SAS_APP_SERVER}),
        CUSTOMDIR("customDirectories", null),
        DATABASE("database", new DeploymentDiscoveryDAO.ComponentType[]{DeploymentDiscoveryDAO.ComponentType.SAS_SOL_DATA_SERVER, DeploymentDiscoveryDAO.ComponentType.SAS_WIP_DATA_SERVER}),
        SASTIER("sastiers", null);

        String displayName;
        DeploymentDiscoveryDAO.ComponentType[] componentType;

        public String getDisplayName() {
            return this.displayName;
        }

        public DeploymentDiscoveryDAO.ComponentType[] getComponentTypes() {
            return this.componentType;
        }

        private BackupSource() {
        }

        private BackupSource(String displayName, DeploymentDiscoveryDAO.ComponentType[] components) {
            this.displayName = displayName;
            this.componentType = components;
        }
    }
}

