/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class BackupServiceResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected BackupErrorDetails errorDetails;
    protected T actualResult;
    protected LinkedHashSet<BackupException> exceptions = new LinkedHashSet();
    private AnalysisResult analysisResult;

    public BackupErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    @SASScope
    public void setErrorDetails(BackupErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    @SASScope
    public void generateErrorDetails(BackupErrorLogger errorLogger) throws BackupException {
        boolean errorsEncountered;
        boolean bl = errorsEncountered = this.exceptions != null && !this.exceptions.isEmpty();
        if (errorsEncountered) {
            this.errorDetails = new BackupErrorDetails();
            LinkedList<BackupException> exceptionsList = new LinkedList<BackupException>();
            exceptionsList.addAll(this.exceptions);
            List errorEntries = errorLogger.getErrorEntries(exceptionsList);
            this.errorDetails.setBackupErrorEntries(errorEntries);
            if (this.analysisResult != null && !this.analysisResult.getAllSourcesErrors().isEmpty()) {
                List<AnalysisResult.AnalysisProblem> analysisProblems = this.analysisResult.getAllSourcesErrors();
                for (AnalysisResult.AnalysisProblem analysisProblem : analysisProblems) {
                }
            }
        }
    }

    public LinkedHashSet<BackupException> getExceptions() {
        return this.exceptions;
    }

    @SASScope
    public void setExceptions(LinkedHashSet<BackupException> exceptions) {
        this.exceptions = exceptions;
    }

    @SASScope
    public boolean addException(BackupException backupException) {
        return this.exceptions.add(backupException);
    }

    public T getActualResult() {
        return this.actualResult;
    }

    @SASScope
    public void setActualResult(T actualResult) {
        this.actualResult = actualResult;
    }

    public AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    public void setAnalysisResult(AnalysisResult analysisResult) {
        this.analysisResult = analysisResult;
    }
}

