/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze.model;

import com.sas.svcs.backup.analyze.model.RB;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.deployment.data.ConfigurableServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalysisResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<BackupSourceConfig.BackupSource, List<AnalysisProblem>> analyzeErrors = new HashMap<BackupSourceConfig.BackupSource, List<AnalysisProblem>>();

    private AnalysisResult() {
    }

    public static AnalysisResult getInstance() {
        return new AnalysisResult();
    }

    public List<AnalysisProblem> getAnalyzeErrors(BackupSourceConfig.BackupSource source) {
        if (this.analyzeErrors.containsKey((Object)source)) {
            return this.analyzeErrors.get((Object)source);
        }
        return null;
    }

    public List<AnalysisProblem> getAllSourcesErrors() {
        Collection<List<AnalysisProblem>> allErrors = this.analyzeErrors.values();
        ArrayList<AnalysisProblem> collected = null;
        if (!allErrors.isEmpty()) {
            collected = new ArrayList<AnalysisProblem>();
            for (List<AnalysisProblem> sourceProblems : allErrors) {
                collected.addAll(sourceProblems);
            }
        }
        return collected;
    }

    public boolean hasRealErrors() {
        boolean hasRealErrors = false;
        if (!this.analyzeErrors.isEmpty()) {
            List<AnalysisProblem> allProblems = this.getAllSourcesErrors();
            for (AnalysisProblem problem : allProblems) {
                if (!problem.isError()) continue;
                return true;
            }
        } else {
            return false;
        }
        return hasRealErrors;
    }

    public boolean hasErrors(BackupSourceConfig.BackupSource source) {
        return this.analyzeErrors.containsKey((Object)source);
    }

    public boolean hasErrors(BackupSourceConfig.BackupSource source, ConfigurableServer server) {
        boolean hasErrors = false;
        if (server != null && this.hasErrors(source)) {
            List<AnalysisProblem> problems = this.analyzeErrors.get((Object)source);
            for (AnalysisProblem problem : problems) {
                if (!server.equals((Object)problem.getAssociatedObject()) || !problem.isError()) continue;
                return true;
            }
        }
        return hasErrors;
    }

    public boolean addAllProblems(BackupSourceConfig.BackupSource source, List<AnalysisProblem> problems) {
        boolean added = false;
        if (this.hasErrors(source) && problems != null) {
            this.analyzeErrors.get((Object)source).addAll(problems);
            added = true;
        } else if (problems != null) {
            this.analyzeErrors.put(source, problems);
            added = true;
        }
        return added;
    }

    private boolean addProblem(AnalysisProblem problem, BackupSourceConfig.BackupSource source) {
        List<Object> problems = null;
        if (problem != null && source != null) {
            if (this.hasErrors(source)) {
                problems = this.analyzeErrors.get((Object)source);
            } else {
                problems = new ArrayList();
                this.analyzeErrors.put(source, problems);
            }
            problems.add(problem);
            return true;
        }
        return false;
    }

    public boolean addProblem(int statusCode, String possibleCause, String remedyMessage, BackupSourceConfig.BackupSource source) {
        AnalysisProblem problem = AnalysisResult.createProblem(statusCode, possibleCause, remedyMessage);
        return this.addProblem(problem, source);
    }

    public boolean addError(int statusCode, String possibleCause, String remedyMessage, BackupSourceConfig.BackupSource source) {
        AnalysisProblem problem = AnalysisResult.createError(statusCode, possibleCause, remedyMessage);
        return this.addProblem(problem, source);
    }

    public boolean isOK() {
        return this.analyzeErrors.isEmpty();
    }

    public static AnalysisProblem createProblem(int statusCode, String possibleCause, String remedyMessage) {
        return new AnalysisProblem(statusCode, possibleCause, remedyMessage);
    }

    public static AnalysisProblem createProblem(int statusCode, String possibleCause) {
        return new AnalysisProblem(statusCode, possibleCause);
    }

    public static AnalysisProblem createProblem(int statusCode) {
        return new AnalysisProblem(statusCode);
    }

    public static AnalysisProblem createProblemForSource(ConfigurableServer configurableServer, int statusCode, String possibleCause, String remedyMessage) {
        return new AnalysisProblem(statusCode, possibleCause, remedyMessage);
    }

    public static AnalysisProblem createProblemForSource(ConfigurableServer configurableServer, int statusCode, String possibleCause) {
        return new AnalysisProblem(statusCode, possibleCause);
    }

    public static AnalysisProblem createError(int statusCode, String possibleCause, String remedyMessage) {
        AnalysisProblem error = new AnalysisProblem(statusCode, possibleCause, remedyMessage);
        error.setError(true);
        return error;
    }

    public static AnalysisProblem createError(int statusCode, String possibleCause) {
        AnalysisProblem error = new AnalysisProblem(statusCode, possibleCause);
        error.setError(true);
        return error;
    }

    public static AnalysisProblem createErrorForSource(ConfigurableServer configurableServer, int statusCode, String possibleCause, String remedyMessage) {
        AnalysisProblem error = new AnalysisProblem(statusCode, possibleCause, remedyMessage);
        error.setError(true);
        error.setAssociatedObject(configurableServer);
        return error;
    }

    public static AnalysisProblem createErrorForSource(ConfigurableServer configurableServer, int statusCode, String possibleCause) {
        AnalysisProblem error = new AnalysisProblem(statusCode, possibleCause);
        error.setError(true);
        error.setAssociatedObject(configurableServer);
        return error;
    }

    public static AnalysisProblem createErrorForSource(ConfigurableServer configurableServer, int statusCode) {
        AnalysisProblem error = new AnalysisProblem(statusCode);
        error.setError(true);
        error.setAssociatedObject(configurableServer);
        return error;
    }

    public static AnalysisProblem createError(int statusCode) {
        AnalysisProblem error = new AnalysisProblem(statusCode);
        error.setError(true);
        return error;
    }

    public String getDisplayString() {
        StringBuffer sb = new StringBuffer("");
        if (this.analyzeErrors != null) {
            for (AnalysisProblem problem : this.getAllSourcesErrors()) {
                if (!problem.isError()) continue;
                sb.append(problem.getDisplayString());
            }
        }
        return sb.toString();
    }

    public static class AnalysisProblem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int statusCode;
        private String possibleCause;
        private String remedyMessage;
        private boolean error;
        private transient ConfigurableServer associated;

        AnalysisProblem(int statusCode) {
            this.statusCode = statusCode;
        }

        AnalysisProblem(int statusCode, String possibleCause, String remedyMessage) {
            this(statusCode);
            this.possibleCause = possibleCause;
            this.remedyMessage = remedyMessage;
        }

        AnalysisProblem(int statusCode, String possibleCause) {
            this(statusCode);
            this.possibleCause = possibleCause;
        }

        public void setAssociatedObject(ConfigurableServer server) {
            this.associated = server;
        }

        public ConfigurableServer getAssociatedObject() {
            return this.associated;
        }

        BackupException converToBackupException() {
            BackupException.BackupExceptionBuilder builder = BackupException.getBuilder((int)this.statusCode);
            if (this.possibleCause != null) {
                builder.addInfo("possibleCause", this.possibleCause);
            }
            if (this.remedyMessage != null) {
                builder.addInfo("remedyMessage", this.remedyMessage);
            }
            return builder.build();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getPossibleCause() {
            return this.possibleCause;
        }

        public String getRemedyMessage() {
            return this.remedyMessage;
        }

        public boolean isError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }

        public String getDisplayString() {
            StringBuffer sb = new StringBuffer("\n\t " + RB.getStringResource("AnalysisResult.analysis.problem.txt"));
            if (null != this.associated) {
                sb.append("\n\t\t " + RB.getStringResource("AnalysisProblem.for.associated.server.txt") + this.associated.getObjectName());
            }
            sb.append("\n\t\t " + RB.getStringResource("AnalysisProblem.status.code.txt") + this.statusCode);
            if (null != this.possibleCause) {
                sb.append("\n\t\t " + RB.getStringResource("AnalysisProblem.possible.cause.txt") + this.possibleCause);
            }
            if (null != this.remedyMessage) {
                sb.append("\n\t\t " + RB.getStringResource("AnalysisProblem.remedy.message.txt") + this.remedyMessage);
            }
            return sb.toString();
        }
    }
}

