/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformerFactoryFactory {
    private static final Logger LOGGER = LogManager.getLogger(TransformerFactoryFactory.class);
    private static final String XALAN_FEATURE = "http://javax.xml.XMLConstants/feature/secure-processing";
    private static final String[] ATTRIBUTES_TO_DISABLE = new String[]{"accessExternalDTD", "accessExternalStylesheet"};
    private static final String ATTRIBUTE_PREFIX = "http://javax.xml.XMLConstants/property/";

    private TransformerFactoryFactory() {
    }

    private static boolean clearAttribute(TransformerFactory factory, String attribute) {
        try {
            factory.setAttribute(attribute, "");
            return true;
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("TransformerFactory " + factory.getClass().getName() + " does not support setting " + attribute);
            return false;
        }
    }

    private static void secureFactory(TransformerFactory factory) {
        boolean failedToSetSomeAttributes = false;
        for (String feature : ATTRIBUTES_TO_DISABLE) {
            if (TransformerFactoryFactory.clearAttribute(factory, ATTRIBUTE_PREFIX + feature)) continue;
            failedToSetSomeAttributes = true;
        }
        if (failedToSetSomeAttributes) {
            failedToSetSomeAttributes = false;
            for (String feature : ATTRIBUTES_TO_DISABLE) {
                if (TransformerFactoryFactory.clearAttribute(factory, feature)) continue;
                failedToSetSomeAttributes = true;
            }
        }
        if (failedToSetSomeAttributes) {
            failedToSetSomeAttributes = false;
            try {
                factory.setFeature(XALAN_FEATURE, false);
            }
            catch (TransformerConfigurationException ex) {
                failedToSetSomeAttributes = true;
            }
        }
        if (failedToSetSomeAttributes) {
            LOGGER.info("Failed to set both unqualified and qualified forms of security feature to disable entity processing.");
        }
    }

    public static TransformerFactory newFactory() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Got TransformerFactory of type " + factory.getClass().getName());
        }
        TransformerFactoryFactory.secureFactory(factory);
        return factory;
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        boolean failedToSetSomeAttributes = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        String FEATURE = null;
        FEATURE = "http://xml.org/sax/features/external-general-entities";
        if (TransformerFactoryFactory.trySetFeature(documentBuilderFactory, FEATURE, false) && TransformerFactoryFactory.trySetFeature(documentBuilderFactory, FEATURE = "http://xerces.apache.org/xerces-j/features.html#external-general-entities", false) && TransformerFactoryFactory.trySetFeature(documentBuilderFactory, FEATURE = "http://xerces.apache.org/xerces2-j/features.html#external-general-entities", false)) {
            failedToSetSomeAttributes = true;
        }
        if (TransformerFactoryFactory.trySetFeature(documentBuilderFactory, FEATURE = "http://xml.org/sax/features/external-parameter-entities", false) && TransformerFactoryFactory.trySetFeature(documentBuilderFactory, FEATURE = "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", false) && TransformerFactoryFactory.trySetFeature(documentBuilderFactory, FEATURE = "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", false)) {
            failedToSetSomeAttributes = true;
        }
        if (TransformerFactoryFactory.trySetFeature(documentBuilderFactory, FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd", false)) {
            failedToSetSomeAttributes = true;
        }
        if (failedToSetSomeAttributes) {
            LOGGER.info("Failed to set both unqualified and qualified forms of security feature to disable entity processing.");
        }
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory;
    }

    private static boolean trySetFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException ex) {
            return true;
        }
        return false;
    }
}

