/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.discovery.JVMAttribute;
import com.sas.services.discovery.ServiceDeploymentAttribute;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.util.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.zip.CRC32;
import javax.management.ObjectName;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Names {
    private static final int MAX_NAME_LENGTH = 60;
    public static final int MAX_VARIABLE_NAME_LENGTH = 32;
    private static final int MAX_LIBREF_NAME_LENGTH = 8;
    private static final int MAX_FILEREF_NAME_LENGTH = 8;
    private static final char UNDERSCORE = '_';
    private static final char DOLLARSIGN = '$';
    private static final char POUNDSIGN = '#';
    private static final char AMPERSAND = '@';
    private static final String UNIQUE_NAME_PREFIX = "_#";
    private static final char BACKSLASH = '\\';
    private static final String BACKSLASH_STRING = String.valueOf('\\');
    private static final char FORWARD_SLASH = '/';
    private static final String FORWARD_SLASH_STRING = String.valueOf('/');
    public static final int UNKNOWN = 0;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    public static final int ZOS_HFS = 3;
    public static final int ZOS_PDS = 4;
    public static final int WEBDAV = 5;

    private Names() {
    }

    public static String mapNameToFilesystem(String name, int hostOS, String prefix, String suffix) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullName.ex.txt"));
        }
        StringBuilder buf = new StringBuilder();
        char slash = Names.processPrefix(prefix, buf, hostOS);
        if (hostOS == 4 && slash == '\u0000' && suffix != null) {
            buf.append('.');
            buf.append(suffix);
            buf.append('(');
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                if (c != '\\' && c != '/') {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        if (hostOS == 4 && slash == '\u0000') {
            buf.append(')');
        } else if (suffix != null) {
            buf.append(suffix);
        }
        return buf.toString();
    }

    public static String mapUrlToFilesystem(String url, int hostOS, String prefix, String suffix) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullUrl.ex.txt"));
        }
        PathUrl purl = new PathUrl(url);
        String path = purl.getPath();
        if (path == null) {
            path = "";
        }
        StringBuilder buf = new StringBuilder();
        char slash = Names.processPrefix(prefix, buf, hostOS);
        String myPath = null;
        if (hostOS == 4 && slash == '\u0000') {
            if (suffix != null) {
                buf.append('.');
                buf.append(suffix);
            }
            buf.append('(');
            myPath = purl.getName() != null ? purl.getName() : purl.getRootTree();
        } else {
            StringBuilder b = new StringBuilder();
            b.append(purl.getRootTree());
            if (path.length() > 0) {
                b.append(slash);
                b.append(path);
            }
            if (purl.getName() != null) {
                b.append(slash);
                b.append(purl.getName());
            }
            myPath = b.toString();
        }
        for (int i = 0; i < myPath.length(); ++i) {
            char c = myPath.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                if (c != '\\' && c != '/') {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        if (hostOS == 4 && slash == '\u0000') {
            buf.append(')');
        } else if (suffix != null) {
            buf.append(suffix);
        }
        return buf.toString();
    }

    public static String mapNameToSASVariableName(String name, Collection existingNames) throws IllegalArgumentException {
        String str = null;
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullName.ex.txt"));
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("Names.zeroLen.ex.txt"));
        }
        StringBuilder buf = new StringBuilder();
        str = name.toLowerCase();
        int stopIndex = 32;
        if (Character.isDigit(str.charAt(0))) {
            buf.append('_');
            stopIndex = 31;
        }
        for (int i = 0; i < str.length() && i < stopIndex; ++i) {
            if (!Names.isAlphaNumeric(str.charAt(i))) {
                buf.append('_');
                continue;
            }
            buf.append(str.charAt(i));
        }
        String current = buf.toString();
        int uniqueIdx = 1;
        if (existingNames != null) {
            while (!Names.isNameUnique(existingNames, current)) {
                current = Names.newName(current, uniqueIdx++);
            }
        }
        return current;
    }

    public static String mapNameToOMRObjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullName.ex.txt"));
        }
        if ((name = Names.trimName(name)).length() == 0) {
            name = "_";
        }
        int length = name.length();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        StringBuilder sb = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            char c = chars[index];
            if (c == '/' || c == '\\') {
                sb.append('_');
                continue;
            }
            if (Character.isISOControl(c)) continue;
            sb.append(c);
        }
        if (sb.length() > 60) {
            return sb.substring(0, 60);
        }
        return sb.toString();
    }

    public static boolean validateIdentityName(String name, boolean throwException) throws IllegalArgumentException {
        return Names.doValidate(name, throwException, true);
    }

    public static boolean validateOMRObjectName(String name, boolean throwException) throws IllegalArgumentException {
        return Names.doValidate(name, throwException, false);
    }

    private static boolean doValidate(String name, boolean throwException, boolean ignoreSlashes) {
        boolean isValid = true;
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullName.ex.txt"));
        }
        if (name.length() == 0) {
            if (throwException) {
                throw new IllegalArgumentException(RB.getStringResource("Names.zeroLen.ex.txt"));
            }
            return false;
        }
        if (name.length() > 60) {
            if (throwException) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.maxSixty.ex.fmt.txt", (Object)name));
            }
            isValid = false;
        } else {
            int start = 0;
            int end = name.length() - 1;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (i == start && Character.isSpaceChar(c)) {
                    if (throwException) {
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.leadingSpace.ex.fmt.txt", (Object)name));
                    }
                    isValid = false;
                    break;
                }
                if (i == end && Character.isSpaceChar(c)) {
                    if (throwException) {
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.trailingSpace.ex.fmt.txt", (Object)name));
                    }
                    isValid = false;
                    break;
                }
                if (!ignoreSlashes && c == '\\') {
                    if (throwException) {
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.slash.ex.fmt.txt", (Object)name));
                    }
                    isValid = false;
                    break;
                }
                if (!ignoreSlashes && c == '/') {
                    if (throwException) {
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.slash.ex.fmt.txt", (Object)name));
                    }
                    isValid = false;
                    break;
                }
                if (!Character.isISOControl(c)) continue;
                if (throwException) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.controlChar.ex.fmt.txt", (Object)name));
                }
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public static boolean validateParameterName(String name, boolean throwException) throws IllegalArgumentException {
        return Names.validateOMRObjectName(name, throwException);
    }

    public static boolean validateSASVariableName(String name, boolean throwException) throws IllegalArgumentException {
        return Names.validateSASName(name, throwException, 32);
    }

    public static boolean validateSASLibrefName(String name, boolean throwException) throws IllegalArgumentException {
        return Names.validateSASName(name, throwException, 8);
    }

    private static boolean validateSASName(String name, boolean throwException, int maxLength) throws IllegalArgumentException {
        boolean isValid = true;
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullName.ex.txt"));
        }
        if (name.length() == 0) {
            if (throwException) {
                throw new IllegalArgumentException(RB.getStringResource("Names.zeroLen.ex.txt"));
            }
            return false;
        }
        if (name.length() > maxLength) {
            if (throwException) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.maxLength.ex.fmt.txt", (Object)name, (Object)String.valueOf(maxLength)));
            }
            isValid = false;
        } else {
            char startChar = name.charAt(0);
            if (!Names.isAlphabetic(startChar) && startChar != '_') {
                if (throwException) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.alpha.ex.fmt.txt", (Object)name, (Object)"a-z", (Object)"A-Z"));
                }
                isValid = false;
            } else {
                for (int i = 1; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (Names.isAlphaNumeric(c) || c == '_') continue;
                    if (throwException) {
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.alphaDig.ex.fmt.txt", (Object)name));
                    }
                    isValid = false;
                    break;
                }
            }
        }
        return isValid;
    }

    public static boolean validateSASFilerefName(String name, boolean throwException) throws IllegalArgumentException {
        boolean isValid = true;
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullName.ex.txt"));
        }
        if (name.length() == 0) {
            if (throwException) {
                throw new IllegalArgumentException(RB.getStringResource("Names.zeroLen.ex.txt"));
            }
            return false;
        }
        if (name.length() > 8) {
            if (throwException) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.maxLength.ex.fmt.txt", (Object)name, (Object)String.valueOf(8)));
            }
            isValid = false;
        } else {
            char startChar = name.charAt(0);
            if (!Names.isAlphabetic(startChar) && startChar != '_') {
                if (throwException) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.alpha.ex.fmt.txt", (Object)name, (Object)"a-z", (Object)"A-Z"));
                }
                isValid = false;
            } else {
                for (int i = 1; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (Names.isAlphaNumeric(c) || c == '_' || c == '$' || c == '#' || c == '@') continue;
                    if (throwException) {
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Names.alphaDig.ex.fmt.txt", (Object)name));
                    }
                    isValid = false;
                    break;
                }
            }
        }
        return isValid;
    }

    public static String trimName(String name) throws IllegalArgumentException {
        char c;
        int idx;
        String s = null;
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("Names.nullName.ex.txt"));
        }
        int start = -1;
        int end = -1;
        for (idx = 0; idx < name.length() && (Character.isSpaceChar(c = name.charAt(idx)) || Character.isISOControl(c)); ++idx) {
        }
        if (idx == name.length()) {
            return "";
        }
        start = idx;
        for (idx = name.length() - 1; idx >= 0 && (Character.isSpaceChar(c = name.charAt(idx)) || Character.isISOControl(c)); --idx) {
        }
        if (idx != -1) {
            end = idx;
        }
        s = start != -1 && end != -1 ? name.substring(start, end + 1) : (start != -1 ? name.substring(start, name.length() - 1) : (end != -1 ? name.substring(0, end + 1) : name));
        return s;
    }

    private static boolean isAlphaNumeric(char c) {
        boolean isAN = false;
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            isAN = true;
        }
        return isAN;
    }

    private static boolean isAlphabetic(char c) {
        boolean isA = false;
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            isA = true;
        }
        return isA;
    }

    private static char processPrefix(String prefix, StringBuilder buf, int hostOS) throws IllegalArgumentException {
        int returnChar = 0;
        if (hostOS == 0) {
            returnChar = 47;
            if (prefix != null && prefix.length() > 0) {
                buf.append(prefix);
                int idx = prefix.indexOf(92);
                if (idx >= 0) {
                    returnChar = 92;
                    if (!prefix.endsWith(BACKSLASH_STRING)) {
                        buf.append('\\');
                    }
                } else if (!prefix.endsWith(FORWARD_SLASH_STRING)) {
                    buf.append('/');
                }
            }
        } else if (hostOS == 1) {
            returnChar = 92;
            if (prefix != null && prefix.length() > 0) {
                buf.append(prefix);
                int idx = prefix.indexOf(47);
                if (idx >= 0) {
                    returnChar = 47;
                    if (!prefix.endsWith(FORWARD_SLASH_STRING)) {
                        buf.append('/');
                    }
                } else if (!prefix.endsWith(BACKSLASH_STRING)) {
                    buf.append('\\');
                }
            }
        } else if (hostOS == 2 || hostOS == 3 || hostOS == 5) {
            if (prefix != null) {
                buf.append(prefix);
                if (prefix.length() != 0 && !prefix.endsWith(FORWARD_SLASH_STRING)) {
                    buf.append('/');
                }
            }
            returnChar = 47;
        } else if (hostOS == 4) {
            returnChar = 0;
            if (prefix != null && prefix.length() != 0) {
                buf.append(prefix);
                if (prefix.startsWith(FORWARD_SLASH_STRING)) {
                    returnChar = 47;
                    if (!prefix.endsWith(FORWARD_SLASH_STRING)) {
                        buf.append('/');
                    }
                }
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource("Names.badOS.ex.txt"));
        }
        return (char)returnChar;
    }

    private static String newName(String name, int idx) {
        int stripIndex = -1;
        String finalStr = null;
        StringBuilder b = new StringBuilder();
        b.append(UNIQUE_NAME_PREFIX);
        b.append(idx);
        if (idx > 1) {
            StringBuilder tBuf = new StringBuilder();
            tBuf.append(UNIQUE_NAME_PREFIX);
            tBuf.append(idx - 1);
            stripIndex = name.lastIndexOf(tBuf.toString());
            name = name.substring(0, stripIndex);
        }
        if (name.length() + b.length() > 32) {
            int remaining = 32 - b.length();
            if (remaining <= 0) {
                throw new IllegalStateException(RB.getStringResource("Names.nameErr.ex.txt"));
            }
            name = name.substring(0, remaining);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append((CharSequence)b);
        finalStr = buf.toString();
        return finalStr;
    }

    private static boolean isNameUnique(Collection c, String name) {
        boolean unique = true;
        for (String s : c) {
            if (!s.equalsIgnoreCase(name)) continue;
            unique = false;
            break;
        }
        return unique;
    }

    public static String generateName(int numOfChars) {
        StringBuilder buf = new StringBuilder();
        VMID vmid = new VMID();
        String v = vmid.toString();
        byte[] b = v.getBytes();
        CRC32 crc32 = new CRC32();
        crc32.update(b);
        buf.append('S');
        String ad = Long.toHexString(crc32.getValue());
        if (numOfChars == 0) {
            buf.append(ad);
        } else {
            int numCharsNeeded;
            int len = ad.length();
            if (len >= (numCharsNeeded = numOfChars - 1)) {
                buf.append(ad.substring(len - numCharsNeeded));
            } else {
                for (int i = numCharsNeeded - len; i > 0; --i) {
                    buf.append('0');
                }
                buf.append(ad);
            }
        }
        return buf.toString();
    }

    public static String getObjectName(String name, RemoteServiceInterface remoteService) {
        String objectName = null;
        String COMMA = ",";
        String SERVICES_DOMAIN = "com.sas.services:";
        String TYPE2 = "type=";
        String SOFTWARE_COMPONENT = "softwareComponent=";
        String SERVICE_GROUP = "serviceGroup=";
        String JVM_ATTRIBUTE = "jvmAttribute=";
        String ENTITYKEY_ATTRIBUTE = "entityKey=";
        ServiceConfigurationInterface serviceConfig = null;
        ServiceDiscoveryConfigurationInterface config = null;
        try {
            serviceConfig = remoteService.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder();
        buf.append("com.sas.services:");
        if (serviceConfig != null && serviceConfig instanceof ServiceDiscoveryConfigurationInterface) {
            String jvmId;
            String serviceGroupName;
            ServiceDeploymentAttribute sda;
            config = (ServiceDiscoveryConfigurationInterface)((Object)serviceConfig);
            boolean first = true;
            if (name != null) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append("type=");
                buf.append(name);
            }
            if ((sda = config.getServiceDeploymentAttribute()) != null) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append("softwareComponent=");
                buf.append(ObjectName.quote(sda.name));
            }
            if ((serviceGroupName = config.getServiceGroup()) != null) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append("serviceGroup=");
                buf.append(ObjectName.quote(serviceGroupName));
            }
            if ((jvmId = config.getJVMId()) != null) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append("jvmAttribute=");
                buf.append(ObjectName.quote(jvmId));
            }
            String key = null;
            try {
                key = remoteService.getEntityKey();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (key != null) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append("entityKey=");
                buf.append(ObjectName.quote(key));
            }
            objectName = buf.toString();
        } else {
            buf.append("type=");
            buf.append(name);
            buf.append(",");
            JVMAttribute jvma = new JVMAttribute();
            buf.append("jvmAttribute=");
            buf.append(ObjectName.quote(jvma.id));
            buf.append(",");
            try {
                String key = remoteService.getEntityKey();
                buf.append("entityKey=");
                buf.append(ObjectName.quote(key));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            objectName = buf.toString();
        }
        return objectName;
    }
}

