/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import java.util.Calendar;
import java.util.TimeZone;

@SASScope
public class DateUtil {
    private static final double SECONDSINTHESIXTIES = 3.156192E8;

    public static long SASDateTimeToJavaDate(double sasDatetime, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        long javaDate = (long)((sasDatetime - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timezone);
        cal.setTimeInMillis(javaDate);
        return javaDate - (long)cal.get(16);
    }

    public static double javaDateToSASDateTime(long date, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timezone);
        cal.setTimeInMillis(date);
        return (double)(date += (long)(timezone.getRawOffset() + cal.get(16))) / 1000.0 + 3.156192E8;
    }
}

