/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;

@SASScope
public abstract class AbstractMBean
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private Map<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>();
    private List<MBeanNotificationInfo> notifications = new ArrayList<MBeanNotificationInfo>();
    private List<MBeanConstructorInfo> constructors = new ArrayList<MBeanConstructorInfo>();
    private List<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
    private String description = "";
    protected int READ_ACCESS = 1;
    protected int WRITE_ACCESS = 2;

    public AbstractMBean(String desc) {
        this.description = desc;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            Class<?> c = this.getTargetObject().getClass();
            Class[] sig = null;
            if (signature != null) {
                sig = new Class[signature.length];
                for (int i = 0; i < signature.length; ++i) {
                    sig[i] = Class.forName(signature[i]);
                }
            }
            Method m = c.getMethod(actionName, sig);
            Object returnObject = m.invoke(this.getTargetObject(), params);
            return returnObject;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            Class<?> c = this.getTargetObject().getClass();
            Method m = c.getMethod("get" + attribute, null);
            return m.invoke(this.getTargetObject(), (Object[])null);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws MBeanException, AttributeNotFoundException, ReflectionException, InvalidAttributeValueException {
        String fname = attribute.getName();
        Object fvalue = attribute.getValue();
        try {
            Class<?> c = this.getTargetObject().getClass();
            String type = this.getType(fname, this.WRITE_ACCESS);
            if (type == null) {
                throw new AttributeNotFoundException(fname);
            }
            Class[] types = new Class[]{Class.forName(type)};
            Method m = c.getMethod("set" + fname, types);
            Object[] args = new Object[]{fvalue};
            m.invoke(this.getTargetObject(), args);
        }
        catch (AttributeNotFoundException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        Attribute[] atts = (Attribute[])attributes.toArray();
        AttributeList list = new AttributeList();
        for (int i = 0; i < atts.length; ++i) {
            Attribute a = atts[i];
            try {
                this.setAttribute(a);
                list.add(a);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                list.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getClass().getName(), this.description, this.attributes.values().toArray(new MBeanAttributeInfo[0]), this.constructors.toArray(new MBeanConstructorInfo[0]), this.operations.toArray(new MBeanOperationInfo[0]), this.notifications.toArray(new MBeanNotificationInfo[0]));
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notifications.toArray(new MBeanNotificationInfo[0]);
    }

    protected void addMBeanOperation(String name, String desc, MBeanParameterInfo[] params, String rtype, int impact) {
        this.operations.add(new MBeanOperationInfo(name, desc, params, rtype, impact));
    }

    protected void addMBeanAttribute(String name, String type, boolean read, boolean write, boolean is, String desc) {
        this.attributes.put(name, new MBeanAttributeInfo(name, type, desc, read, write, is));
    }

    protected void removeMBeanAttribute(String name) {
        this.attributes.remove(name);
    }

    protected void addMBeanNotification(String[] notifTypes, String name, String desc) {
        this.notifications.add(new MBeanNotificationInfo(notifTypes, name, desc));
    }

    protected void addMBeanConstructor(String name, String desc, MBeanParameterInfo[] params) {
        this.constructors.add(new MBeanConstructorInfo(name, desc, params));
    }

    protected String getType(String attName, int mode) {
        boolean allowed = true;
        if (this.attributes.containsKey(attName)) {
            MBeanAttributeInfo temp = this.attributes.get(attName);
            if (mode == this.READ_ACCESS) {
                if (!temp.isReadable()) {
                    allowed = false;
                }
            } else if (mode == this.WRITE_ACCESS && !temp.isWritable()) {
                allowed = false;
            }
            if (!allowed) {
                return null;
            }
            return temp.getType();
        }
        return null;
    }

    protected abstract Object getTargetObject();
}

