/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.cache.CacheStatistics;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.LoginFailure;
import com.sas.services.user.RB;
import com.sas.services.user.SummaryData;
import com.sas.services.user.SummaryDataEntry;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceFactory;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.AbstractMBean;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class UserServiceMBean
extends AbstractMBean {
    private static final String USER_COUNT_ATTRIBUTE_NAME = "UserCount";
    private static final String FAILURE_COUNT_ATTRIBUTE_NAME = "FailureCount";
    private static final String SERVICE_START_ATTRIBUTE_NAME = "ServiceStart";
    private static final String AUTH_COUNT_ATTRIBUTE_NAME = "AuthCount";
    private static final String INT_TYPE_NAME = "int";
    private static final String MBEAN_DESCRIPTION = RB.getStringResource("UserServiceMBean.mBeanDescription.txt");
    private static final String USER_COUNT_DESCRIPTION = RB.getStringResource("UserServiceMBean.userCountDescription.txt");
    private static final String FAILURE_COUNT_DESCRIPTION = RB.getStringResource("UserServiceMBean.failureCountDescrption.txt");
    private static final String AUTH_COUNT_DESCRIPTION = RB.getStringResource("UserServiceMBean.authCountDescription.txt");
    private static final String SERVICE_START_DESCRIPTION = RB.getStringResource("UserServiceMBean.startTimeDescription.txt");
    private static final String FAIL_LIST_TYPE_NAME = "FailureDetailData";
    private static final String FAILURE_DETAIL_DESCRIPTION = RB.getStringResource("UserServiceMBean.failureDetailDescription.txt");
    private static final String[] FAILURE_LIST_NAMES = new String[]{"UID", "Count", "Times"};
    private static final String[] FAILURE_LIST_DESCRIPTIONS = new String[]{RB.getStringResource("UserServiceMBean.failureuid.txt"), RB.getStringResource("UserServiceMBean.failureCount.txt"), RB.getStringResource("UserServiceMBean.failureTimeDescription.txt")};
    private static final String FAIL_TIME_TYPE_NAME = "FailureTimeData";
    private static final String FAIL_TIME_DESCRIPTION = RB.getStringResource("UserServiceMBean.failureTimeDescription.txt");
    private static final String[] FAIL_TIME_NAMES = new String[]{"Failure time"};
    private static final String[] FAIL_TIME_DESCRIPTIONS = new String[]{RB.getStringResource("UserServiceMBean.failureTimeDescription.txt")};
    private static final OpenType[] FAIL_TIME_TYPES = new OpenType[]{SimpleType.DATE};
    private static final String USER_SUMMARYDATA_ATTRIBUTE_NAME = "UserDetailData";
    private static final String SESSION_SUMMARYDATA_DESCRIPTION = RB.getStringResource("UserServiceMBean.userSummaryDescription.txt");
    private static final String METACACHE_COMPOSITETYPE_NAME = "Metadata Cache";
    private static final String METACACHE_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("UserServiceMBean.metacacheCompositeDescription.txt");
    private static final String DATACACHE_COMPOSITETYPE_NAME = "Data Cache";
    private static final String DATACACHE_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("UserServiceMBean.datacacheCompositeDescription.txt");
    private static final String[] CACHE_DATA_NAMES = new String[]{"Hits", "Misses", "Size", "Highwater"};
    private static final String[] CACHE_DATA_DESCRIPTIONS = new String[]{RB.getStringResource("UserServiceMBean.cacheHits.txt"), RB.getStringResource("UserServiceMBean.cacheMisses.txt"), RB.getStringResource("UserServiceMBean.cacheSize.txt"), RB.getStringResource("UserServiceMBean.cacheHighwater.txt")};
    private static final OpenType[] CACHE_DATA_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
    private static final String REPOS_TABTYPE_NAME = "Repositories";
    private static final String REPOS_TABTYPE_DESCRIPTION = RB.getStringResource("UserServiceMBean.reposTabularDescription.txt");
    private static final String REPOS_COMPOSITETYPE_NAME = "Repository";
    private static final String REPOS_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("UserServiceMBean.reposCompositeDescription.txt");
    private static final String[] REPOS_DATA_NAMES = new String[]{"IS Name", "Protocol", "Host", "Port", "Base", "Metacache", "DataCache"};
    private static final String[] REPOS_DATA_DESCRIPTIONS = new String[]{RB.getStringResource("UserServiceMBean.reposName.txt"), RB.getStringResource("UserServiceMBean.reposProtocol.txt"), RB.getStringResource("UserServiceMBean.reposHost.txt"), RB.getStringResource("UserServiceMBean.reposPort.txt"), RB.getStringResource("UserServiceMBean.reposBase.txt"), RB.getStringResource("UserServiceMBean.reposMetaCache.txt"), RB.getStringResource("UserServiceMBean.reposDataCache.txt")};
    private static final String SUMMARY_COMPOSITETYPE_NAME = "SummaryData";
    private static final String SUMMARY_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("UserServiceMBean.summaryCompositeDescription.txt");
    private static final String[] SUMMARY_DATA_NAMES = new String[]{"Name", "User id", "User Context Identifier", "Login Time", "Client ID", "Application", "Repositories"};
    public static final String[] SUMMARY_DATA_DESCRIPTIONS = new String[]{RB.getStringResource("UserServiceMBean.userDescription.txt"), RB.getStringResource("UserServiceMBean.userIdDescription.txt"), RB.getStringResource("UserServiceMBean.userctxidDescription.txt"), RB.getStringResource("UserServiceMBean.loginTimeDescription.txt"), RB.getStringResource("UserServiceMBean.clientidDescription.txt"), RB.getStringResource("UserServiceMBean.appidDescription.txt"), RB.getStringResource("UserServiceMBean.reposSummaryDescription.txt")};
    public static final String SUMMARY_TABULARTYPE_NAME = "AllSummaryData";
    public static final String SUMMARY_TABULARTYPE_DESCRIPTION = RB.getStringResource("UserServiceMBean.summaryTabularDescription.txt");
    public static final String[] SUMMARY_DATA_INDEX_NAMES = new String[]{"User Context Identifier"};
    public static final String DESTROY_USER_METHOD_NAME = "destroyUser";
    public static final String DESTROY_USER_DESCRIPTION = RB.getStringResource("UserServiceMBean.destroyUserDescription.txt");
    public static final String USERCONTEXT_ID_PARM_NAME = RB.getStringResource("UserServiceMBean.usercontextidparmname.txt");
    private final String STRING_CLASS_NAME = String.class.getName();
    public static final String USERCONTEXT_ID_PARM_DESCRIPTION = RB.getStringResource("UserServiceMBean.useridparmdesc.txt");
    private UserServiceInterface _userService = null;

    public UserServiceMBean() {
        super(MBEAN_DESCRIPTION);
        this.addMBeanAttribute(USER_COUNT_ATTRIBUTE_NAME, INT_TYPE_NAME, true, false, false, USER_COUNT_DESCRIPTION);
        this.addMBeanAttribute(FAILURE_COUNT_ATTRIBUTE_NAME, INT_TYPE_NAME, true, false, false, FAILURE_COUNT_DESCRIPTION);
        this.addMBeanAttribute(AUTH_COUNT_ATTRIBUTE_NAME, INT_TYPE_NAME, true, false, false, AUTH_COUNT_DESCRIPTION);
        this.addMBeanAttribute(SERVICE_START_ATTRIBUTE_NAME, Date.class.getName(), true, false, false, SERVICE_START_DESCRIPTION);
        this.addMBeanAttribute(USER_SUMMARYDATA_ATTRIBUTE_NAME, "javax.management.openmbean.TabularData", true, false, false, SESSION_SUMMARYDATA_DESCRIPTION);
        this.addMBeanAttribute(FAIL_LIST_TYPE_NAME, TabularData.class.getName(), true, false, false, FAILURE_DETAIL_DESCRIPTION);
        this.addMBeanOperation(DESTROY_USER_METHOD_NAME, DESTROY_USER_DESCRIPTION, new MBeanParameterInfo[]{new MBeanParameterInfo(USERCONTEXT_ID_PARM_NAME, this.STRING_CLASS_NAME, USERCONTEXT_ID_PARM_DESCRIPTION)}, this.STRING_CLASS_NAME, 1);
    }

    public String destroyUser(String userContextId) throws Exception {
        if (this._userService != null) {
            try {
                UserContextInterface uci = this._userService.getUser(userContextId);
                if (uci != null) {
                    SessionContextInterface sci = uci.getSessionContext();
                    if (sci == null) {
                        uci.destroy();
                        return Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceMBean.userdestroyed.fmt.txt", (Object)userContextId);
                    }
                    return Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceMBean.destroysession.fmt.txt", (Object)userContextId);
                }
                return Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceMBean.nosuchuser.fmt.txt", (Object)userContextId);
            }
            catch (RemoteException ex) {
                return ex.getMessage();
            }
        }
        return "";
    }

    public int getUserCount() {
        if (this._userService != null) {
            try {
                return this._userService.getUserCount();
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getFailureCount() {
        if (this._userService != null) {
            try {
                SummaryData sd = this._userService.getSummaryData(false);
                return sd.getFailures();
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getAuthCount() {
        if (this._userService != null) {
            try {
                SummaryData sd = this._userService.getSummaryData(false);
                return sd.getAuthentications();
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0;
    }

    public Date getServiceStart() {
        if (this._userService != null) {
            try {
                SummaryData sd = this._userService.getSummaryData(false);
                return sd.getStartDate();
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return new Date();
    }

    public TabularData getUserDetailData() throws Exception {
        TabularDataSupport td = null;
        SummaryData summary = this._userService.getSummaryData(true);
        List list = summary.getCurrentUserDetails();
        CompositeType metaCacheType = new CompositeType(METACACHE_COMPOSITETYPE_NAME, METACACHE_COMPOSITETYPE_DESCRIPTION, CACHE_DATA_NAMES, CACHE_DATA_DESCRIPTIONS, CACHE_DATA_TYPES);
        CompositeType dataCacheType = new CompositeType(DATACACHE_COMPOSITETYPE_NAME, DATACACHE_COMPOSITETYPE_DESCRIPTION, CACHE_DATA_NAMES, CACHE_DATA_DESCRIPTIONS, CACHE_DATA_TYPES);
        CompositeType reposType = new CompositeType(REPOS_COMPOSITETYPE_NAME, REPOS_COMPOSITETYPE_DESCRIPTION, REPOS_DATA_NAMES, REPOS_DATA_DESCRIPTIONS, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, metaCacheType, dataCacheType});
        TabularType reposTabType = new TabularType(REPOS_TABTYPE_NAME, REPOS_TABTYPE_DESCRIPTION, reposType, REPOS_DATA_NAMES);
        TabularType dataTypes = null;
        CompositeType dataType = null;
        dataType = new CompositeType(SUMMARY_COMPOSITETYPE_NAME, SUMMARY_COMPOSITETYPE_DESCRIPTION, SUMMARY_DATA_NAMES, SUMMARY_DATA_DESCRIPTIONS, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, reposTabType});
        dataTypes = new TabularType(SUMMARY_TABULARTYPE_NAME, SUMMARY_TABULARTYPE_DESCRIPTION, dataType, SUMMARY_DATA_INDEX_NAMES);
        td = new TabularDataSupport(dataTypes);
        for (SummaryDataEntry sd : list) {
            TabularDataSupport reposData = new TabularDataSupport(reposTabType);
            for (SummaryDataEntry.RepositorySummary repoSum : sd.getReposData()) {
                Object[] cacheValues = null;
                CacheStatistics cs = repoSum.getMetaCache();
                cacheValues = cs == null ? new Object[]{-1, -1, -1, -1} : new Object[]{cs.getCacheHits(), cs.getCacheMisses(), cs.getObjectCount(), -1};
                CompositeDataSupport mcacheData = new CompositeDataSupport(metaCacheType, CACHE_DATA_NAMES, cacheValues);
                cs = repoSum.getDataCache();
                cacheValues = cs == null ? new Object[]{-1, -1, -1, -1} : new Object[]{cs.getCacheHits(), cs.getCacheMisses(), cs.getObjectCount(), -1};
                CompositeDataSupport dcacheData = new CompositeDataSupport(dataCacheType, CACHE_DATA_NAMES, cacheValues);
                Object[] reposValues = new Object[]{repoSum.getIsName(), repoSum.getProtocol(), repoSum.getHost(), repoSum.getPort(), repoSum.getBase(), mcacheData, dcacheData};
                CompositeDataSupport reposSummary = new CompositeDataSupport(reposType, REPOS_DATA_NAMES, reposValues);
                reposData.put(reposSummary);
            }
            Date d = new Date();
            d.setTime(sd.getAuthTime());
            SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss z");
            s.setTimeZone(TimeZone.getDefault());
            String timeAsStr = s.format(d);
            Object[] itemValues = new Object[]{sd.getName(), sd.getUserid(), sd.getUserCtxId(), timeAsStr, sd.getClientSource(), sd.getAppSource(), reposData};
            CompositeDataSupport result = new CompositeDataSupport(dataType, SUMMARY_DATA_NAMES, itemValues);
            td.put(result);
        }
        return td;
    }

    public TabularData getFailureDetailData() throws Exception {
        TabularDataSupport td = null;
        TabularDataSupport ftd = null;
        CompositeDataSupport fcd = null;
        CompositeType fileTimeType = new CompositeType(FAIL_TIME_TYPE_NAME, FAIL_TIME_DESCRIPTION, FAIL_TIME_NAMES, FAIL_TIME_DESCRIPTIONS, FAIL_TIME_TYPES);
        TabularType fileTimeTabType = new TabularType(FAIL_TIME_TYPE_NAME, FAIL_TIME_DESCRIPTION, fileTimeType, FAIL_TIME_NAMES);
        CompositeType failureType = new CompositeType(FAIL_LIST_TYPE_NAME, FAILURE_DETAIL_DESCRIPTION, FAILURE_LIST_NAMES, FAILURE_LIST_DESCRIPTIONS, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, fileTimeTabType});
        TabularType failureTabType = new TabularType(FAIL_LIST_TYPE_NAME, FAILURE_DETAIL_DESCRIPTION, failureType, FAILURE_LIST_NAMES);
        SummaryData summary = this._userService.getSummaryData(true);
        List list = summary.getFailureDetails();
        td = new TabularDataSupport(failureTabType);
        Iterator it = list.iterator();
        String uid = null;
        int count = 0;
        while (it.hasNext()) {
            ftd = new TabularDataSupport(fileTimeTabType);
            List failList = (List)it.next();
            count = failList.size();
            for (LoginFailure lf : failList) {
                uid = lf.getFailedUser();
                Object[] itemValues = new Object[]{lf.getFailureDate()};
                fcd = new CompositeDataSupport(fileTimeType, FAIL_TIME_NAMES, itemValues);
                ftd.put(fcd);
            }
            Object[] itemValues = new Object[]{uid, count, ftd};
            CompositeDataSupport result = new CompositeDataSupport(failureType, FAILURE_LIST_NAMES, itemValues);
            td.put(result);
        }
        return td;
    }

    @Override
    protected Object getTargetObject() {
        this.initTargetObject();
        return this;
    }

    private void initTargetObject() {
        if (this._userService == null) {
            try {
                this._userService = (UserServiceInterface)new UserServiceFactory().getService(null);
            }
            catch (Exception e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceMBean.exceptionGetService.fmt.txt", (Object)e.toString());
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
            }
            catch (Error e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceMBean.errorGetService.fmt.txt", (Object)e.toString());
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
            }
        }
    }
}

