/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IPasswordControl;
import com.sas.meta.SASOMI.IPasswordControlHelper;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceInitializationObject;
import com.sas.services.ServiceState;
import com.sas.services.cache.CacheStatistics;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.deployment.Environment;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.ServerVersionException;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.Authenticator;
import com.sas.services.security.LoginCallbackHandler;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.security.SecurityUtil;
import com.sas.services.security.login.PFSCredential;
import com.sas.services.security.login.PFSPrincipal;
import com.sas.services.user.LoginFailure;
import com.sas.services.user.NonPersonAuthenticationException;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.RB;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.SubjectMatter;
import com.sas.services.user.SummaryData;
import com.sas.services.user.SummaryDataEntry;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserContextPermission;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInitObject;
import com.sas.services.user.UserServiceInitializer;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.user.UserServiceMBean;
import com.sas.services.user.UserServiceProxy;
import com.sas.services.user.UserUnknownException;
import com.sas.services.util.JMXAgent;
import com.sas.services.util.JMXRegistration;
import com.sas.services.util.Names;
import com.sas.services.util.URIUtil;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class UserService
extends AbstractRemoteService
implements UserServiceInterface {
    private static final String USERSVC_CONTEXT = "com.sas.services.user.UserService";
    private static final String REPOS_URL_OMI = "omi:";
    private final String MONITOR_LABEL_TYPE = RB.getStringResource("UserService.monitorlabeltype.txt");
    private final String MONITOR_LABEL_STATUS = RB.getStringResource("UserService.monitorlabelstatus.txt");
    private final String MONITOR_LABEL_UID = RB.getStringResource("UserService.monitorlabeluid.txt");
    private final String MONITOR_LABEL_DOMAIN = RB.getStringResource("UserService.monitorlabeldomain.txt");
    private final String MONITOR_LABEL_MESSAGE = RB.getStringResource("UserService.monitorlabelmessage.txt");
    private final String MONITOR_LABEL_CLIENT = RB.getStringResource("UserService.monitorlabelclient.txt");
    private final String MONITOR_LABEL_APP = RB.getStringResource("UserService.monitorlabelapp.txt");
    private final String MONITOR_VALUE_LOGIN = RB.getStringResource("UserService.monitorvaluelogin.txt");
    private final String MONITOR_VALUE_FAILURE = RB.getStringResource("UserService.monitorvaluefailure.txt");
    private final String MONITOR_VALUE_SUCCESS = RB.getStringResource("UserService.monitorvaluesuccess.txt");
    private static final int USERMAP_INIT_VALUE = 128;
    private static final int HOSTLIST_INIT_VALUE = 32;
    private static final int GROUPLIST_INIT_VALUE = 8;
    private static final int EXCEPTIONLIST_INIT_VALUE = 4;
    private static UserServiceInterface _service = null;
    private String _domain;
    private Logger _logger;
    private RemoteCallbackHandler _handler;
    private Map<String, UserContextInterface> _users = new HashMap<String, UserContextInterface>(128);
    private Map<String, List<String>> _name2Key = new HashMap<String, List<String>>(128);
    private Map<String, UserContextInterface> _userMap = new HashMap<String, UserContextInterface>(128);
    private boolean _allowGroupLogins = false;
    private Map<String, ProfileDomain> _profDefs;
    private boolean _destroyed;
    private JMXRegistration _mbeanJMXRegistration;
    private JMXAgent _agent;
    private Map<String, List<LoginFailure>> _failures;
    private int _failureCount;
    private int _loginCount;
    private long _createTime;

    public static InformationServiceInterface getInformationService() throws ServiceException {
        InformationServiceInterface informationService = null;
        try {
            informationService = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        }
        catch (ServiceException t) {
            informationService = null;
        }
        catch (RemoteException t) {
            informationService = null;
        }
        if (informationService == null) {
            throw new ServiceException(RB.getStringResource("UserContext.nostprserv.ex.txt"));
        }
        return informationService;
    }

    public void initialize(UserServiceInitObject initObject) {
        if (initObject == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.nullConfig.ex.txt"));
        }
        this._destroyed = false;
        this._profDefs = new HashMap<String, ProfileDomain>(initObject.getProfiles());
        this._domain = initObject.getDomain();
        this._failures = new HashMap<String, List<LoginFailure>>(5);
        this._createTime = System.currentTimeMillis();
        UserContext.setUserService(this);
        Iterator<SimpleUserIdentity> it = initObject.getUsers();
        while (it.hasNext()) {
            UserIdentityInterface ident = it.next();
            try {
                String uid = (String)ident.getPrincipal();
                String password = (String)ident.getCredential();
                String domain = ident.getDomain();
                UserContextInterface userContext = null;
                try {
                    userContext = this.newUser(uid, password, domain);
                }
                catch (UserInitializationException uiex) {
                    userContext = uiex.getUser();
                }
                catch (ServiceException t) {
                    ChainedException.printStackTrace((Throwable)((java.lang.Object)t), (PrintStream)System.out, (boolean)true);
                }
                if (userContext == null) continue;
                userContext.setKey(uid);
                this.setUser(userContext);
            }
            catch (RemoteException ex) {
                try {
                    this.logMessage(Level.WARN, "", USERSVC_CONTEXT, ex);
                }
                catch (RemoteException ex2) {
                    ex2.printStackTrace(System.out);
                }
            }
        }
    }

    @Override
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        super.configure(serviceConfiguration);
        java.lang.Object initObject = serviceConfiguration.getInitializationObject();
        UserServiceInitObject userServiceInitObject = null;
        try {
            userServiceInitObject = (UserServiceInitObject)initObject;
        }
        catch (ClassCastException e) {
            try {
                userServiceInitObject = (UserServiceInitObject)((ServiceInitializationObject)initObject).getConfiguration(new UserServiceInitializer());
            }
            catch (ClassCastException cce) {
                throw new InitializationException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.config.ex.fmt.txt", (java.lang.Object)initObject));
            }
        }
        this.initialize(userServiceInitObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ServiceException, RemoteException {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        UserContext.setUserService(null);
        try {
            short serviceState = this.getServiceState();
            if (!ServiceState.isStateDeactivated(serviceState)) {
                _service = null;
                this._handler = null;
                this._domain = null;
                if (this._users != null) {
                    this._users.clear();
                }
                try {
                    Collection<UserContextInterface> users = this._userMap.values();
                    java.lang.Object[] userArray = users.toArray();
                    for (int i = 0; i < userArray.length; ++i) {
                        UserContextInterface uci = (UserContextInterface)userArray[i];
                        if (uci.isDestroyed()) continue;
                        uci.destroy();
                    }
                }
                finally {
                    this._userMap.clear();
                }
                if (this._name2Key != null) {
                    this._name2Key.clear();
                }
                if (this._profDefs != null) {
                    this._profDefs.clear();
                }
                this._logger = null;
            }
            if (this._agent != null && this._mbeanJMXRegistration != null) {
                this._agent.unregisterMBeanUsingRegistration(this._mbeanJMXRegistration);
                this._mbeanJMXRegistration = null;
            }
        }
        finally {
            super.destroy();
        }
    }

    private UserService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        super(discoveryService);
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)this, sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
        this._logger = LogManager.getLogger((String)USERSVC_CONTEXT);
        try {
            this.configure(serviceConfiguration);
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("UserService.configure.ex.txt"));
        }
        try {
            String mbeanObjectName;
            this._agent = JMXAgent.getInstance();
            if (this._agent != null && this._agent.isMBeanEnabled(mbeanObjectName = Names.getObjectName("UserService", this))) {
                UserServiceMBean mbean = new UserServiceMBean();
                this._mbeanJMXRegistration = this._agent.registerMBean(mbean, mbeanObjectName, true);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final RemoteServiceInterface getServiceProxy() {
        UserServiceProxy proxy = null;
        try {
            proxy = new UserServiceProxy(_service);
        }
        catch (InitializationException e) {
            proxy = null;
        }
        return proxy;
    }

    public static UserServiceInterface getInstance(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        UserService.setService(serviceConfiguration, discoveryService);
        if (_service == null) {
            throw new ServiceException(RB.getStringResource("UserService.unableToObtainService.ex.txt"));
        }
        return _service;
    }

    private static final synchronized void setService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        if (_service == null) {
            UserService service = new UserService(serviceConfiguration, discoveryService);
            _service = service;
            try {
                service.bindToDiscoveryService();
            }
            catch (ServiceException e) {
                if (service != null) {
                    try {
                        service.destroy();
                    }
                    catch (RemoteException re) {
                        Logger logger = LogManager.getLogger((String)USERSVC_CONTEXT);
                        logger.error(RB.getStringResource("UserService.destroy.ex.txt"), (Throwable)re);
                    }
                }
                throw new ServiceException((Throwable)((java.lang.Object)e), RB.getStringResource("UserService.unabletocreate.ex.txt"));
            }
        }
        Logger logger = LogManager.getLogger((String)USERSVC_CONTEXT);
        logger.warn(RB.getStringResource("UserService.alreadyConfigured.ex.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUser(UserContextInterface user) throws RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        UserService userService = this;
        synchronized (userService) {
            String uid;
            UserContextInterface u;
            UserContextInterface uci = user;
            if (user instanceof RemoteStub && (u = this.getUserByUid(uid = user.getUniqueId())) != null) {
                uci = u;
            }
            this._users.put(uci.getKey(), uci);
            String name = uci.getName();
            if (name == null) {
                return;
            }
            List<String> nameList = this._name2Key.get(name);
            if (nameList == null) {
                nameList = new ArrayList<String>(128);
                nameList.add(uci.getKey());
                this._name2Key.put(name, nameList);
            } else {
                nameList.add(uci.getKey());
            }
        }
    }

    @Override
    public void userDestroyed(UserContextInterface user) throws ServiceException, RemoteException {
        this.removeUser(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(UserContextInterface user) throws RemoteException {
        if (this._destroyed) {
            return false;
        }
        UserService userService = this;
        synchronized (userService) {
            String uniqueid = user.getUniqueId();
            this._userMap.remove(uniqueid);
            String key = user.getKey();
            UserContextInterface remo = null;
            remo = this._users.remove(key);
            if (remo != null) {
                String name = user.getName();
                List<String> nameList = this._name2Key.get(name);
                if (nameList != null && nameList.remove(key) && nameList.size() == 0) {
                    this._name2Key.remove(name);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public UserContextInterface getUser(String user) throws RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this.getUser(null, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface getUser(UserContextInterface privUser, String user) throws RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        UserContextPermission ucp = new UserContextPermission(user, "read");
        SecurityUtil.checkPermission(privUser, ucp);
        this.cleanUsers();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Retrieving user with key " + user);
        }
        UserContextInterface uci = null;
        uci = this.getUserByUid(user);
        if (uci != null && this._logger.isDebugEnabled()) {
            this._logger.debug("Returning user " + uci.getUniqueId() + " -> " + uci.getName());
        }
        if (uci != null) {
            return uci;
        }
        UserService userService = this;
        synchronized (userService) {
            uci = this._users.get(user);
            if (uci != null) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Returning user " + uci.getUniqueId() + " -> " + uci.getName());
                }
                return uci;
            }
            List<String> nameList = this._name2Key.get(user);
            if (nameList != null && nameList.size() > 0) {
                String key = null;
                key = nameList.get(0);
                uci = this._users.get(key);
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Returning user " + uci.getUniqueId() + " -> " + uci.getName());
                }
                return uci;
            }
        }
        return uci;
    }

    @Override
    public UserIdentityInterface newUserIdentity(java.lang.Object principal, java.lang.Object credential, String domain, String mechanism) throws RemoteException, ServiceException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if ("simple".equalsIgnoreCase(mechanism)) {
            SimpleUserIdentity id = new SimpleUserIdentity((String)principal, (String)credential, domain);
            return id;
        }
        return null;
    }

    @Override
    public ProfileDomain getProfileDefinition(String application) throws ServiceException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this._profDefs.get(application);
    }

    @Override
    public ProfileInterface loadProfile(UserContextInterface user, String application) throws RemoteException, ServiceException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this.loadProfile(null, user, application);
    }

    @Override
    public ProfileInterface loadProfile(UserContextInterface searchContext, UserContextInterface user, String application) throws RemoteException, ServiceException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        ProfileInterface poi = null;
        if (user == null) {
            return null;
        }
        if (searchContext == null) {
            searchContext = user;
        }
        try {
            poi = user.getProfile().getProfile(application);
            if (poi != null && poi.isLoaded()) {
                return poi;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        String applicationName = application;
        if (applicationName == null) {
            applicationName = "global";
        }
        Iterator<String> keys = this._profDefs.keySet().iterator();
        while (keys.hasNext()) {
            this.logFormat(Level.DEBUG, USERSVC_CONTEXT, RB.getResources(), "UserService.profdef.ex.fmt", keys.next());
        }
        ProfileDomain pd = this.getProfileDomain(applicationName);
        this.logFormat(Level.DEBUG, USERSVC_CONTEXT, RB.getResources(), "UserService.profload.ex.fmt", user.getName(), applicationName, pd.getClassName());
        poi = this.makeProfile(application, pd);
        Iterator reps = searchContext.getRepositories().iterator();
        boolean found_repos = false;
        while (reps.hasNext()) {
            RepositoryInterface rep = (RepositoryInterface)reps.next();
            if (URIUtil.url1StartsWithUrl2(rep.getUrl(), pd.getUrl()) == null) continue;
            found_repos = true;
            poi.load(rep.getIdentity(), user, rep, pd);
        }
        if (!found_repos) {
            this.logFormat(Level.INFO, USERSVC_CONTEXT, RB.getResources(), "UserService.profres.ex.fmt", searchContext.getName(), pd.getUrl(), applicationName);
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UserService.profres.ex.fmt", (java.lang.Object)searchContext.getName(), (java.lang.Object)pd.getUrl(), (java.lang.Object)applicationName));
        }
        ProfileInterface p = user.getProfile();
        p.addProfile(application, poi, false);
        return poi;
    }

    @Override
    public ProfileInterface getProfile(PersonInterface person, String application) throws ServiceException, RemoteException {
        ProfileDomain pd;
        ProfileInterface poi;
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if (person == null) {
            return null;
        }
        if (application == null) {
            application = "global";
        }
        if ((poi = this.makeProfile(application, pd = this.getProfileDomain(application))) == null) {
            return null;
        }
        poi.load(person, person.getRepository().getUserContext(), person.getRepository(), pd);
        return poi;
    }

    @Override
    public ProfileInterface createProfile(UserContextInterface user, String application) throws ServiceException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if (user == null) {
            throw new ServiceException(RB.getStringResource("UserService.nullctx.ex.txt"));
        }
        if (application == null) {
            throw new ServiceException(RB.getStringResource("UserService.invalidapp.ex.txt"));
        }
        return this.createProfile(null, user, application);
    }

    @Override
    public ProfileInterface createProfile(UserContextInterface privUser, UserContextInterface user, String application) throws ServiceException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if (user == null) {
            throw new ServiceException(RB.getStringResource("UserService.nullctx.ex.txt"));
        }
        if (application == null) {
            throw new ServiceException(RB.getStringResource("UserService.invalidapp.ex.txt"));
        }
        this.logFormat(Level.DEBUG, USERSVC_CONTEXT, RB.getResources(), "UserService.creatprofile.msg.fmt.txt", user.getName(), application);
        if (privUser == null) {
            privUser = user;
        }
        String applicationName = application;
        ProfileDomain pd = this.getProfileDomain(applicationName);
        this.logFormat(Level.DEBUG, USERSVC_CONTEXT, RB.getResources(), "UserService.fndprofdef.msg.fmt.txt", applicationName);
        ProfileInterface poi = this.makeProfile(application, pd);
        Iterator reps = privUser.getRepositories().iterator();
        boolean found_repos = false;
        while (reps.hasNext()) {
            RepositoryInterface rep = (RepositoryInterface)reps.next();
            if (!rep.getUrl().equals(pd.getUrl())) continue;
            found_repos = true;
            this.logFormat(Level.DEBUG, USERSVC_CONTEXT, RB.getResources(), "UserService.profcrtinrepos.msg.fmt.txt", rep.getUrl(), applicationName);
            poi.create(rep.getIdentity(), user, rep, pd);
        }
        if (!found_repos) {
            this.logFormat(Level.INFO, USERSVC_CONTEXT, RB.getResources(), "UserService.profres.ex.fmt", privUser.getName(), pd.getUrl(), applicationName);
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UserService.profres.ex.fmt", (java.lang.Object)privUser.getName(), (java.lang.Object)pd.getUrl(), (java.lang.Object)applicationName));
        }
        ProfileInterface p = user.getProfile();
        p.addProfile(application, poi, false);
        return poi;
    }

    private ProfileDomain getProfileDomain(String applicationName) throws ServiceException {
        ProfileDomain result = this._profDefs.get(applicationName);
        if (result == null && (result = this._profDefs.get("default")) == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UserService.noprofileconfig.ex.fmt.txt", (java.lang.Object)applicationName));
        }
        return result;
    }

    private ProfileInterface makeProfile(String application, ProfileDomain pd) throws ServiceException {
        ProfileInterface poi = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> objectClass = cl.loadClass(pd.getClassName());
            Constructor<?> ctor = null;
            Class[] ctorArgs = new Class[]{String.class};
            ctor = objectClass.getConstructor(ctorArgs);
            if (ctor != null) {
                java.lang.Object[] ctorParms = new java.lang.Object[]{application};
                poi = (ProfileInterface)ctor.newInstance(ctorParms);
            }
        }
        catch (InvocationTargetException t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (ClassNotFoundException t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (NoSuchMethodException t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (InstantiationException t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (IllegalAccessException t) {
            throw new ServiceException(t, t.getMessage());
        }
        return poi;
    }

    @Override
    public void loadUserCredentials(UserContextInterface user) throws ServiceException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        this.loadUserCredentials(null, user);
    }

    @Override
    public void loadUserCredentials(UserContextInterface searchContext, UserContextInterface user) throws ServiceException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if (user == null) {
            return;
        }
        if (searchContext == null) {
            searchContext = user;
        }
        for (RepositoryInterface repo : searchContext.getRepositories()) {
            this.getLoginsFromOMR(user, repo);
        }
    }

    private void getLoginsFromOMR(UserContextInterface user, RepositoryInterface ri) throws ServiceException, RemoteException {
        String repoUrl = ri.getUrl();
        if (!repoUrl.startsWith(REPOS_URL_OMI)) {
            return;
        }
        try {
            String uid = ri.getPrincipal();
            if (uid == null) {
                return;
            }
            Filter loginFilter = new Filter("UserID", 0, uid);
            loginFilter.setType("Login");
            for (LoginInterface login : ri.search(loginFilter)) {
                String pw = login.getPassword();
                String domainName = null;
                try {
                    domainName = login.getDomain();
                }
                catch (RemoteException ex) {
                    this.logMessage(Level.DEBUG, "", USERSVC_CONTEXT, ex);
                }
                SimpleUserIdentity ident = new SimpleUserIdentity(uid, pw, domainName);
                user.addIdentity(ident);
            }
        }
        catch (ServiceException svcex) {
            this.logMessage(Level.DEBUG, "", USERSVC_CONTEXT, (Throwable)((java.lang.Object)svcex));
        }
    }

    @Override
    public List<IdentityGroupInterface> getGroups(UserContextInterface user) throws ServiceException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if (user == null) {
            return Collections.emptyList();
        }
        ArrayList<IdentityGroupInterface> result = new ArrayList<IdentityGroupInterface>(8);
        IdentityInterface primaryIdent = user.getPerson();
        ServerInterface si = user.getAuthServer();
        Filter filter = new Filter();
        FilterComponent fc1 = new FilterComponent("Name", 0, "PUBLIC");
        FilterComponent fc2 = new FilterComponent("Name", 0, "SASUSERS");
        fc1.addComponent(fc2);
        fc1.setAggregation(1);
        filter.setFilterComponent(fc1);
        filter.setType("IdentityGroup");
        List commonGroups = si.search(filter);
        IdentityGroupInterface publicGroup = null;
        IdentityGroupInterface sasusersGroup = null;
        for (IdentityGroupInterface igi : commonGroups) {
            if (igi.getName().equals("PUBLIC")) {
                publicGroup = igi;
            }
            if (!igi.getName().equals("SASUSERS")) continue;
            sasusersGroup = igi;
        }
        if (publicGroup != null) {
            result.add(publicGroup);
        }
        if (primaryIdent == null) {
            return result;
        }
        result.add(sasusersGroup);
        this.getGroups(result, primaryIdent);
        return result;
    }

    private void getGroups(List<IdentityGroupInterface> groupList, IdentityInterface identity) throws RemoteException, ServiceException {
        List groups = identity.getIdentityGroups();
        for (IdentityGroupInterface nextGroup : groups) {
            if (groupList.contains(nextGroup)) continue;
            groupList.add(nextGroup);
            this.getGroups(groupList, nextGroup);
        }
    }

    @Override
    public UserContextInterface newUser(String uid, String password, String domain) throws RemoteException, ServiceException, UserInitializationException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this.newUser(null, uid, password, domain, null, null, null);
    }

    @Override
    public UserContextInterface newUser(String uid, String password, String domain, String clientSource, String appSource) throws RemoteException, ServiceException, UserInitializationException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this.newUser(null, uid, password, domain, clientSource, appSource, null);
    }

    @Override
    public UserContextInterface newUser(UserContext privUser, String uid, String password, String domain) throws RemoteException, ServiceException, UserInitializationException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this.newUser(privUser, uid, password, domain, null, null, null);
    }

    @Override
    public UserContextInterface newUser(UserContextInterface privUser, String uid, String password, String domain) throws RemoteException, ServiceException, UserInitializationException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this.newUser(privUser, uid, password, domain, null, null, null);
    }

    @Override
    public UserContextInterface newUser(UserContext privUser, String uid, String password, String domain, String clientSource, String appSource) throws RemoteException, ServiceException, UserInitializationException {
        return this.newUser(privUser, uid, password, domain, clientSource, appSource, null);
    }

    @Override
    public UserContextInterface newUser(UserContextInterface privUser, String uid, String password, String domain, String clientSource, String appSource) throws RemoteException, ServiceException, UserInitializationException {
        return this.newUser(privUser, uid, password, domain, clientSource, appSource, null);
    }

    @Override
    public UserContextInterface newUser(UserContext privUser, String uid, String password, String domain, String clientSource, String appSource, Map advancedOptions) throws RemoteException, ServiceException, UserInitializationException {
        Exception[] authExceptions;
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if (uid == null) {
            throw new ServiceException(RB.getStringResource("UserService.nulluid.ex.txt"));
        }
        if (uid.length() == 0) {
            throw new ServiceException(RB.getStringResource("UserService.noanon.ex.txt"));
        }
        if (uid.length() > 255) {
            uid = uid.substring(0, 255);
        }
        if (password != null && password.length() > 255) {
            password = password.substring(0, 255);
        }
        long startTime = System.currentTimeMillis();
        this.processOptions(advancedOptions);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(4);
        domain = this.getDomain(domain);
        UserContext uc = new UserContext();
        uc.setClientSource(clientSource);
        uc.setAppSource(appSource);
        String envKey = "ENVIRONMENT";
        Environment environment = this.getEnvironment();
        uc.putSharedResource(envKey, environment);
        uc.putSharedResource("USERSERVICEID", this.getEntityKey());
        String plainPw = this.decodePassword(password);
        UserIdentityInterface ui = this.newUserIdentity(uid, plainPw, domain, "simple");
        Authenticator auth = new Authenticator();
        if (!auth.authenticate(uc, ui, null) || !ui.isAuthenticated()) {
            this.initFailure(uc, ui);
        }
        if ((authExceptions = uc.getExceptions()) != null && authExceptions.length > 0) {
            for (int i = 0; i < authExceptions.length; ++i) {
                if (authExceptions[i] instanceof NonPersonAuthenticationException) {
                    uc.destroy();
                    throw (NonPersonAuthenticationException)((java.lang.Object)authExceptions[i]);
                }
                if (authExceptions[i] instanceof ServerVersionException) {
                    uc.destroy();
                    throw (ServerVersionException)((java.lang.Object)authExceptions[i]);
                }
                exceptions.add(authExceptions[i]);
            }
        }
        if (privUser != null) {
            this.loadUserCredentials(privUser, uc);
        }
        this.initializeUserContext(uc, exceptions);
        ++this._loginCount;
        this.addToUserMap(uc);
        if (exceptions.size() > 0) {
            UserInitializationException uiex = new UserInitializationException(uc);
            Iterator it = exceptions.iterator();
            this.logMessage(Level.INFO, RB.getStringResource("UserService.usrinitexc.msg.txt"));
            while (it.hasNext()) {
                uiex.addException((Exception)it.next());
            }
            throw uiex;
        }
        long endTime = System.currentTimeMillis();
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserService.timing");
        if (timingLogger.isDebugEnabled()) {
            this._logger.debug("newUser call took " + (endTime - startTime) + " milliseconds");
        }
        return uc;
    }

    @Override
    public UserContextInterface newUser(UserContextInterface privUser, String uid, String password, String domain, String clientSource, String appSource, Map advancedOptions) throws RemoteException, ServiceException, UserInitializationException {
        Exception[] authExceptions;
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        if (uid == null) {
            throw new ServiceException(RB.getStringResource("UserService.nulluid.ex.txt"));
        }
        if (uid.length() == 0) {
            throw new ServiceException(RB.getStringResource("UserService.noanon.ex.txt"));
        }
        if (uid.length() > 255) {
            uid = uid.substring(0, 255);
        }
        if (password != null && password.length() > 255) {
            password = password.substring(0, 255);
        }
        long startTime = System.currentTimeMillis();
        this.processOptions(advancedOptions);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(4);
        domain = this.getDomain(domain);
        UserContext uc = new UserContext();
        uc.setClientSource(clientSource);
        uc.setAppSource(appSource);
        String envKey = "ENVIRONMENT";
        Environment environment = this.getEnvironment();
        uc.putSharedResource(envKey, environment);
        uc.putSharedResource("USERSERVICEID", this.getEntityKey());
        String plainPw = this.decodePassword(password);
        UserIdentityInterface ui = this.newUserIdentity(uid, plainPw, domain, "simple");
        Authenticator auth = new Authenticator();
        if (!auth.authenticate(uc, ui, null) || !ui.isAuthenticated()) {
            this.initFailure(uc, ui);
        }
        if ((authExceptions = uc.getExceptions()) != null && authExceptions.length > 0) {
            for (int i = 0; i < authExceptions.length; ++i) {
                if (authExceptions[i] instanceof NonPersonAuthenticationException) {
                    uc.destroy();
                    throw (NonPersonAuthenticationException)((java.lang.Object)authExceptions[i]);
                }
                if (authExceptions[i] instanceof ServerVersionException) {
                    uc.destroy();
                    throw (ServerVersionException)((java.lang.Object)authExceptions[i]);
                }
                exceptions.add(authExceptions[i]);
            }
        }
        if (privUser != null) {
            this.loadUserCredentials(privUser, uc);
        }
        this.initializeUserContext(uc, exceptions);
        ++this._loginCount;
        this.addToUserMap(uc);
        if (exceptions.size() > 0) {
            UserInitializationException uiex = new UserInitializationException(uc);
            Iterator it = exceptions.iterator();
            this.logMessage(Level.INFO, RB.getStringResource("UserService.usrinitexc.msg.txt"));
            while (it.hasNext()) {
                uiex.addException((Exception)it.next());
            }
            throw uiex;
        }
        long endTime = System.currentTimeMillis();
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserService.timing");
        if (timingLogger.isDebugEnabled()) {
            this._logger.debug("newUser call took " + (endTime - startTime) + " milliseconds");
        }
        return uc;
    }

    public UserContextInterface newUser() throws ServiceException, RemoteException, UserInitializationException {
        return this.newUser(null, null);
    }

    @Override
    public UserContextInterface newUser(String clientSource, String appSource) throws ServiceException, RemoteException, UserInitializationException {
        return this.newUser(clientSource, appSource, (Map)null);
    }

    @Override
    public UserContextInterface newUser(String clientSource, String appSource, Map advancedOptions) throws ServiceException, RemoteException, UserInitializationException {
        Exception[] authExceptions;
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        long startTime = System.currentTimeMillis();
        this.processOptions(advancedOptions);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(4);
        UserContext uc = new UserContext();
        uc.setClientSource(clientSource);
        uc.setAppSource(appSource);
        String envKey = "ENVIRONMENT";
        Environment environment = this.getEnvironment();
        uc.putSharedResource(envKey, environment);
        Authenticator auth = new Authenticator();
        if (!auth.authenticate(uc)) {
            SimpleUserIdentity ui = new SimpleUserIdentity("id unknown", "", "SSPI");
            this.initFailure(uc, ui);
        }
        if ((authExceptions = uc.getExceptions()) != null && authExceptions.length > 0) {
            for (int i = 0; i < authExceptions.length; ++i) {
                exceptions.add(authExceptions[i]);
            }
        }
        this.initializeUserContext(uc, exceptions);
        ++this._loginCount;
        this.addToUserMap(uc);
        if (exceptions.size() > 0) {
            UserInitializationException uiex = new UserInitializationException(uc);
            Iterator it = exceptions.iterator();
            this.logMessage(Level.INFO, RB.getStringResource("UserService.usrinitexc.msg.txt"));
            while (it.hasNext()) {
                uiex.addException((Exception)it.next());
            }
            throw uiex;
        }
        long endTime = System.currentTimeMillis();
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserService.timing");
        if (timingLogger.isDebugEnabled()) {
            this._logger.debug("newUser call took " + (endTime - startTime) + " milliseconds");
        }
        return uc;
    }

    @Override
    public UserContextInterface newUserWithInfoService(UserContext privUser, String uid, String password, String domain, InformationServiceInterface infoService) throws RemoteException, ServiceException, UserInitializationException {
        return this.newUser(privUser, uid, password, domain, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SummaryData getSummaryData(boolean includeDetails) throws ServiceException, RemoteException {
        ArrayList<SummaryDataEntry> list = new ArrayList<SummaryDataEntry>();
        ArrayList<List<LoginFailure>> failureList = null;
        SummaryData summary = null;
        Iterator<java.lang.Object> itor = null;
        if (includeDetails) {
            failureList = new ArrayList<List<LoginFailure>>(this._failures.values());
            UserService userService = this;
            synchronized (userService) {
                itor = new ArrayList<UserContextInterface>(this._userMap.values()).iterator();
            }
        } else {
            failureList = Collections.EMPTY_LIST;
            itor = Collections.EMPTY_LIST.iterator();
        }
        while (itor.hasNext()) {
            UserContextInterface uc = (UserContextInterface)itor.next();
            try {
                if (uc == null) continue;
                UserIdentityInterface ident = (UserIdentityInterface)uc.getIdentities().get(0);
                SummaryDataEntry sd = new SummaryDataEntry(uc.getName(), (String)ident.getPrincipal(), uc.getLoginTime(), uc.getUniqueId());
                sd.setAppSource(uc.getAppSource() == null ? "" : uc.getAppSource());
                sd.setClientSource(uc.getClientSource() == null ? "" : uc.getClientSource());
                for (RepositoryInterface ri : uc.getRepositories()) {
                    String url = ri.getUrl();
                    String protocol = url.substring(0, url.indexOf(":"));
                    SummaryDataEntry summaryDataEntry = sd;
                    Objects.requireNonNull(summaryDataEntry);
                    SummaryDataEntry.RepositorySummary rd = summaryDataEntry.new SummaryDataEntry.RepositorySummary(ri.getISName(), protocol, ri.getHost(), String.valueOf(ri.getPort()), ri.getBase());
                    CacheStatistics cs = ri.getCacheStatistics();
                    rd.setMetaCache(cs);
                    sd.addReposData(rd);
                }
                list.add(sd);
            }
            catch (Exception e) {
                if (this._logger == null) continue;
                this._logger.error(e.getMessage(), (Throwable)e);
            }
        }
        summary = new SummaryData(new Date(this._createTime), this._loginCount, this._failureCount, this._users.size(), failureList, list);
        return summary;
    }

    private String decodePassword(String password) {
        String plainPw = password;
        if (password != null) {
            try {
                plainPw = SasPasswordString.decode((String)password);
            }
            catch (SasPasswordEncodingException spee) {
                plainPw = password;
            }
        }
        return plainPw;
    }

    private String getDomain(String domain) throws ServiceException {
        String result = domain;
        if (domain == null || domain.length() == 0) {
            if (this._domain != null) {
                result = this._domain;
            } else {
                throw new ServiceException(RB.getStringResource("UserService.domainmissing.ex.txt"));
            }
        }
        return result;
    }

    private void initFailure(UserContextInterface uc, UserIdentityInterface ident) throws ServiceException, RemoteException {
        String uid = (String)ident.getPrincipal();
        String domain = ident.getDomain();
        LoginFailure lf = new LoginFailure(uid);
        List<LoginFailure> failureList = this._failures.get(uid);
        if (failureList == null) {
            failureList = new ArrayList<LoginFailure>(4);
            this._failures.put(uid, failureList);
            ++this._failureCount;
        }
        failureList.add(lf);
        String message = Message.format((ResourceBundle)RB.getResources(), (String)"UserService.authenticationerror.ex.fmt.txt", (java.lang.Object)uid);
        Exception[] ucExceptions = uc.getExceptions();
        try {
            uc.destroy();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (ucExceptions == null || ucExceptions.length == 0) {
            throw new ServiceException(message);
        }
        Exception ex = ucExceptions[0];
        if (ex instanceof NullPointerException) {
            throw (NullPointerException)ex;
        }
        if (ex instanceof ServiceException) {
            throw (ServiceException)((java.lang.Object)ex);
        }
        throw new ServiceException(ex, ex.getMessage());
    }

    private void initializeUserContext(UserContextInterface uc, List<Throwable> exceptions) throws RemoteException, ServiceException {
        String userName = uc.getName();
        if (userName != null && "unknown".equals(userName)) {
            exceptions.add((Throwable)((java.lang.Object)new UserUnknownException(RB.getStringResource("UserService.userunknown.ex.txt"))));
            return;
        }
    }

    @Override
    public UserContextInterface newRemoteUser(SubjectMatter subject) throws RemoteException, ServiceException, UserInitializationException {
        return this.newRemoteUser(subject, null);
    }

    @Override
    public UserContextInterface newRemoteUser(SubjectMatter subject, Map advancedOptions) throws RemoteException, ServiceException, UserInitializationException {
        this.processOptions(advancedOptions);
        Subject newSubject = new Subject();
        Iterator credit = subject.getPrivateCredentials().iterator();
        boolean isFirst = true;
        while (credit.hasNext()) {
            java.lang.Object o = credit.next();
            if (o instanceof PFSCredential && isFirst) {
                PFSCredential cred = (PFSCredential)o;
                String uid = cred.getUserId();
                String pw = cred.getPassword();
                String domain = cred.getDomain();
                if (pw != null && pw.length() > 0) {
                    return this.newUser(uid, pw, domain);
                }
                newSubject.getPrivateCredentials().add(cred);
            }
            newSubject.getPrivateCredentials().add(o);
        }
        Iterator it = subject.getPrincipals().iterator();
        List<String> hostList = this.getValidHosts();
        while (it.hasNext()) {
            java.lang.Object o = it.next();
            if (!(o instanceof PFSPrincipal)) continue;
            PFSPrincipal p = (PFSPrincipal)o;
            newSubject.getPrincipals().add((Principal)p);
        }
        newSubject.getPublicCredentials().addAll(subject.getPublicCredentials());
        return this.newAuthenticatedUser(newSubject);
    }

    private void processOptions(Map options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        String correlator = (String)options.get("ARM.InternalCorrelator");
        if (correlator != null) {
            ThreadContext.put((String)"ARM.InternalCorrelator", (String)correlator);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("ARM correlator value: " + correlator);
        }
    }

    private List<String> getValidHosts() {
        String loginConfigAppName = null;
        ArrayList<String> hostList = new ArrayList<String>(32);
        try {
            LocalDiscoveryServiceInterface discoService = DiscoveryService.defaultInstance();
            Class[] authServiceClassArr = new Class[]{AuthenticationServiceInterface.class};
            ServiceTemplate serviceTemplate = new ServiceTemplate(authServiceClassArr);
            AuthenticationServiceInterface authService = (AuthenticationServiceInterface)discoService.findService(serviceTemplate);
            loginConfigAppName = authService.getLoginConfigAppName();
        }
        catch (ServiceException se) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause((Throwable)((java.lang.Object)se));
            throw ise;
        }
        catch (RemoteException re) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(re);
            throw ise;
        }
        Environment environment = this.getEnvironment();
        List<AppConfigurationEntry> entries = environment.getAppConfigurationEntry(loginConfigAppName);
        int numEntries = entries != null ? entries.size() : 0;
        for (int i = 0; i < numEntries; ++i) {
            AppConfigurationEntry entry = entries.get(i);
            Map map = entry.getOptions();
            String authHost = (String)(map = LoginCallbackHandler.getDelegateOptionMap(map)).get("host");
            if (authHost == null) continue;
            hostList.add(authHost.toUpperCase());
        }
        return hostList;
    }

    @Override
    public UserContextInterface newAuthenticatedUser(Subject subject) throws RemoteException, ServiceException, UserInitializationException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(4);
        if (subject == null) {
            subject = Subject.getSubject(AccessController.getContext());
        }
        if (subject == null) {
            throw new ServiceException(RB.getStringResource("UserService.nullsubject.ex.txt"));
        }
        UserContext uc = new UserContext();
        String envKey = "ENVIRONMENT";
        Environment environment = this.getEnvironment();
        uc.putSharedResource(envKey, environment);
        uc.initializeFromSubject(subject);
        this.initializeUserContext(uc, exceptions);
        if (exceptions.size() > 0) {
            UserInitializationException uiex = new UserInitializationException(uc);
            Iterator it = exceptions.iterator();
            while (it.hasNext()) {
                uiex.addException((Exception)it.next());
            }
            throw uiex;
        }
        this.addToUserMap(uc);
        return uc;
    }

    @Override
    public void setChallengeCallbackHandler(RemoteCallbackHandler handler) throws RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        this._handler = handler;
    }

    @Override
    public RemoteCallbackHandler getChallengeCallbackHandler() throws RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("UserService.servicedestroyed.ex.txt"));
        }
        return this._handler;
    }

    @Override
    public void setGroupLoginEnabled(boolean groupLoginFlag) throws ServiceException, RemoteException {
        this._allowGroupLogins = groupLoginFlag;
    }

    @Override
    public boolean getGroupLoginEnabled() throws ServiceException, RemoteException {
        return this._allowGroupLogins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUsers() throws RemoteException {
        if (this._destroyed) {
            return;
        }
        UserService userService = this;
        synchronized (userService) {
            Collection<UserContextInterface> users = this._userMap.values();
            Iterator<UserContextInterface> it = users.iterator();
            while (it.hasNext()) {
                UserContextInterface uci = it.next();
                try {
                    if (!uci.isDestroyed()) continue;
                    it.remove();
                }
                catch (RemoteException ex) {
                    it.remove();
                }
            }
            users = new ArrayList<UserContextInterface>(this._users.values());
            for (UserContextInterface uci : users) {
                try {
                    if (uci == null || !uci.isDestroyed()) continue;
                    this.removeUser(uci);
                }
                catch (RemoteException ex) {
                    Iterator<UserContextInterface> itt = this._users.values().iterator();
                    while (itt.hasNext()) {
                        if (!uci.equals(itt.next())) continue;
                        itt.remove();
                    }
                    continue;
                }
                {
                    break;
                }
            }
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, java.lang.Object arg0) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (java.lang.Object)arg0);
            this.logMessage(level, message, context, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, java.lang.Object arg0, java.lang.Object arg1) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (java.lang.Object)arg0, (java.lang.Object)arg1);
            this.logMessage(level, message, context, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, java.lang.Object arg0, java.lang.Object arg1, java.lang.Object arg2) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (java.lang.Object)arg0, (java.lang.Object)arg1, (java.lang.Object)arg2);
            this.logMessage(level, message, context, null);
        }
    }

    public void logFormat(Level level, String context, ResourceBundle bundle, String key, java.lang.Object arg0, java.lang.Object arg1, java.lang.Object arg2, java.lang.Object arg3) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isEnabled(level)) {
            String message = Message.format((ResourceBundle)bundle, (String)key, (java.lang.Object)arg0, (java.lang.Object)arg1, (java.lang.Object)arg2, (java.lang.Object)arg3);
            this.logMessage(level, message, context, null);
        }
    }

    public void logMessage(Level level, String message) throws RemoteException {
        this.logMessage(level, message, USERSVC_CONTEXT, null);
    }

    public void logMessage(Level level, String message, String context, Throwable t) throws RemoteException {
        Logger logger = LogManager.getLogger((String)context);
        if (logger.isEnabled(level)) {
            if (t == null) {
                this._logger.log(level, message);
            } else {
                this._logger.log(level, message, t);
            }
        }
    }

    @Override
    public int getUserCount() throws ServiceException, RemoteException {
        return this._userMap.size();
    }

    @Override
    public UserContextInterface fromByteArray(byte[] data) throws ServiceException, RemoteException {
        UserContext uc = new UserContext();
        String envKey = "ENVIRONMENT";
        Environment environment = this.getEnvironment();
        uc.putSharedResource(envKey, environment);
        uc.putSharedResource("USERSERVICEID", this.getEntityKey());
        uc.fromByteArray(data);
        this.addToUserMap(uc);
        return uc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetInternalPassword(String host, String port, String username, String oldPassword, String newPassword) throws ServiceException, RemoteException {
        try {
            BridgeServer omrServer = new BridgeServer("0217e202-b560-11db-ad91-001083ff6836", host, Integer.parseInt(port));
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)omrServer);
            ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            try (ConnectionInterface cx = cxf.getConnection("", "");){
                Object obj = cx.getObject();
                IPasswordControl pc = IPasswordControlHelper.narrow((Object)obj);
                pc.ChangePassword(username, oldPassword, newPassword);
            }
        }
        catch (ConnectionFactoryException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUserMap(UserContextInterface userContext) {
        try {
            UserService userService = this;
            synchronized (userService) {
                this._userMap.put(userContext.getUniqueId(), userContext);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserContextInterface getUserByUid(String key) throws RemoteException {
        UserContextInterface uci = null;
        UserService userService = this;
        synchronized (userService) {
            uci = this._userMap.get(key);
        }
        if (uci != null && this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug("Returning user " + uci.getUniqueId() + " -> " + uci.getName());
        }
        return uci;
    }
}

