/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.CLIOptionsConfig;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.CLIOptionsServiceDeployment;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.services.user.RB;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserServiceInitObject;
import com.sas.services.user.UserServiceProfile;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class UserPWChanger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ServiceException {
        block43: {
            Logger logger = LogManager.getLogger(UserPWChanger.class);
            MdStore mdStore = null;
            CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
            Option cliOptionMetaServer = cliOptionsMeta.createOptionMetaServer();
            Option cliOptionMetaPort = cliOptionsMeta.createOptionPort();
            Option cliOptionMetaRepository = cliOptionsMeta.createOptionRepository();
            Option cliOptionIsPrompting = new CLIOptionsConfig().createOptionIsPrompting();
            CLIOptionsServiceDeployment cliDeployment = new CLIOptionsServiceDeployment();
            Option optionDeploymentName = cliDeployment.createOptionDeploymentName();
            optionDeploymentName.setRequired(true);
            Option optionServiceName = cliDeployment.createOptionServiceName();
            optionServiceName.setRequired(true);
            Option optionServiceGroupName = cliDeployment.createOptionServiceGroupName();
            optionServiceGroupName.setRequired(true);
            Option optionApplication = cliDeployment.createOptionServiceApplication();
            Option cliOptionMetaUser = cliOptionsMeta.createOptionUser();
            Option cliOptionPassword = cliOptionsMeta.createOptionPassword();
            Option cliOptionMetaPasswordOnStdin = cliOptionsMeta.createOptionPasswordOnStdin();
            Option cliOptionSecPackageList = cliOptionsMeta.createOptionSecPackageList();
            Option cliOptionSPN = cliOptionsMeta.createOptionSPN();
            String serviceDeploymentName = null;
            String serviceGroupName = null;
            String serviceName = null;
            ServiceException svcException = null;
            try {
                Options options = new Options();
                String userNameParameter = "userName";
                Option optionUserName = new Option("userName", true, RB.getStringResource("UserPWChanger.userNameParameter.desc.txt"));
                optionUserName.setRequired(true);
                optionUserName.setArgName("userName");
                options.addOption(optionUserName);
                String newCredentialParameter = "newCredential";
                Option optionNewCredential = new Option("newCredential", true, RB.getStringResource("UserPWChanger.newCredentialParameter.desc.txt"));
                optionNewCredential.setRequired(true);
                optionNewCredential.setArgName("newCredential");
                options.addOption(optionNewCredential);
                options.addOption(cliOptionMetaServer);
                options.addOption(cliOptionMetaPort);
                options.addOption(cliOptionMetaRepository);
                options.addOption(cliOptionIsPrompting);
                options.addOption(optionApplication);
                options.addOption(optionDeploymentName);
                options.addOption(optionServiceGroupName);
                options.addOption(optionServiceName);
                OptionGroup optionGroupCx = new OptionGroup();
                optionGroupCx.setRequired(true);
                optionGroupCx.addOption(cliOptionMetaUser);
                optionGroupCx.addOption(cliOptionSecPackageList);
                options.addOptionGroup(optionGroupCx);
                options.addOption(cliOptionPassword);
                options.addOption(cliOptionMetaPasswordOnStdin);
                options.addOption(cliOptionSPN);
                String metaPass = null;
                boolean isValid = false;
                CommandLine cmdLine = null;
                try {
                    ServiceDeployment serviceDeployment;
                    ServiceComponent serviceComponent;
                    List<Property> properties;
                    cmdLine = new DefaultParser().parse(options, args);
                    String userName = cmdLine.getOptionValue("userName");
                    String newCredential = cmdLine.getOptionValue("newCredential");
                    String metaHost = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionServer());
                    String metaPort = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPort());
                    String secPackageList = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSecPackageList());
                    String metaSPN = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSPN());
                    String metaUser = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionUser());
                    boolean isPasswordOnStdin = Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPasswordOnStdin()));
                    metaPass = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPassword());
                    serviceName = cmdLine.getOptionValue(optionServiceName.getOpt());
                    serviceGroupName = cmdLine.getOptionValue(optionServiceGroupName.getOpt());
                    serviceDeploymentName = cmdLine.getOptionValue(optionDeploymentName.getOpt());
                    String applicationName = cmdLine.getOptionValue(optionApplication.getOpt());
                    boolean bl = isValid = cmdLine.hasOption(cliOptionsMeta.getNameOfOptionServer()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionPort()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionRepository()) && cmdLine.hasOption("userName") && cmdLine.hasOption("newCredential") && applicationName != null && serviceDeploymentName != null && serviceGroupName != null && serviceName != null && (metaUser != null && (isPasswordOnStdin || metaPass != null) || secPackageList != null);
                    if (!isValid) break block43;
                    HashMap<String, String> metaOptions = new HashMap<String, String>(7);
                    String optionName = cliOptionsMeta.getNameOfOptionServer();
                    metaOptions.put(optionName, metaHost);
                    optionName = cliOptionsMeta.getNameOfOptionPort();
                    metaOptions.put(optionName, metaPort);
                    optionName = cliOptionsMeta.getNameOfOptionRepository();
                    String repositoryName = cmdLine.getOptionValue(optionName);
                    metaOptions.put(optionName, repositoryName);
                    if (secPackageList != null) {
                        optionName = cliOptionsMeta.getNameOfOptionSecPackageList();
                        metaOptions.put(optionName, secPackageList);
                        optionName = cliOptionsMeta.getNameOfOptionSPN();
                        metaOptions.put(optionName, metaSPN);
                    } else {
                        String dashOptionName;
                        optionName = cliOptionsMeta.getNameOfOptionUser();
                        metaOptions.put(optionName, metaUser);
                        if (isPasswordOnStdin && (metaPass = CLIOptionsConfig.getOptionValueFromSystemIn(dashOptionName = '-' + cliOptionsMeta.getNameOfOptionPassword(), Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionIsPrompting.getOpt())) ? Message.format((ResourceBundle)RB.getResources(), (String)"UserPWChanger.specifyMetaPass.fmt.txt", (Object)dashOptionName) : null, null)) == null) {
                            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"UserPWChanger.specifyMetaPass.ex.fmt.txt", (Object)optionName));
                        }
                    }
                    if (metaPass != null) {
                        metaOptions.put(cliOptionsMeta.getNameOfOptionPassword(), metaPass);
                    }
                    if ((properties = ServiceDeployment.getServiceConfigProperties(serviceComponent = (serviceDeployment = new ServiceDeployment(repositoryName, serviceDeploymentName, mdStore = AbstractMetadataSource.createMdStore(false, metaOptions, new Environment()))).getServiceComponent(serviceGroupName, serviceName))).size() == 0) {
                        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"UserPWChanger.serviceComponentNotFound.fmt.txt", (Object)serviceComponent.getName()));
                    }
                    Property property = properties.get(0);
                    TextStore textStore = (TextStore)property.getStoredConfiguration();
                    if (textStore == null) {
                        throw new IllegalArgumentException(RB.getStringResource("UserPWChanger.propertyLacksTextStore.ex.txt"));
                    }
                    UserServiceProfile userServiceProfile = new UserServiceProfile();
                    UserServiceInitObject userServiceConfig = (UserServiceInitObject)userServiceProfile.createServiceConfigForProperty(property);
                    SimpleUserIdentity simpleUserIdentity2 = null;
                    for (SimpleUserIdentity simpleUserIdentity2 : userServiceConfig.getUsers(userName)) {
                        String credentialToUse = newCredential;
                        if (SasPasswordString.isEncoded((String)credentialToUse)) {
                            try {
                                credentialToUse = SasPasswordString.decode((String)credentialToUse);
                            }
                            catch (SasPasswordEncodingException e) {
                                credentialToUse = newCredential;
                            }
                        }
                        simpleUserIdentity2.setCredential(credentialToUse);
                    }
                    textStore.setStoredText(userServiceConfig.toXMLString());
                    textStore.updateMetadataAll();
                    if (logger.isInfoEnabled()) {
                        logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UserPWChanger.passwordModified.fmt.txt", (Object)userName, (Object)applicationName, (Object)serviceDeploymentName, (Object)serviceGroupName, (Object)serviceName));
                    }
                }
                finally {
                    metaPass = null;
                    if (!isValid) {
                        StringBuffer sb = new StringBuffer();
                        String nextOption = "> -";
                        sb.append(UserPWChanger.class.getName());
                        sb.append(" -");
                        sb.append(optionUserName.getOpt());
                        sb.append(" <");
                        sb.append(optionUserName.getArgName());
                        sb.append("> -");
                        sb.append(optionNewCredential.getOpt());
                        sb.append(" <");
                        sb.append(optionNewCredential.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaServer.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaServer.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaPort.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPort.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaRepository.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaRepository.getArgName());
                        sb.append("> -");
                        sb.append(optionApplication.getOpt());
                        sb.append(" [<");
                        sb.append(optionApplication.getArgName());
                        sb.append(">] -");
                        sb.append(optionDeploymentName.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentName.getArgName());
                        sb.append('>');
                        sb.append(optionServiceGroupName.getOpt());
                        sb.append(" <");
                        sb.append(optionServiceGroupName.getArgName());
                        sb.append('>');
                        sb.append(optionServiceName.getOpt());
                        sb.append(" <");
                        sb.append(optionServiceName.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionMetaUser.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaUser.getArgName());
                        sb.append("> [[-");
                        sb.append(cliOptionPassword.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionPassword.getArgName());
                        sb.append(">] | [-");
                        sb.append(cliOptionMetaPasswordOnStdin.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPasswordOnStdin.getArgName());
                        sb.append(">]] | [-");
                        sb.append(cliOptionSecPackageList.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSecPackageList.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionSPN.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSPN.getArgName());
                        sb.append(">]]");
                        new HelpFormatter().printHelp(sb.toString(), options);
                    }
                }
            }
            catch (MdException e) {
                svcException = new ServiceException(e);
            }
            catch (ParseException e) {
                svcException = new ServiceException(e);
            }
            catch (RemoteException e) {
                svcException = new ServiceException(e);
            }
            catch (IllegalArgumentException e) {
                svcException = new ServiceException(e);
            }
            catch (ServiceException e) {
                svcException = e;
            }
            finally {
                cliOptionPassword = null;
                cliOptionMetaUser = null;
                if (mdStore != null) {
                    try {
                        mdStore.getFactory().dispose();
                        mdStore.dispose();
                    }
                    catch (RemoteException e) {
                        logger.error(RB.getStringResource("UserPWChanger.disposeFactory.ex.txt"), (Throwable)e);
                    }
                }
                if (svcException == null) break block43;
                logger.error(RB.getStringResource("UserPWChanger.main.ex.txt"), (Throwable)((Object)svcException));
                throw svcException;
            }
        }
    }
}

